/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.client.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface IArmorRendererBase<T extends LivingEntity> {
    public static final HashMap<ItemLike, IArmorRendererBase<? extends LivingEntity>> RENDERERS = new HashMap();

    public HumanoidModel<T> getHumanoidArmorModel(LivingEntity var1, ItemStack var2, EquipmentSlot var3, HumanoidModel<T> var4);

    public ResourceLocation getArmorTexture(ItemStack var1, Entity var2, EquipmentSlot var3);

    default public void render(PoseStack matrices, MultiBufferSource vertexConsumers, LivingEntity entity, EquipmentSlot slot, int light, ItemStack stack, HumanoidModel<T> defaultModel) {
        HumanoidModel<T> armorModel = this.getHumanoidArmorModel(entity, stack, slot, defaultModel);
        defaultModel.m_102872_(armorModel);
        armorModel.f_102808_.f_104207_ = slot == EquipmentSlot.HEAD;
        armorModel.f_102809_.f_104207_ = slot == EquipmentSlot.HEAD;
        armorModel.f_102810_.f_104207_ = slot == EquipmentSlot.CHEST;
        armorModel.f_102812_.f_104207_ = slot == EquipmentSlot.CHEST;
        armorModel.f_102811_.f_104207_ = slot == EquipmentSlot.CHEST;
        armorModel.f_102814_.f_104207_ = slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
        armorModel.f_102813_.f_104207_ = slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
        VertexConsumer consumer = vertexConsumers.m_6299_(RenderType.m_110431_((ResourceLocation)this.getArmorTexture(stack, (Entity)entity, slot)));
        armorModel.m_7695_(matrices, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static <T extends LivingEntity> void register(IArmorRendererBase<T> renderer, ItemLike ... items) {
        Arrays.stream(items).forEach(x -> RENDERERS.put((ItemLike)x, renderer));
    }
}

