/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.powerfuljs.capabilities.forge.mods.pnc;

import com.prunoideae.powerfuljs.capabilities.forge.CapabilityBuilderForge;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class CapabilityAir {
    public static final String AIR_TAG = "pnc:air";

    public ItemStackBuilder itemStack(int capacity, float maxPressure) {
        return new ItemStackBuilder(capacity, maxPressure);
    }

    public ItemStackBuilderCustom itemStackCustom() {
        return new ItemStackBuilderCustom();
    }

    public static class ItemStackBuilder
    extends CapabilityBuilderForge<ItemStack, IAirHandlerItem> {
        private final int capacity;
        private final float maxPressure;

        public ItemStackBuilder(int capacity, float maxPressure) {
            this.capacity = capacity;
            this.maxPressure = maxPressure;
        }

        @Override
        public IAirHandlerItem getCapability(final ItemStack instance) {
            return new IAirHandlerItem(){

                @NotNull
                public ItemStack getContainer() {
                    return instance;
                }

                public float getPressure() {
                    return (float)this.getVolume() / (float)this.getAir();
                }

                public int getAir() {
                    return instance.m_41784_().m_128451_(CapabilityAir.AIR_TAG);
                }

                public void addAir(int amount) {
                    instance.m_41784_().m_128405_(CapabilityAir.AIR_TAG, this.getAir() + amount);
                }

                public int getBaseVolume() {
                    return capacity;
                }

                public void setBaseVolume(int newBaseVolume) {
                }

                public int getVolume() {
                    return capacity;
                }

                public float maxPressure() {
                    return maxPressure;
                }
            };
        }

        @Override
        public Capability<IAirHandlerItem> getCapabilityKey() {
            return PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:air_pnc");
        }
    }

    public static class ItemStackBuilderCustom
    extends CapabilityBuilderForge<ItemStack, IAirHandlerItem> {
        private Function<ItemStack, Float> getPressure;
        private ToIntFunction<ItemStack> getAir;
        private BiConsumer<ItemStack, Integer> addAir;
        private ToIntFunction<ItemStack> getBaseVolume;
        private BiConsumer<ItemStack, Integer> setBaseVolume;
        private ToIntFunction<ItemStack> getVolume;
        private Function<ItemStack, Float> maxPressure;

        public ItemStackBuilderCustom getPressure(Function<ItemStack, Float> getPressure) {
            this.getPressure = getPressure;
            return this;
        }

        public ItemStackBuilderCustom getAir(ToIntFunction<ItemStack> getAir) {
            this.getAir = getAir;
            return this;
        }

        public ItemStackBuilderCustom addAir(BiConsumer<ItemStack, Integer> addAir) {
            this.addAir = addAir;
            return this;
        }

        public ItemStackBuilderCustom getBaseVolume(ToIntFunction<ItemStack> getBaseVolume) {
            this.getBaseVolume = getBaseVolume;
            return this;
        }

        public ItemStackBuilderCustom setBaseVolume(BiConsumer<ItemStack, Integer> setBaseVolume) {
            this.setBaseVolume = setBaseVolume;
            return this;
        }

        public ItemStackBuilderCustom getVolume(ToIntFunction<ItemStack> getVolume) {
            this.getVolume = getVolume;
            return this;
        }

        public ItemStackBuilderCustom maxPressure(Function<ItemStack, Float> maxPressure) {
            this.maxPressure = maxPressure;
            return this;
        }

        @Override
        public IAirHandlerItem getCapability(final ItemStack instance) {
            return new IAirHandlerItem(){

                @NotNull
                public ItemStack getContainer() {
                    return instance;
                }

                public float getPressure() {
                    return getPressure == null ? 0.0f : getPressure.apply(instance).floatValue();
                }

                public int getAir() {
                    return getAir == null ? 0 : getAir.applyAsInt(instance);
                }

                public void addAir(int amount) {
                    if (addAir != null) {
                        addAir.accept(instance, amount);
                    }
                }

                public int getBaseVolume() {
                    return getBaseVolume == null ? 1 : getBaseVolume.applyAsInt(instance);
                }

                public void setBaseVolume(int newBaseVolume) {
                    if (setBaseVolume != null) {
                        setBaseVolume.accept(instance, newBaseVolume);
                    }
                }

                public int getVolume() {
                    return getVolume == null ? 1 : getVolume.applyAsInt(instance);
                }

                public float maxPressure() {
                    return maxPressure == null ? 1.0f : maxPressure.apply(instance).floatValue();
                }
            };
        }

        @Override
        public Capability<IAirHandlerItem> getCapabilityKey() {
            return PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:air_pnc_item_custom");
        }
    }
}

