/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.error1015.somanyenchantments.enchantments.RegisterEnchantments;

public class EventHandler {
    private static final ThreadLocal<Boolean> isCactus = ThreadLocal.withInitial(() -> Boolean.FALSE);

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        List originalDrops;
        BlockState state;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        if (!heldItem.m_41735_(state = event.getState())) {
            return;
        }
        Level world = event.getPlayer().m_9236_();
        BlockPos pos = event.getPos();
        if (heldItem.getEnchantmentLevel((Enchantment)RegisterEnchantments.AUTO_SMELT.get()) > 0) {
            originalDrops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            for (ItemStack drop : originalDrops) {
                Optional<ItemStack> oSmelted = EventHandler.getSmeltingResult(drop, world);
                if (oSmelted.isPresent()) {
                    ItemStack smelted = oSmelted.get();
                    if (!smelted.m_41619_()) {
                        int fortune = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44987_, (LivingEntity)player);
                        double a = fortune + 2;
                        double rn = Math.random();
                        if (rn >= 1.0 / a) {
                            int b = (int)(rn * (double)(fortune + 1));
                            for (int i = 0; i < b; ++i) {
                                newDrops.add(smelted.m_41777_());
                            }
                        }
                        newDrops.add(smelted.m_41777_());
                        continue;
                    }
                    newDrops.add(drop);
                    continue;
                }
                newDrops.add(drop);
            }
            world.m_46961_(pos, false);
            for (ItemStack stack : newDrops) {
                if (stack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                world.m_7967_((Entity)itemEntity);
            }
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        }
        if (player.m_21205_().getEnchantmentLevel((Enchantment)RegisterEnchantments.DIG_COLLECT.get()) > 0) {
            originalDrops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            for (ItemStack itemStack : originalDrops) {
                if (itemStack.m_41720_() instanceof BlockItem) continue;
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                for (int i = 0; i < player.m_21205_().getEnchantmentLevel((Enchantment)RegisterEnchantments.DIG_COLLECT.get()); ++i) {
                    world.m_7967_((Entity)itemEntity.m_32066_());
                }
            }
        }
    }

    @SubscribeEvent
    public void attackEntity(LootingLevelEvent event) {
        if (event.getDamageSource() != null) {
            Entity entity = event.getDamageSource().m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int betterLoot = livingEntity.m_21205_().getEnchantmentLevel((Enchantment)RegisterEnchantments.BETTER_LOOT.get());
                if (betterLoot > 0) {
                    event.setLootingLevel(event.getLootingLevel() + 3 + betterLoot * 2);
                }
            } else {
                LivingEntity livingEntity;
                Entity betterLoot = event.getDamageSource().m_7640_();
                if (betterLoot instanceof LivingEntity && (betterLoot = (livingEntity = (LivingEntity)betterLoot).m_21205_().getEnchantmentLevel((Enchantment)RegisterEnchantments.BETTER_LOOT.get())) > 0) {
                    event.setLootingLevel(event.getLootingLevel() + 3 + betterLoot * 2);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingHurtEvent event) {
        LivingEntity targetedEntity = event.getEntity();
        Level level = targetedEntity.m_9236_();
        DamageSource damageSource = event.getSource();
        LivingEntity attacker = this.getAttacker(damageSource);
        if (attacker == null) {
            return;
        }
        this.applyPurificationBladeEffect(targetedEntity, level, damageSource, attacker, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onLivingHurt(LivingDamageEvent event) {
        if (isCactus.get().booleanValue()) {
            return;
        }
        LivingEntity targetedEntity = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            int hitLevel = attacker.m_21205_().getEnchantmentLevel((Enchantment)RegisterEnchantments.HIT_DAMAGE.get());
            DamageSource hitSource = new DamageSource(attacker.m_9236_().m_269111_().m_269325_().m_269150_(), (Entity)attacker);
            if (hitLevel > 0) {
                isCactus.set(true);
                try {
                    targetedEntity.f_19802_ = 0;
                    targetedEntity.m_6469_(hitSource, event.getAmount() * (float)hitLevel * 0.25f);
                }
                finally {
                    isCactus.set(false);
                }
            }
        }
    }

    private LivingEntity getAttacker(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            return attacker;
        }
        entity = damageSource.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            return attacker;
        }
        return null;
    }

    private void applyPurificationBladeEffect(LivingEntity targetedEntity, Level level, DamageSource damageSource, LivingEntity attacker, LivingHurtEvent event) {
        Random RANDOM = new Random();
        ItemStack handItem = attacker.m_21205_();
        int purificationBladeLevel = handItem.getEnchantmentLevel((Enchantment)RegisterEnchantments.PURIFICATION_BLADE.get());
        if (purificationBladeLevel > 0 && !damageSource.m_276093_(DamageTypes.f_268530_) && !damageSource.m_276093_(DamageTypes.f_268515_)) {
            double probability = Math.max(0.0, Math.min(1.0, 0.9 - (double)purificationBladeLevel * 0.06));
            if (RANDOM.nextDouble() > probability) {
                return;
            }
            float damageAmount = event.getAmount();
            event.setAmount(damageAmount * 1.2f);
            targetedEntity.f_19802_ = 0;
            targetedEntity.m_6469_(level.m_269111_().m_269104_((Entity)attacker, (Entity)attacker), (float)purificationBladeLevel * 0.75f + 1.25f);
            targetedEntity.f_19802_ = 0;
            ArrayList activeEffects = new ArrayList(targetedEntity.m_21220_());
            if (!activeEffects.isEmpty()) {
                MobEffectInstance effectToRemove = (MobEffectInstance)activeEffects.get(RANDOM.nextInt(activeEffects.size()));
                targetedEntity.m_21195_(effectToRemove.m_19544_());
            }
        }
    }

    public static Optional<ItemStack> getSmeltingResult(ItemStack input, Level level) {
        RecipeManager recipeManager = level.m_7465_();
        RegistryAccess registryAccess = level.m_9598_();
        SimpleContainer inventoryWrapper = new SimpleContainer(new ItemStack[]{input});
        Optional recipe = recipeManager.m_44015_(RecipeType.f_44108_, (Container)inventoryWrapper, level);
        if (recipe.isPresent() && recipe.get() instanceof AbstractCookingRecipe) {
            return Optional.of(((Recipe)recipe.get()).m_8043_(registryAccess));
        }
        return Optional.empty();
    }
}

