/*
 * Decompiled with CFR 0.152.
 */
package org.error1015.somanyenchantments.enchantments;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.registries.ForgeRegistries;
import org.error1015.somanyenchantments.config.EnchantmentsConfig;
import org.jetbrains.annotations.NotNull;

public class BasicEnchantment
extends Enchantment {
    private final String enchantName;

    protected BasicEnchantment(EnchantmentCategory pCategory, EquipmentSlot[] pApplicableSlots, String pName) {
        super(EnchantmentsConfig.getRarityByConfig("purification_blade"), pCategory, pApplicableSlots);
        this.enchantName = pName;
    }

    public boolean m_6591_() {
        return EnchantmentsConfig.isTreasure(this.enchantName);
    }

    public boolean m_6592_() {
        return EnchantmentsConfig.couldFound(this.enchantName);
    }

    public boolean m_6594_() {
        return EnchantmentsConfig.couldTrade(this.enchantName);
    }

    public int m_6586_() {
        return EnchantmentsConfig.getMaxLevel(this.enchantName);
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack) {
        return EnchantmentsConfig.couldEnchantTable(this.enchantName) && super.canApplyAtEnchantingTable(stack);
    }

    public boolean m_6081_(@NotNull ItemStack pStack) {
        return EnchantmentsConfig.couldAnvil(this.enchantName);
    }

    public boolean m_5975_(@NotNull Enchantment pOther) {
        boolean result = true;
        for (String location : EnchantmentsConfig.getUnableCompatibility(this.enchantName)) {
            if (pOther != ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(location))) continue;
            result = false;
            break;
        }
        return super.m_5975_(pOther) && result;
    }
}

