/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.interfaces.ITextFieldConfig;
import com.iafenvoy.jupiter.render.widget.TextFieldWithErrorWidget;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TextFieldWidgetBuilder<T>
extends WidgetBuilder<T> {
    private final ITextFieldConfig textFieldConfig;
    @Nullable
    private TextFieldWithErrorWidget widget;

    public TextFieldWidgetBuilder(IConfigEntry<T> config) {
        super(config);
        ITextFieldConfig t;
        if (!(config instanceof ITextFieldConfig)) {
            throw new IllegalArgumentException("TextFieldWidgetBuilder only accept ITextFieldConfig");
        }
        this.textFieldConfig = t = (ITextFieldConfig)((Object)config);
    }

    @Override
    public void addCustomElements(Consumer<AbstractWidget> appender, int x, int y, int width, int height) {
        this.widget = new TextFieldWithErrorWidget(((Minecraft)TextFieldWidgetBuilder.CLIENT.get()).f_91062_, x, y, width, height);
        this.widget.m_94144_(this.textFieldConfig.valueAsString());
        this.widget.m_94151_(s -> {
            try {
                this.textFieldConfig.setValueFromString((String)s);
                this.canSave = true;
                this.widget.setHasError(false);
            }
            catch (Exception ignored) {
                this.canSave = false;
                this.widget.setHasError(true);
                this.setCanReset(true);
            }
        });
        appender.accept((AbstractWidget)this.widget);
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        if (this.widget == null) {
            return;
        }
        this.widget.f_93624_ = visible;
        this.widget.m_253211_(y);
    }

    @Override
    public void refresh() {
        if (this.widget == null) {
            return;
        }
        this.widget.m_94144_(this.textFieldConfig.valueAsString());
    }
}

