/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FakeConfigContainer;
import com.iafenvoy.jupiter.config.container.FileConfigContainer;
import com.iafenvoy.jupiter.network.ClientConfigNetwork;
import com.iafenvoy.jupiter.render.screen.ClientConfigScreen;
import com.iafenvoy.jupiter.render.screen.ServerConfigScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ConfigSelectScreen<S extends FileConfigContainer, C extends FileConfigContainer>
extends Screen {
    private final Screen parent;
    private final S serverConfig;
    @Nullable
    private final C clientConfig;
    @Nullable
    private FakeConfigContainer fakeServerConfig;

    public ConfigSelectScreen(Component title, Screen parent, S serverConfig, @Nullable C clientConfig) {
        super(title);
        this.parent = parent;
        this.serverConfig = serverConfig;
        this.clientConfig = clientConfig;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"jupiter.screen.back"), button -> {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(x - 100, y - 25 - 10, 200, 20).m_253136_());
        Button serverButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"jupiter.screen.server_config"), button -> {
            assert (this.f_96541_ != null);
            assert (this.serverConfig != null);
            this.f_96541_.m_91152_((Screen)new ServerConfigScreen(this, this.getServerConfig()));
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"jupiter.screen.check_server"))).m_252987_(x - 100, y - 10, 200, 20).m_253136_());
        serverButton.f_93623_ = true;
        Button clientButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"jupiter.screen.client_config"), button -> {
            assert (this.f_96541_ != null);
            assert (this.clientConfig != null);
            this.f_96541_.m_91152_((Screen)new ClientConfigScreen(this, (AbstractConfigContainer)this.clientConfig));
        }).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.clientConfig != null ? "jupiter.screen.open_client" : "jupiter.screen.disable_client")))).m_252987_(x - 100, y + 25 - 10, 200, 20).m_253136_());
        boolean bl = clientButton.f_93623_ = this.clientConfig != null;
        if (this.connectedToDedicatedServer()) {
            this.fakeServerConfig = new FakeConfigContainer((AbstractConfigContainer)this.serverConfig);
            serverButton.f_93623_ = false;
            ClientConfigNetwork.startConfigSync(((AbstractConfigContainer)this.serverConfig).getConfigId(), nbt -> {
                if (nbt == null) {
                    serverButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"jupiter.screen.disable_server")));
                } else {
                    try {
                        assert (this.fakeServerConfig != null);
                        this.fakeServerConfig.deserializeNbt((Tag)nbt);
                        serverButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"jupiter.screen.open_server")));
                        serverButton.f_93623_ = true;
                    }
                    catch (Exception e) {
                        Jupiter.LOGGER.error("Failed to parse server config data from server: {}", (Object)((AbstractConfigContainer)this.serverConfig).getConfigId(), (Object)e);
                        serverButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"jupiter.screen.error_server")));
                    }
                }
            });
        } else {
            serverButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"jupiter.screen.open_server")));
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        assert (this.f_96541_ != null);
        context.m_280653_(this.f_96541_.f_91062_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 2 - 50, -1);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return true;
    }

    private AbstractConfigContainer getServerConfig() {
        if (!this.connectedToDedicatedServer()) {
            return this.serverConfig;
        }
        assert (this.fakeServerConfig != null);
        return this.fakeServerConfig;
    }

    public boolean connectedToDedicatedServer() {
        assert (this.f_96541_ != null);
        ClientPacketListener handler = this.f_96541_.m_91403_();
        IntegratedServer server = this.f_96541_.m_91092_();
        return handler != null && handler.m_104910_().m_129536_() && (server == null || server.m_6992_());
    }
}

