/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.Nullable;

public class ServerConfigManager
implements ResourceManagerReloadListener {
    private static final Map<ResourceLocation, ServerConfigHolder> CONFIGS = new HashMap<ResourceLocation, ServerConfigHolder>();

    public static void registerServerConfig(AbstractConfigContainer data, PermissionChecker checker) {
        CONFIGS.put(data.getConfigId(), new ServerConfigHolder(data, checker));
    }

    @Nullable
    public static AbstractConfigContainer getConfig(ResourceLocation id) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) {
            return null;
        }
        return holder.data;
    }

    public static boolean checkPermission(ResourceLocation id, MinecraftServer server, ServerPlayer player) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) {
            return false;
        }
        return holder.checker.check(server, player);
    }

    public void m_6213_(ResourceManager manager) {
        CONFIGS.values().forEach(x -> x.data.load());
        Jupiter.LOGGER.info("Successfully reload {} server config(s).", (Object)CONFIGS.size());
    }

    private record ServerConfigHolder(AbstractConfigContainer data, PermissionChecker checker) {
    }

    @FunctionalInterface
    public static interface PermissionChecker {
        public static final PermissionChecker ALWAYS_TRUE = (server, player) -> true;
        public static final PermissionChecker ALWAYS_FALSE = (server, player) -> false;
        public static final PermissionChecker IS_DEDICATE_SERVER = (server, player) -> server.m_6982_();
        public static final PermissionChecker IS_LOCAL_GAME = (server, player) -> !IS_DEDICATE_SERVER.check(server, player);
        public static final PermissionChecker IS_OPERATOR = (server, player) -> IS_LOCAL_GAME.check(server, player) || player.m_20310_(server.m_7022_());

        public boolean check(MinecraftServer var1, ServerPlayer var2);
    }
}

