/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.CommonTags;
import com.iafenvoy.iceandfire.world.structure.DragonRoostStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class IceDragonRoostStructure
extends DragonRoostStructure {
    public static final Codec<IceDragonRoostStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IceDragonRoostStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, IceDragonRoostStructure::new)).codec();

    protected IceDragonRoostStructure(Structure.StructureSettings config) {
        super(config);
    }

    @Override
    protected DragonRoostStructure.DragonRoostPiece createPiece(BoundingBox boundingBox, boolean isMale) {
        return new IceDragonRoostPiece(0, boundingBox, (Block)IafBlocks.SILVER_PILE.get(), isMale);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.ICE_DRAGON_ROOST.get();
    }

    public static class IceDragonRoostPiece
    extends DragonRoostStructure.DragonRoostPiece {
        private static final ResourceLocation DRAGON_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/ice_dragon_roost");

        protected IceDragonRoostPiece(int length, BoundingBox boundingBox, Block treasureBlock, boolean isMale) {
            super((StructurePieceType)IafStructurePieces.ICE_DRAGON_ROOST.get(), length, boundingBox, treasureBlock, isMale);
        }

        public IceDragonRoostPiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.ICE_DRAGON_ROOST.get(), nbt);
        }

        @Override
        protected EntityType<? extends EntityDragonBase> getDragonType() {
            return (EntityType)IafEntities.ICE_DRAGON.get();
        }

        @Override
        protected ResourceLocation getRoostLootTable() {
            return DRAGON_CHEST;
        }

        @Override
        protected BlockState transform(BlockState state) {
            Block block = null;
            if (state.m_60713_(Blocks.f_50440_)) {
                block = (Block)IafBlocks.FROZEN_GRASS.get();
            } else if (state.m_60713_(Blocks.f_152481_)) {
                block = (Block)IafBlocks.FROZEN_DIRT_PATH.get();
            } else if (state.m_204336_(CommonTags.Blocks.GRAVEL)) {
                block = (Block)IafBlocks.FROZEN_GRAVEL.get();
            } else if (state.m_204336_(BlockTags.f_144274_)) {
                block = (Block)IafBlocks.FROZEN_DIRT.get();
            } else if (state.m_204336_(CommonTags.Blocks.STONE)) {
                block = (Block)IafBlocks.FROZEN_STONE.get();
            } else if (state.m_204336_(CommonTags.Blocks.COBBLESTONE)) {
                block = (Block)IafBlocks.FROZEN_COBBLESTONE.get();
            } else if (state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13090_)) {
                block = (Block)IafBlocks.FROZEN_SPLINTERS.get();
            } else if (state.m_60713_(Blocks.f_50034_) || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13041_) || state.m_204336_(BlockTags.f_13073_)) {
                block = Blocks.f_50016_;
            }
            if (block != null) {
                return block.m_49966_();
            }
            return state;
        }

        @Override
        protected void handleCustomGeneration(WorldGenLevel world, BlockPos origin, RandomSource random, BlockPos position, double distance) {
            if (random.m_188503_(1000) == 0) {
                this.generateRoostPile(world, random, this.getSurfacePosition(world, position), (Block)IafBlocks.DRAGON_ICE.get());
            }
        }
    }
}

