/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.structure.DragonCaveStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class IceDragonCaveStructure
extends DragonCaveStructure {
    public static final Codec<IceDragonCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IceDragonCaveStructure.m_226567_((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, IceDragonCaveStructure::new)).codec();

    protected IceDragonCaveStructure(Structure.StructureSettings config) {
        super(config);
    }

    @Override
    protected DragonCaveStructure.DragonCavePiece createPiece(BoundingBox boundingBox, boolean male, BlockPos offset, int y, long seed) {
        return new IceDragonCavePiece(0, boundingBox, male, offset, y, seed);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.ICE_DRAGON_CAVE.get();
    }

    public static class IceDragonCavePiece
    extends DragonCaveStructure.DragonCavePiece {
        public static final ResourceLocation ICE_DRAGON_CHEST = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/ice_dragon_female_cave");
        public static final ResourceLocation ICE_DRAGON_CHEST_MALE = ResourceLocation.m_214293_((String)"iceandfire", (String)"chest/ice_dragon_male_cave");

        protected IceDragonCavePiece(int length, BoundingBox boundingBox, boolean male, BlockPos offset, int y, long seed) {
            super((StructurePieceType)IafStructurePieces.ICE_DRAGON_CAVE.get(), length, boundingBox, male, offset, y, seed);
        }

        public IceDragonCavePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.ICE_DRAGON_CAVE.get(), nbt);
        }

        @Override
        protected TagKey<Block> getOreTag() {
            return IafBlockTags.ICE_DRAGON_CAVE_ORES;
        }

        @Override
        protected DragonCaveStructure.WorldGenCaveStalactites getCeilingDecoration() {
            return new DragonCaveStructure.WorldGenCaveStalactites((Block)IafBlocks.FROZEN_STONE.get(), 3);
        }

        @Override
        protected BlockState getTreasurePile() {
            return ((Block)IafBlocks.SILVER_PILE.get()).m_49966_();
        }

        @Override
        protected BlockState getPaletteBlock(RandomSource random) {
            return ((Block)(random.m_188499_() ? IafBlocks.FROZEN_STONE : IafBlocks.FROZEN_COBBLESTONE).get()).m_49966_();
        }

        @Override
        protected ResourceLocation getChestTable(boolean male) {
            return male ? ICE_DRAGON_CHEST_MALE : ICE_DRAGON_CHEST;
        }

        @Override
        protected EntityType<? extends EntityDragonBase> getDragonType() {
            return (EntityType)IafEntities.ICE_DRAGON.get();
        }
    }
}

