/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class DragonRoostStructure
extends Structure {
    protected DragonRoostStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation blockRotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BlockPos blockPos = this.m_226582_(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.m_142679_((StructurePiece)this.createPiece(new BoundingBox(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), context.f_226626_().m_188499_()))));
    }

    protected abstract DragonRoostPiece createPiece(BoundingBox var1, boolean var2);

    protected static abstract class DragonRoostPiece
    extends StructurePiece {
        protected final Block treasureBlock;
        private final boolean isMale;

        protected DragonRoostPiece(StructurePieceType type, int length, BoundingBox boundingBox, Block treasureBlock, boolean isMale) {
            super(type, length, boundingBox);
            this.treasureBlock = treasureBlock;
            this.isMale = isMale;
        }

        public DragonRoostPiece(StructurePieceType type, CompoundTag nbt) {
            super(type, nbt);
            this.treasureBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)nbt.m_128461_("treasureBlock")));
            this.isMale = nbt.m_128471_("isMale");
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
            nbt.m_128359_("treasureBlock", BuiltInRegistries.f_256975_.m_7981_((Object)this.treasureBlock).toString());
            nbt.m_128379_("isMale", this.isMale);
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            int radius = 12 + random.m_188503_(8);
            this.spawnDragon(world, pivot, random, radius, this.isMale);
            this.generateSurface(world, pivot, random, radius);
            this.generateShell(world, pivot, random, radius);
            this.hollowOut(world, pivot, radius -= 2);
            this.generateDecoration(world, pivot, random, radius += 15, this.isMale);
        }

        protected void generateRoostPile(WorldGenLevel level, RandomSource random, BlockPos position, Block block) {
            int radius = random.m_188503_(4);
            for (int i = 0; i < radius; ++i) {
                int layeredRadius = radius - i;
                double circularArea = this.getCircularArea(radius);
                BlockPos up = position.m_6630_(i);
                for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)up.m_7918_(-layeredRadius, 0, -layeredRadius), (BlockPos)up.m_7918_(layeredRadius, 0, layeredRadius)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                    if (!(blockpos.m_123331_((Vec3i)position) <= circularArea)) continue;
                    level.m_7731_(blockpos, block.m_49966_(), 2);
                }
            }
        }

        protected double getCircularArea(int radius, int height) {
            double area = (float)(radius + height + radius) * 0.333f + 0.5f;
            return Mth.m_14107_((double)(area * area));
        }

        protected double getCircularArea(int radius) {
            double area = (float)(radius + radius) * 0.333f + 0.5f;
            return Mth.m_14107_((double)(area * area));
        }

        protected BlockPos getSurfacePosition(WorldGenLevel level, BlockPos position) {
            return level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position);
        }

        protected BlockState transform(Block block) {
            return this.transform(block.m_49966_());
        }

        private void generateDecoration(WorldGenLevel world, BlockPos origin, RandomSource random, int radius, boolean isMale) {
            int height = radius / 5;
            double circularArea = this.getCircularArea(radius, height);
            BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, -height, -radius), (BlockPos)origin.m_7918_(radius, height, radius)).map(BlockPos::m_7949_).forEach(position -> {
                if (position.m_123331_((Vec3i)origin) <= circularArea) {
                    BlockEntity blockEntity;
                    BlockPos surfacePosition;
                    boolean wasPlaced;
                    BlockState transformed;
                    BlockState state;
                    double distance = position.m_123331_((Vec3i)origin) / circularArea;
                    if (!world.m_46859_(origin) && random.m_188500_() > distance * 0.5 && !((state = world.m_8055_(position)).m_60734_() instanceof BaseEntityBlock) && state.m_60800_((BlockGetter)world, position) >= 0.0f && (transformed = this.transform(state)) != state) {
                        world.m_7731_(position, transformed, 2);
                    }
                    this.handleCustomGeneration(world, origin, random, (BlockPos)position, distance);
                    if (distance > 0.5 && random.m_188503_(1000) == 0) {
                        this.generateBoulder((LevelAccessor)world, random, this.getSurfacePosition(world, (BlockPos)position), this.transform(Blocks.f_50652_).m_60734_(), random.m_188503_(3), true);
                    }
                    if (distance < 0.3 && random.m_188503_(isMale ? 200 : 300) == 0) {
                        this.generateTreasurePile(world, random, (BlockPos)position);
                    }
                    if (distance < 0.3 && random.m_188503_(isMale ? 500 : 700) == 0 && (wasPlaced = world.m_7731_(surfacePosition = world.m_5452_(Heightmap.Types.WORLD_SURFACE, position), (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)GenerationConstants.HORIZONTALS[random.m_188503_(3)]), 2)) && (blockEntity = world.m_7702_(surfacePosition)) instanceof ChestBlockEntity) {
                        ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                        chest.m_59626_(this.getRoostLootTable(), random.m_188505_());
                    }
                    if (random.m_188503_(5000) == 0) {
                        this.generateArch((LevelAccessor)world, random, this.getSurfacePosition(world, (BlockPos)position), this.transform(Blocks.f_50652_).m_60734_());
                    }
                }
            });
        }

        public void generateBoulder(LevelAccessor worldIn, RandomSource rand, BlockPos position, Block block, int startRadius, boolean replaceAir) {
            while (position.m_123342_() > 3) {
                if (worldIn.m_46859_(position.m_7495_())) {
                    position = position.m_7495_();
                    continue;
                }
                Block b = worldIn.m_8055_(position.m_7495_()).m_60734_();
                if (b == Blocks.f_50034_ || b == Blocks.f_50493_ || b == Blocks.f_50069_) break;
                position = position.m_7495_();
            }
            if (position.m_123342_() > 3) {
                for (int i = 0; startRadius >= 0 && i < 3; ++i) {
                    int j = startRadius + rand.m_188503_(2);
                    int k = startRadius + rand.m_188503_(2);
                    int l = startRadius + rand.m_188503_(2);
                    float f = (float)(j + k + l) * 0.333f + 0.5f;
                    for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)position.m_7918_(-j, -k, -l), (BlockPos)position.m_7918_(j, k, l)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                        if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f)) || !replaceAir && !worldIn.m_8055_(blockpos).m_60815_()) continue;
                        worldIn.m_7731_(blockpos, block.m_49966_(), 2);
                    }
                    position = position.m_7918_(-(startRadius + 1) + rand.m_188503_(2 + startRadius * 2), -rand.m_188503_(2), -(startRadius + 1) + rand.m_188503_(2 + startRadius * 2));
                }
            }
        }

        private void generateArch(LevelAccessor worldIn, RandomSource rand, BlockPos position, Block block) {
            int height = 3 + rand.m_188503_(3);
            int width = Math.min(3, height - 2);
            Direction direction = GenerationConstants.HORIZONTALS[rand.m_188503_(GenerationConstants.HORIZONTALS.length - 1)];
            boolean diagonal = rand.m_188499_();
            for (int i = 0; i < height; ++i) {
                worldIn.m_7731_(position.m_6630_(i), block.m_49966_(), 2);
            }
            BlockPos offsetPos = position;
            int placedWidths = 0;
            for (int i = 0; i < width; ++i) {
                offsetPos = position.m_6630_(height).m_5484_(direction, i);
                if (diagonal) {
                    offsetPos = position.m_6630_(height).m_5484_(direction, i).m_5484_(direction.m_122427_(), i);
                }
                if (placedWidths < width - 1 || rand.m_188499_()) {
                    worldIn.m_7731_(offsetPos, block.m_49966_(), 2);
                }
                ++placedWidths;
            }
            while (worldIn.m_46859_(offsetPos.m_7495_()) && offsetPos.m_123342_() > 0) {
                worldIn.m_7731_(offsetPos.m_7495_(), block.m_49966_(), 2);
                offsetPos = offsetPos.m_7495_();
            }
        }

        private void hollowOut(WorldGenLevel world, BlockPos origin, int radius) {
            int height = 2;
            double circularArea = this.getCircularArea(radius, height);
            BlockPos up = origin.m_6630_(height - 1);
            BlockPos.m_121990_((BlockPos)up.m_7918_(-radius, 0, -radius), (BlockPos)up.m_7918_(radius, height, radius)).map(BlockPos::m_7949_).forEach(position -> {
                if (position.m_123331_((Vec3i)origin) <= circularArea) {
                    world.m_7731_(position, Blocks.f_50016_.m_49966_(), 2);
                }
            });
        }

        private void generateShell(WorldGenLevel world, BlockPos origin, RandomSource random, int radius) {
            int height = radius / 5;
            double circularArea = this.getCircularArea(radius, height);
            BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, -height, -radius), (BlockPos)origin.m_7918_(radius, 1, radius)).map(BlockPos::m_7949_).forEach(position -> {
                if (position.m_123331_((Vec3i)origin) < circularArea) {
                    world.m_7731_(position, random.m_188499_() ? this.transform(Blocks.f_49994_) : this.transform(Blocks.f_50493_), 2);
                } else if (position.m_123331_((Vec3i)origin) == circularArea) {
                    world.m_7731_(position, this.transform(Blocks.f_50652_), 2);
                }
            });
        }

        private void generateSurface(WorldGenLevel world, BlockPos origin, RandomSource random, int radius) {
            int height = 2;
            double circularArea = this.getCircularArea(radius, height);
            BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, height, -radius), (BlockPos)origin.m_7918_(radius, 0, radius)).map(BlockPos::m_7949_).forEach(position -> {
                int heightDifference = position.m_123342_() - origin.m_123342_();
                if (position.m_123331_((Vec3i)origin) <= circularArea && heightDifference < 2 + random.m_188503_(height) && !world.m_46859_(position.m_7495_())) {
                    if (world.m_46859_(position.m_7494_())) {
                        world.m_7731_(position, this.transform(Blocks.f_50034_), 2);
                    } else {
                        world.m_7731_(position, this.transform(Blocks.f_50493_), 2);
                    }
                }
            });
        }

        private void generateTreasurePile(WorldGenLevel world, RandomSource random, BlockPos origin) {
            int layers = random.m_188503_(3);
            for (int i = 0; i < layers; ++i) {
                int radius = layers - i;
                double circularArea = this.getCircularArea(radius);
                for (BlockPos position : BlockPos.m_121990_((BlockPos)origin.m_7918_(-radius, i, -radius), (BlockPos)origin.m_7918_(radius, i, radius)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                    if (!(position.m_123331_((Vec3i)origin) <= circularArea)) continue;
                    position = world.m_5452_(Heightmap.Types.WORLD_SURFACE, position);
                    if (!(this.treasureBlock instanceof BlockGoldPile)) continue;
                    BlockState state = world.m_8055_(position);
                    boolean placed = false;
                    if (state.m_60795_()) {
                        world.m_7731_(position, (BlockState)this.treasureBlock.m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + random.m_188503_(7))), 2);
                        placed = true;
                    } else if (state.m_60734_() instanceof SnowLayerBlock) {
                        world.m_7731_(position.m_7495_(), (BlockState)this.treasureBlock.m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_))), 2);
                        placed = true;
                    }
                    if (!placed || !(world.m_8055_(position.m_7495_()).m_60734_() instanceof BlockGoldPile)) continue;
                    world.m_7731_(position.m_7495_(), (BlockState)this.treasureBlock.m_49966_().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(8)), 2);
                }
            }
        }

        private void spawnDragon(WorldGenLevel world, BlockPos origin, RandomSource random, int ageOffset, boolean isMale) {
            EntityDragonBase dragon = (EntityDragonBase)this.getDragonType().m_20615_((Level)world.m_6018_());
            assert (dragon != null);
            dragon.setGender(isMale);
            dragon.growDragon(40 + ageOffset);
            dragon.setAgingDisabled(true);
            dragon.m_21153_(dragon.m_21233_());
            List<DragonColor> colors = DragonColor.getColorsByType(DragonType.getTypeByEntityType(this.getDragonType()));
            dragon.setVariant(colors.get(random.m_188503_(colors.size())).name());
            dragon.m_19890_((double)origin.m_123341_() + 0.5, (double)world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, origin).m_123342_() + 1.5, (double)origin.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
            dragon.homePos = new HomePosition(origin, (Level)world.m_6018_());
            dragon.hasHomePosition = true;
            dragon.setHunger(50);
            world.m_7967_((Entity)dragon);
        }

        protected abstract EntityType<? extends EntityDragonBase> getDragonType();

        protected abstract ResourceLocation getRoostLootTable();

        protected abstract BlockState transform(BlockState var1);

        protected abstract void handleCustomGeneration(WorldGenLevel var1, BlockPos var2, RandomSource var3, BlockPos var4, double var5);
    }
}

