/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.item.block.BlockGoldPile;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.uranus.util.ShapeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public abstract class DragonCaveStructure
extends Structure {
    protected DragonCaveStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Rotation blockRotation = Rotation.m_221990_((RandomSource)context.f_226626_());
        BlockPos blockPos = this.m_226582_(context, blockRotation);
        if (!GenerationConstants.isFarEnoughFromSpawn(blockPos)) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> this.addPieces((StructurePiecesBuilder)collector, blockPos, context, context.f_226626_().m_188499_())));
    }

    private void addPieces(StructurePiecesBuilder collector, BlockPos pos, Structure.GenerationContext context, boolean male) {
        int y = context.f_226629_().m_141937_() + 40 + context.f_226626_().m_188503_(30);
        long seed = context.f_226626_().m_188505_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                collector.m_142679_((StructurePiece)this.createPiece(new BoundingBox(pos.m_123341_() + i * 32, pos.m_123342_(), pos.m_123343_() + j * 32, pos.m_123341_() + i * 32, pos.m_123342_(), pos.m_123343_() + j * 32), male, new BlockPos(i * 32, 0, j * 32), y, seed));
            }
        }
    }

    protected abstract DragonCavePiece createPiece(BoundingBox var1, boolean var2, BlockPos var3, int var4, long var5);

    protected static abstract class DragonCavePiece
    extends StructurePiece {
        private final boolean male;
        private final BlockPos offset;
        private final int y;
        private final long seed;

        protected DragonCavePiece(StructurePieceType type, int length, BoundingBox boundingBox, boolean male, BlockPos offset, int y, long seed) {
            super(type, length, boundingBox);
            this.male = male;
            this.offset = offset;
            this.y = y;
            this.seed = seed;
        }

        public DragonCavePiece(StructurePieceType type, CompoundTag nbt) {
            super(type, nbt);
            this.male = nbt.m_128471_("male");
            this.offset = BlockPos.m_122022_((long)nbt.m_128454_("offset"));
            this.y = nbt.m_128451_("down");
            this.seed = nbt.m_128454_("seed");
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
            nbt.m_128379_("male", this.male);
            nbt.m_128356_("offset", this.offset.m_121878_());
            nbt.m_128405_("down", this.y);
            nbt.m_128356_("seed", this.seed);
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            random = new LegacyRandomSource(this.seed);
            BlockPos position = new BlockPos((chunkPos.f_45578_ << 4) + 8, this.y, (chunkPos.f_45579_ << 4) + 8).m_121996_((Vec3i)this.offset);
            int dragonAge = 75 + random.m_188503_(50);
            int radius = (int)((float)dragonAge * 0.2f) + random.m_188503_(4);
            this.generateCave((LevelAccessor)world, radius, 3, position, random);
            if (this.offset.equals((Object)new BlockPos(0, 0, 0))) {
                EntityDragonBase dragon = this.createDragon(world, random, position, dragonAge);
                world.m_7967_((Entity)dragon);
            }
        }

        private boolean isOutOfRange(ChunkPos chunkPos, BlockPos blockPos) {
            return chunkPos.m_45604_() - 16 > blockPos.m_123341_() || blockPos.m_123341_() > chunkPos.m_45608_() + 16 || chunkPos.m_45605_() - 16 > blockPos.m_123343_() || blockPos.m_123343_() > chunkPos.m_45609_() + 16;
        }

        public void generateCave(LevelAccessor worldIn, int radius, int amount, BlockPos center, RandomSource rand) {
            ArrayList<SphereInfo> sphereList = new ArrayList<SphereInfo>();
            sphereList.add(new SphereInfo(radius, center.m_7949_()));
            Stream<BlockPos> sphereBlocks = ShapeBuilder.start().getAllInCutOffSphereMutable(radius, radius / 2, center).toStream(false);
            Stream<BlockPos> hollowBlocks = ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(radius - 2, (int)((double)(radius - 2) * 0.75), (radius - 2) / 2, rand, center).toStream(false);
            for (int i = 0; i < amount + rand.m_188503_(2); ++i) {
                Direction direction = GenerationConstants.HORIZONTALS[rand.m_188503_(GenerationConstants.HORIZONTALS.length - 1)];
                int r = 2 * (int)((float)radius / 3.0f) + rand.m_188503_(8);
                BlockPos centerOffset = center.m_5484_(direction, radius - 2);
                sphereBlocks = Stream.concat(sphereBlocks, ShapeBuilder.start().getAllInCutOffSphereMutable(r, r, centerOffset).toStream(false));
                hollowBlocks = Stream.concat(hollowBlocks, ShapeBuilder.start().getAllInRandomlyDistributedRangeYCutOffSphereMutable(r - 2, (int)((double)(r - 2) * 0.75), (r - 2) / 2, rand, centerOffset).toStream(false));
                sphereList.add(new SphereInfo(r, centerOffset));
            }
            Set<BlockPos> shellBlocksSet = sphereBlocks.map(BlockPos::m_7949_).collect(Collectors.toSet());
            Set<BlockPos> hollowBlocksSet = hollowBlocks.map(BlockPos::m_7949_).collect(Collectors.toSet());
            shellBlocksSet.removeAll(hollowBlocksSet);
            ChunkPos chunkPos = new ChunkPos(center.m_121955_((Vec3i)this.offset));
            shellBlocksSet.removeIf(x -> this.isOutOfRange(chunkPos, (BlockPos)x));
            hollowBlocksSet.removeIf(x -> this.isOutOfRange(chunkPos, (BlockPos)x));
            this.createShell(worldIn, rand, shellBlocksSet);
            this.hollowOut(worldIn, hollowBlocksSet);
            this.decorateCave(worldIn, rand, hollowBlocksSet, sphereList, center);
            sphereList.clear();
        }

        public void createShell(LevelAccessor worldIn, RandomSource rand, Set<BlockPos> positions) {
            List<Block> rareOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_RARE_ORES);
            List<Block> uncommonOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_UNCOMMON_ORES);
            List<Block> commonOres = this.getBlockList(IafBlockTags.DRAGON_CAVE_COMMON_ORES);
            List<Block> dragonTypeOres = this.getBlockList(this.getOreTag());
            positions.forEach(blockPos -> {
                if (!(worldIn.m_8055_(blockPos).m_60734_() instanceof BaseEntityBlock) && worldIn.m_8055_(blockPos).m_60800_((BlockGetter)worldIn, blockPos) >= 0.0f) {
                    boolean doOres;
                    boolean bl = doOres = rand.m_188500_() < (Double)IafCommonConfig.INSTANCE.dragon.generateOreRatio.getValue();
                    if (doOres) {
                        Block toPlace = null;
                        if (rand.m_188499_()) {
                            toPlace = !dragonTypeOres.isEmpty() ? (Block)dragonTypeOres.get(rand.m_188503_(dragonTypeOres.size())) : null;
                        } else {
                            double chance = rand.m_188500_();
                            if (!rareOres.isEmpty() && chance <= 0.15) {
                                toPlace = (Block)rareOres.get(rand.m_188503_(rareOres.size()));
                            } else if (!uncommonOres.isEmpty() && chance <= 0.45) {
                                toPlace = (Block)uncommonOres.get(rand.m_188503_(uncommonOres.size()));
                            } else if (!commonOres.isEmpty()) {
                                toPlace = (Block)commonOres.get(rand.m_188503_(commonOres.size()));
                            }
                        }
                        if (toPlace != null) {
                            worldIn.m_7731_(blockPos, toPlace.m_49966_(), 2);
                        } else {
                            worldIn.m_7731_(blockPos, this.getPaletteBlock(rand), 2);
                        }
                    } else {
                        worldIn.m_7731_(blockPos, this.getPaletteBlock(rand), 2);
                    }
                }
            });
        }

        private List<Block> getBlockList(TagKey<Block> tagKey) {
            return BuiltInRegistries.f_256975_.m_203431_(tagKey).map(holders -> holders.m_203614_().map(Holder::m_203334_).toList()).orElse(Collections.emptyList());
        }

        public void hollowOut(LevelAccessor worldIn, Set<BlockPos> positions) {
            positions.forEach(blockPos -> {
                if (!(worldIn.m_8055_(blockPos).m_60734_() instanceof BaseEntityBlock)) {
                    worldIn.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
                }
            });
        }

        public void decorateCave(LevelAccessor worldIn, RandomSource rand, Set<BlockPos> positions, List<SphereInfo> spheres, BlockPos center) {
            for (SphereInfo sphere : spheres) {
                BlockPos pos = sphere.pos();
                int radius = sphere.radius();
                for (int i = 0; i < 15 + rand.m_188503_(10); ++i) {
                    this.getCeilingDecoration().generate(worldIn, rand, pos.m_6630_(radius / 2 - 1).m_7918_(rand.m_188503_(radius) - radius / 2, 0, rand.m_188503_(radius) - radius / 2));
                }
            }
            positions.forEach(blockPos -> {
                BlockState stateBelow;
                if (blockPos.m_123342_() < center.m_123342_() && ((stateBelow = worldIn.m_8055_(blockPos.m_7495_())).m_204336_(BlockTags.f_13061_) || stateBelow.m_204336_(IafBlockTags.DRAGON_ENVIRONMENT_BLOCKS)) && worldIn.m_8055_(blockPos).m_60795_()) {
                    this.setGoldPile(worldIn, (BlockPos)blockPos, rand);
                }
            });
        }

        public void setGoldPile(LevelAccessor world, BlockPos pos, RandomSource rand) {
            if (!(world.m_8055_(pos).m_60734_() instanceof BaseEntityBlock)) {
                int chance = rand.m_188503_(99) + 1;
                if (chance < 60) {
                    boolean generateGold = rand.m_188500_() < (Double)IafCommonConfig.INSTANCE.dragon.generateDenGoldChance.getValue() * (double)(this.male ? 1 : 2);
                    world.m_7731_(pos, generateGold ? (BlockState)this.getTreasurePile().m_61124_((Property)BlockGoldPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.m_188503_(7))) : Blocks.f_50016_.m_49966_(), 3);
                } else if (chance == 61) {
                    BlockEntity blockEntity;
                    world.m_7731_(pos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)GenerationConstants.HORIZONTALS[rand.m_188503_(3)]), 2);
                    if (world.m_8055_(pos).m_60734_() instanceof ChestBlock && (blockEntity = world.m_7702_(pos)) instanceof ChestBlockEntity) {
                        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
                        chestBlockEntity.m_59626_(this.getChestTable(this.male), rand.m_188505_());
                    }
                }
            }
        }

        private EntityDragonBase createDragon(WorldGenLevel worldGen, RandomSource random, BlockPos position, int dragonAge) {
            EntityDragonBase dragon = (EntityDragonBase)this.getDragonType().m_20615_((Level)worldGen.m_6018_());
            assert (dragon != null);
            dragon.setGender(this.male);
            dragon.growDragon(dragonAge);
            dragon.setAgingDisabled(true);
            dragon.m_21153_(dragon.m_21233_());
            List<DragonColor> colors = DragonColor.getColorsByType(DragonType.getTypeByEntityType(this.getDragonType()));
            dragon.setVariant(colors.get(random.m_188503_(colors.size())).name());
            dragon.m_19890_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
            dragon.m_21837_(true);
            dragon.homePos = new HomePosition(position, (Level)worldGen.m_6018_());
            dragon.setHunger(50);
            return dragon;
        }

        protected abstract TagKey<Block> getOreTag();

        protected abstract WorldGenCaveStalactites getCeilingDecoration();

        protected abstract BlockState getTreasurePile();

        protected abstract BlockState getPaletteBlock(RandomSource var1);

        protected abstract ResourceLocation getChestTable(boolean var1);

        protected abstract EntityType<? extends EntityDragonBase> getDragonType();
    }

    protected static class WorldGenCaveStalactites {
        private final Block block;
        private final int maxHeight;

        public WorldGenCaveStalactites(Block block, int maxHeight) {
            this.block = block;
            this.maxHeight = maxHeight;
        }

        public void generate(LevelAccessor worldIn, RandomSource rand, BlockPos position) {
            int height = this.maxHeight + rand.m_188503_(3);
            for (int i = 0; i < height; ++i) {
                if (i < height / 2) {
                    worldIn.m_7731_(position.m_6625_(i).m_122012_(), this.block.m_49966_(), 2);
                    worldIn.m_7731_(position.m_6625_(i).m_122029_(), this.block.m_49966_(), 2);
                    worldIn.m_7731_(position.m_6625_(i).m_122019_(), this.block.m_49966_(), 2);
                    worldIn.m_7731_(position.m_6625_(i).m_122024_(), this.block.m_49966_(), 2);
                }
                worldIn.m_7731_(position.m_6625_(i), this.block.m_49966_(), 2);
            }
        }
    }

    public record SphereInfo(int radius, BlockPos pos) {
    }
}

