/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.render.model.BasicHeadedModel;
import com.iafenvoy.iceandfire.render.model.ICustomStatueModel;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.ModelAnimator;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.util.HideableModelRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public abstract class ModelBipedBase<T extends LivingEntity>
extends AdvancedEntityModel<T>
implements ICustomStatueModel,
BasicHeadedModel,
ArmedModel {
    public HideableModelRenderer head = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
    public HideableModelRenderer headware = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
    public HideableModelRenderer body = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
    public HideableModelRenderer armRight = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
    public HideableModelRenderer armLeft = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
    public HideableModelRenderer legRight = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
    public HideableModelRenderer legLeft = new HideableModelRenderer((AdvancedEntityModel)this, 0, 0);
    public HumanoidModel.ArmPose leftArmPose;
    public HumanoidModel.ArmPose rightArmPose;
    public boolean isSneak;
    protected ModelAnimator animator;

    protected ModelBipedBase() {
    }

    @Override
    public BasicModelPart getHead() {
        return this.head;
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        this.getArmForSide(sideIn).translateAndRotate(matrixStackIn);
    }

    protected HideableModelRenderer getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.armLeft : this.armRight;
    }

    protected HumanoidArm getMainHand(Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity LivingEntity2 = (LivingEntity)entityIn;
            HumanoidArm Handside = LivingEntity2.m_5737_();
            return LivingEntity2.f_20912_ == InteractionHand.MAIN_HAND ? Handside : Handside.m_20828_();
        }
        return HumanoidArm.RIGHT;
    }

    public void progressRotationInterp(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ, float max) {
        model.rotateAngleX += progress * (rotX - model.defaultRotationX) / max;
        model.rotateAngleY += progress * (rotY - model.defaultRotationY) / max;
        model.rotateAngleZ += progress * (rotZ - model.defaultRotationZ) / max;
    }

    public void progresPositionInterp(AdvancedModelBox model, float progress, float x, float y, float z, float max) {
        model.rotationPointX += progress * x / max;
        model.rotationPointY += progress * y / max;
        model.rotationPointZ += progress * z / max;
    }

    public void progressRotation(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.rotateAngleX += progress * (rotX - model.defaultRotationX) / 20.0f;
        model.rotateAngleY += progress * (rotY - model.defaultRotationY) / 20.0f;
        model.rotateAngleZ += progress * (rotZ - model.defaultRotationZ) / 20.0f;
    }

    public void progressRotationPrev(AdvancedModelBox model, float progress, float rotX, float rotY, float rotZ) {
        model.rotateAngleX += progress * rotX / 20.0f;
        model.rotateAngleY += progress * rotY / 20.0f;
        model.rotateAngleZ += progress * rotZ / 20.0f;
    }

    public void progressPosition(AdvancedModelBox model, float progress, float x, float y, float z) {
        model.rotationPointX += progress * (x - model.defaultPositionX) / 20.0f;
        model.rotationPointY += progress * (y - model.defaultPositionY) / 20.0f;
        model.rotationPointZ += progress * (z - model.defaultPositionZ) / 20.0f;
    }

    public void progressPositionPrev(AdvancedModelBox model, float progress, float x, float y, float z) {
        model.rotationPointX += progress * x / 20.0f;
        model.rotationPointY += progress * y / 20.0f;
        model.rotationPointZ += progress * z / 20.0f;
    }

    public <U extends BasicModelPart> void copyFrom(U modelIn, U currentModel) {
        modelIn.copyModelAngles(currentModel);
        modelIn.rotationPointX = currentModel.rotationPointX;
        modelIn.rotationPointY = currentModel.rotationPointY;
        modelIn.rotationPointZ = currentModel.rotationPointZ;
    }

    public <M extends ModelPart, U extends BasicModelPart> void copyFrom(M modelIn, U currentModel) {
        modelIn.m_171327_(currentModel.rotateAngleX, currentModel.rotateAngleY, currentModel.rotateAngleZ);
        modelIn.f_104200_ = currentModel.rotationPointX;
        modelIn.f_104201_ = currentModel.rotationPointY;
        modelIn.f_104202_ = currentModel.rotationPointZ;
    }

    public void setModelAttributes(ModelBipedBase<T> modelIn) {
        super.m_102624_(modelIn);
        modelIn.animator = this.animator;
        modelIn.leftArmPose = this.leftArmPose;
        modelIn.rightArmPose = this.rightArmPose;
        modelIn.isSneak = this.isSneak;
        this.copyFrom((ModelPart)modelIn.head, (BasicModelPart)this.head);
        this.copyFrom((ModelPart)modelIn.headware, (BasicModelPart)this.headware);
        this.copyFrom((ModelPart)modelIn.body, (BasicModelPart)this.body);
        this.copyFrom((ModelPart)modelIn.armRight, (BasicModelPart)this.armRight);
        this.copyFrom((ModelPart)modelIn.armLeft, (BasicModelPart)this.armLeft);
        this.copyFrom((ModelPart)modelIn.legRight, (BasicModelPart)this.legRight);
        this.copyFrom((ModelPart)modelIn.legLeft, (BasicModelPart)this.legLeft);
    }

    public void setModelAttributes(HumanoidModel<T> modelIn) {
        super.m_102624_(modelIn);
        modelIn.f_102815_ = this.leftArmPose;
        modelIn.f_102816_ = this.rightArmPose;
        modelIn.f_102817_ = this.isSneak;
        this.copyFrom(modelIn.f_102808_, this.head);
        this.copyFrom(modelIn.f_102809_, this.headware);
        this.copyFrom(modelIn.f_102810_, this.body);
        this.copyFrom(modelIn.f_102811_, this.armRight);
        this.copyFrom(modelIn.f_102812_, this.armLeft);
        this.copyFrom(modelIn.f_102813_, this.legRight);
        this.copyFrom(modelIn.f_102814_, this.legLeft);
    }

    public void setVisible(boolean visible) {
        this.head.invisible = !visible;
        this.headware.invisible = !visible;
        this.body.invisible = !visible;
        this.armRight.invisible = !visible;
        this.armLeft.invisible = !visible;
        this.legRight.invisible = !visible;
        this.legLeft.invisible = !visible;
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch, 0.0f);
        this.faceTarget(headYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head});
        float f = 1.0f;
        this.armRight.rotateAngleX += Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 2.0f * limbDistance * 0.5f / f;
        this.armLeft.rotateAngleX += Mth.m_14089_((float)(limbAngle * 0.6662f)) * 2.0f * limbDistance * 0.5f / f;
        this.legRight.rotateAngleX = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance / f;
        this.legLeft.rotateAngleX = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance / f;
        this.legRight.rotateAngleY = 0.0f;
        this.legLeft.rotateAngleY = 0.0f;
        this.legRight.rotateAngleZ = 0.0f;
        this.legLeft.rotateAngleZ = 0.0f;
        if (entity.m_20159_()) {
            this.armRight.rotateAngleX -= 0.62831855f;
            this.armLeft.rotateAngleX -= 0.62831855f;
            this.legRight.rotateAngleX = -1.4137167f;
            this.legRight.rotateAngleY = 0.31415927f;
            this.legRight.rotateAngleZ = 0.07853982f;
            this.legLeft.rotateAngleX = -1.4137167f;
            this.legLeft.rotateAngleY = -0.31415927f;
            this.legLeft.rotateAngleZ = -0.07853982f;
        }
        if (this.f_102608_ > 0.0f) {
            HumanoidArm handSide = this.getMainHand((Entity)entity);
            HideableModelRenderer modelrenderer = this.getArmForSide(handSide);
            float f1 = this.f_102608_;
            this.body.rotateAngleY = Mth.m_14031_((float)(Mth.m_14116_((float)f1) * ((float)Math.PI * 2))) * 0.2f;
            if (handSide == HumanoidArm.LEFT) {
                this.body.rotateAngleY *= -1.0f;
            }
            this.armRight.rotationPointZ = Mth.m_14031_((float)this.body.rotateAngleY) * 5.0f;
            this.armRight.rotationPointX = -Mth.m_14089_((float)this.body.rotateAngleY) * 5.0f;
            this.armLeft.rotationPointZ = -Mth.m_14031_((float)this.body.rotateAngleY) * 5.0f;
            this.armLeft.rotationPointX = Mth.m_14089_((float)this.body.rotateAngleY) * 5.0f;
            this.armRight.rotateAngleY += this.body.rotateAngleY;
            this.armLeft.rotateAngleY += this.body.rotateAngleY;
            this.armLeft.rotateAngleX += this.body.rotateAngleX;
            f1 = 1.0f - this.f_102608_;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = Mth.m_14031_((float)(f1 * (float)Math.PI));
            float f3 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.rotateAngleX - 0.7f) * 0.75f;
            modelrenderer.rotateAngleX = (float)((double)modelrenderer.rotateAngleX - ((double)f2 * 1.2 + (double)f3));
            modelrenderer.rotateAngleY += this.body.rotateAngleY * 2.0f;
            modelrenderer.rotateAngleZ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
        if (this.isSneak) {
            this.body.rotateAngleX = 0.5f;
            this.armRight.rotateAngleX += 0.4f;
            this.armLeft.rotateAngleX += 0.4f;
            this.legRight.rotationPointZ = 4.0f;
            this.legLeft.rotationPointZ = 4.0f;
            this.legRight.rotationPointY = 9.0f;
            this.legLeft.rotationPointY = 9.0f;
            this.head.rotationPointY = 1.0f;
        } else {
            this.body.rotateAngleX = 0.0f;
            this.legRight.rotationPointZ = 0.1f;
            this.legLeft.rotationPointZ = 0.1f;
            this.legRight.rotationPointY = 12.0f;
            this.legLeft.rotationPointY = 12.0f;
            this.head.rotationPointY = 0.0f;
        }
        this.armRight.rotateAngleZ += Mth.m_14089_((float)(animationProgress * 0.09f)) * 0.05f + 0.05f;
        this.armLeft.rotateAngleZ -= Mth.m_14089_((float)(animationProgress * 0.09f)) * 0.05f + 0.05f;
        this.armRight.rotateAngleX += Mth.m_14031_((float)(animationProgress * 0.067f)) * 0.05f;
        this.armLeft.rotateAngleX -= Mth.m_14031_((float)(animationProgress * 0.067f)) * 0.05f;
    }

    @Override
    public void renderStatue(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, Entity living) {
        this.m_7695_(matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    abstract void animate(T var1, float var2, float var3, float var4, float var5, float var6, float var7);

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.head, (Object)this.headware, (Object)this.body, (Object)this.armRight, (Object)this.armLeft, (Object)this.legRight, (Object)this.legLeft);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }
}

