/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDreadQueen;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;

public class LayerDragonRider
extends RenderLayer<EntityDragonBase, TabulaModel<EntityDragonBase>> {
    public static final List<Entity> renderingRiders = new ArrayList<Entity>();
    private final MobRenderer<EntityDragonBase, TabulaModel<EntityDragonBase>> render;
    private final boolean excludeDreadQueenMob;

    public LayerDragonRider(MobRenderer<EntityDragonBase, TabulaModel<EntityDragonBase>> renderIn, boolean excludeDreadQueenMob) {
        super(renderIn);
        this.render = renderIn;
        this.excludeDreadQueenMob = excludeDreadQueenMob;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.m_85836_();
        if (!dragon.m_20197_().isEmpty()) {
            float dragonScale = dragon.getRenderSize() / 3.0f;
            for (Entity passenger : dragon.m_20197_()) {
                boolean prey;
                boolean bl = prey = dragon.m_6688_() == null || dragon.m_6688_().m_19879_() != passenger.m_19879_();
                if (this.excludeDreadQueenMob && passenger instanceof EntityDreadQueen) {
                    prey = false;
                }
                float riderRot = passenger.f_19859_ + (passenger.m_146908_() - passenger.f_19859_) * partialTicks;
                int animationTicks = 0;
                if (dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                    animationTicks = dragon.getAnimationTick();
                }
                if (animationTicks == 0 || animationTicks >= 15) {
                    this.translateToBody(matrixStackIn);
                }
                if (prey) {
                    if (animationTicks == 0 || animationTicks >= 15 || dragon.isFlying()) {
                        this.translateToHead(matrixStackIn);
                        this.offsetPerDragonType(dragon.dragonType, matrixStackIn);
                        EntityRenderer render = Minecraft.m_91087_().m_91290_().m_114382_(passenger);
                        EntityModel modelBase = null;
                        if (render instanceof MobRenderer) {
                            MobRenderer mobEntityRenderer = (MobRenderer)render;
                            modelBase = mobEntityRenderer.m_7200_();
                        }
                        if ((passenger.m_20206_() > passenger.m_20205_() || modelBase instanceof HumanoidModel) && !(modelBase instanceof QuadrupedModel) && !(modelBase instanceof HorseModel)) {
                            matrixStackIn.m_252880_(-0.15f * passenger.m_20206_(), 0.1f * dragonScale - 0.1f * passenger.m_20206_(), -0.1f * dragonScale - 0.1f * passenger.m_20205_());
                            matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(45.0f));
                        } else {
                            boolean horse = modelBase instanceof HorseModel;
                            matrixStackIn.m_252880_((horse ? -0.08f : -0.15f) * passenger.m_20205_(), 0.1f * dragonScale - 0.15f * passenger.m_20205_(), -0.1f * dragonScale - 0.1f * passenger.m_20205_());
                            matrixStackIn.m_252781_(Axis.f_252495_.m_252977_(90.0f));
                        }
                    } else {
                        matrixStackIn.m_252880_(0.0f, 0.555f * dragonScale, -0.5f * dragonScale);
                    }
                } else {
                    matrixStackIn.m_252880_(0.0f, -0.01f * dragonScale, -0.035f * dragonScale);
                }
                matrixStackIn.m_85836_();
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(riderRot + 180.0f));
                matrixStackIn.m_85841_(1.0f / dragonScale, 1.0f / dragonScale, 1.0f / dragonScale);
                matrixStackIn.m_252880_(0.0f, -0.25f, 0.0f);
                renderingRiders.add(passenger);
                this.renderEntity(passenger, 0, 0, 0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                renderingRiders.remove(passenger);
                matrixStackIn.m_85849_();
            }
        }
        matrixStackIn.m_85849_();
    }

    protected void translateToBody(PoseStack stack) {
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("BodyUpper"), stack);
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Neck1"), stack);
    }

    protected void translateToHead(PoseStack stack) {
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Neck2"), stack);
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Neck3"), stack);
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Head"), stack);
    }

    protected void postRender(AdvancedModelBox renderer, PoseStack matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f || renderer.rotationPointZ != 0.0f) {
                matrixStackIn.m_252880_(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            }
        } else {
            matrixStackIn.m_252880_(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252961_(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.m_252781_(Axis.f_252436_.m_252961_(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252961_(renderer.rotateAngleX));
            }
        }
    }

    private void offsetPerDragonType(DragonType dragonType, PoseStack stackIn) {
        if (dragonType == DragonType.LIGHTNING) {
            stackIn.m_252880_(0.1f, -0.2f, -0.1f);
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, int x, int y, int z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            try {
                render = manager.m_114382_(entityIn);
                if (render == null) break block4;
                try {
                    render.m_7392_(entityIn, 0.0f, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.m_127521_((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
                entityIn.m_7976_(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
                crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
                crashreportcategory1.m_128159_("Location", (Object)new BlockPos(x, y, z));
                crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }
}

