/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntitySiren;
import com.iafenvoy.iceandfire.render.model.ModelSiren;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public class RenderSiren
extends MobRenderer<EntitySiren, ModelSiren> {
    public static final ResourceLocation TEXTURE_0 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/siren/siren_0.png");
    public static final ResourceLocation TEXTURE_0_AGGRESSIVE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/siren/siren_0_aggressive.png");
    public static final ResourceLocation TEXTURE_1 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/siren/siren_1.png");
    public static final ResourceLocation TEXTURE_1_AGGRESSIVE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/siren/siren_1_aggressive.png");
    public static final ResourceLocation TEXTURE_2 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/siren/siren_2.png");
    public static final ResourceLocation TEXTURE_2_AGGRESSIVE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/siren/siren_2_aggressive.png");

    public RenderSiren(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelSiren(), 0.8f);
    }

    public static ResourceLocation getSirenOverlayTexture(int siren) {
        return switch (siren) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            default -> TEXTURE_0;
        };
    }

    public void scale(EntitySiren LivingEntityIn, PoseStack stack, float partialTickTime) {
        stack.m_252880_(0.0f, 0.0f, -0.5f);
    }

    public ResourceLocation getTexture(EntitySiren siren) {
        return switch (siren.getHairColor()) {
            case 1 -> {
                if (siren.isAgressive()) {
                    yield TEXTURE_1_AGGRESSIVE;
                }
                yield TEXTURE_1;
            }
            case 2 -> {
                if (siren.isAgressive()) {
                    yield TEXTURE_2_AGGRESSIVE;
                }
                yield TEXTURE_2;
            }
            default -> siren.isAgressive() ? TEXTURE_0_AGGRESSIVE : TEXTURE_0;
        };
    }
}

