/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.google.common.collect.Maps;
import com.iafenvoy.iceandfire.data.IafSkullType;
import com.iafenvoy.iceandfire.entity.EntityMobSkull;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpent;
import com.iafenvoy.iceandfire.registry.IafRenderers;
import com.iafenvoy.iceandfire.render.model.ModelAmphithere;
import com.iafenvoy.iceandfire.render.model.ModelCockatrice;
import com.iafenvoy.iceandfire.render.model.ModelCyclops;
import com.iafenvoy.iceandfire.render.model.ModelHippogryph;
import com.iafenvoy.iceandfire.render.model.ModelHydraHead;
import com.iafenvoy.iceandfire.render.model.ModelStymphalianBird;
import com.iafenvoy.iceandfire.render.model.ModelTroll;
import com.iafenvoy.iceandfire.render.model.animator.SeaSerpentTabulaModelAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RenderMobSkull
extends EntityRenderer<EntityMobSkull> {
    private static final Map<String, ResourceLocation> SKULL_TEXTURE_CACHE = Maps.newHashMap();
    private final ModelHippogryph hippogryphModel = new ModelHippogryph();
    private final ModelCyclops cyclopsModel = new ModelCyclops();
    private final ModelCockatrice cockatriceModel = new ModelCockatrice();
    private final ModelStymphalianBird stymphalianBirdModel = new ModelStymphalianBird();
    private final ModelTroll trollModel = new ModelTroll();
    private final ModelAmphithere amphithereModel = new ModelAmphithere();
    private final ModelHydraHead hydraModel;
    private final TabulaModel<EntitySeaSerpent> seaSerpentModel = TabulaModelHandlerHelper.getModel((ResourceLocation)IafRenderers.SEA_SERPENT, SeaSerpentTabulaModelAnimator::new);

    public RenderMobSkull(EntityRendererProvider.Context context) {
        super(context);
        this.hydraModel = new ModelHydraHead(0);
    }

    private static void setRotationAngles(BasicModelPart cube, float rotX) {
        cube.rotateAngleX = rotX;
        cube.rotateAngleY = 0.0f;
        cube.rotateAngleZ = 0.0f;
    }

    public void render(EntityMobSkull entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-180.0f));
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(180.0f - entity.m_146908_()));
        float f = 0.0625f;
        float size = 1.0f;
        matrixStackIn.m_85841_(size, size, size);
        matrixStackIn.m_252880_(0.0f, entity.isOnWall() ? -0.24f : -0.12f, 0.5f);
        this.renderForEnum(entity.getSkullType(), entity.isOnWall(), matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderForEnum(IafSkullType skull, boolean onWall, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getSkullTexture(skull)));
        switch (skull) {
            case HIPPOGRYPH: {
                matrixStackIn.m_252880_(0.0f, -0.0f, -0.2f);
                matrixStackIn.m_85841_(1.2f, 1.2f, 1.2f);
                this.hippogryphModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.hippogryphModel.Head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-5.0));
                this.hippogryphModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case CYCLOPS: {
                matrixStackIn.m_252880_(0.0f, 1.8f, -0.5f);
                matrixStackIn.m_85841_(2.25f, 2.25f, 2.25f);
                this.cyclopsModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.cyclopsModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.cyclopsModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case COCKATRICE: {
                if (onWall) {
                    matrixStackIn.m_252880_(0.0f, 0.0f, 0.35f);
                }
                this.cockatriceModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.cockatriceModel.head, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.cockatriceModel.head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case STYMPHALIAN: {
                if (!onWall) {
                    matrixStackIn.m_252880_(0.0f, 0.0f, -0.35f);
                }
                this.stymphalianBirdModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.stymphalianBirdModel.HeadBase, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.stymphalianBirdModel.HeadBase.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case TROLL: {
                matrixStackIn.m_252880_(0.0f, 1.0f, -0.35f);
                if (onWall) {
                    matrixStackIn.m_252880_(0.0f, 0.0f, 0.35f);
                }
                this.trollModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.trollModel.head, onWall ? (float)Math.toRadians(50.0) : (float)Math.toRadians(-20.0));
                this.trollModel.head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case AMPHITHERE: {
                matrixStackIn.m_252880_(0.0f, -0.2f, 0.7f);
                matrixStackIn.m_85841_(2.0f, 2.0f, 2.0f);
                this.amphithereModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.amphithereModel.Head, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.amphithereModel.Head.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SEASERPENT: {
                matrixStackIn.m_252880_(0.0f, -0.35f, 0.8f);
                matrixStackIn.m_85841_(2.5f, 2.5f, 2.5f);
                this.seaSerpentModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.seaSerpentModel.getCube("Head"), onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.seaSerpentModel.getCube("Head").render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case HYDRA: {
                matrixStackIn.m_252880_(0.0f, -0.2f, -0.1f);
                matrixStackIn.m_85841_(2.0f, 2.0f, 2.0f);
                this.hydraModel.resetToDefaultPose();
                RenderMobSkull.setRotationAngles((BasicModelPart)this.hydraModel.Head1, onWall ? (float)Math.toRadians(50.0) : 0.0f);
                this.hydraModel.Head1.render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public ResourceLocation getTexture(EntityMobSkull entity) {
        return this.getSkullTexture(entity.getSkullType());
    }

    public ResourceLocation getSkullTexture(IafSkullType skull) {
        ResourceLocation id = ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/skulls/skull_" + skull.name().toLowerCase(Locale.ROOT) + ".png"));
        assert (id != null);
        return SKULL_TEXTURE_CACHE.computeIfAbsent(id.toString(), k -> id);
    }
}

