/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityLightningDragon;
import com.iafenvoy.iceandfire.particle.LightningBoltData;
import com.iafenvoy.iceandfire.particle.LightningRender;
import com.iafenvoy.iceandfire.render.entity.RenderDragonBase;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RenderLightningDragon
extends RenderDragonBase {
    private final LightningRender lightningRender = new LightningRender();

    public RenderLightningDragon(EntityRendererProvider.Context context, TabulaModel modelSupplier, int dragonType) {
        super(context, (TabulaModel<EntityDragonBase>)modelSupplier);
    }

    private static float getBoundedScale(float scale) {
        return 0.5f + scale * 1.5f;
    }

    public boolean shouldRender(EntityDragonBase livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        if (super.m_5523_((Mob)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        EntityLightningDragon lightningDragon = (EntityLightningDragon)livingEntityIn;
        if (lightningDragon.hasLightningTarget()) {
            Vec3 Vector3d1 = lightningDragon.getHeadPosition();
            Vec3 Vector3d = new Vec3((double)lightningDragon.getLightningTargetX(), (double)lightningDragon.getLightningTargetY(), (double)lightningDragon.getLightningTargetZ());
            return camera.m_113029_(new AABB(Vector3d1.f_82479_, Vector3d1.f_82480_, Vector3d1.f_82481_, Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_));
        }
        return false;
    }

    public void render(EntityDragonBase entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        EntityLightningDragon lightningDragon = (EntityLightningDragon)entityIn;
        matrixStackIn.m_85836_();
        if (lightningDragon.hasLightningTarget()) {
            assert (Minecraft.m_91087_().f_91074_ != null);
            double dist = Minecraft.m_91087_().f_91074_.m_20270_((Entity)lightningDragon);
            if (dist <= (double)Math.max(256.0f, (float)((Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_()).intValue() * 16.0f)) {
                Vec3 Vector3d1 = lightningDragon.getHeadPosition();
                Vec3 Vector3d = new Vec3((double)lightningDragon.getLightningTargetX(), (double)lightningDragon.getLightningTargetY(), (double)lightningDragon.getLightningTargetZ());
                float energyScale = 0.4f * lightningDragon.m_6134_();
                LightningBoltData bolt = new LightningBoltData(LightningBoltData.BoltRenderInfo.ELECTRICITY, Vector3d1, Vector3d, 15).size(0.05f * RenderLightningDragon.getBoundedScale(energyScale)).lifespan(4).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
                this.lightningRender.update(null, bolt, partialTicks);
                matrixStackIn.m_85837_(-lightningDragon.m_20185_(), -lightningDragon.m_20186_(), -lightningDragon.m_20189_());
                this.lightningRender.render(partialTicks, matrixStackIn, bufferIn);
            }
        }
        matrixStackIn.m_85849_();
    }
}

