/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityHippocampus;
import com.iafenvoy.iceandfire.render.model.ModelHippocampus;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class RenderHippocampus
extends MobRenderer<EntityHippocampus, ModelHippocampus> {
    private static final ResourceLocation VARIANT_0 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_0.png");
    private static final ResourceLocation VARIANT_0_BLINK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_0_blinking.png");
    private static final ResourceLocation VARIANT_1 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_1.png");
    private static final ResourceLocation VARIANT_1_BLINK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_1_blinking.png");
    private static final ResourceLocation VARIANT_2 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_2.png");
    private static final ResourceLocation VARIANT_2_BLINK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_2_blinking.png");
    private static final ResourceLocation VARIANT_3 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_3.png");
    private static final ResourceLocation VARIANT_3_BLINK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_3_blinking.png");
    private static final ResourceLocation VARIANT_4 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_4.png");
    private static final ResourceLocation VARIANT_4_BLINK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_4_blinking.png");
    private static final ResourceLocation VARIANT_5 = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_5.png");
    private static final ResourceLocation VARIANT_5_BLINK = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/hippocampus_5_blinking.png");

    public RenderHippocampus(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelHippocampus(), 0.8f);
        this.f_115291_.add(new LayerHippocampusRainbow(this));
        this.f_115291_.add(new LayerHippocampusSaddle(this));
    }

    public ResourceLocation getTexture(EntityHippocampus entity) {
        return switch (entity.getVariant()) {
            case 1 -> {
                if (entity.isBlinking()) {
                    yield VARIANT_1_BLINK;
                }
                yield VARIANT_1;
            }
            case 2 -> {
                if (entity.isBlinking()) {
                    yield VARIANT_2_BLINK;
                }
                yield VARIANT_2;
            }
            case 3 -> {
                if (entity.isBlinking()) {
                    yield VARIANT_3_BLINK;
                }
                yield VARIANT_3;
            }
            case 4 -> {
                if (entity.isBlinking()) {
                    yield VARIANT_4_BLINK;
                }
                yield VARIANT_4;
            }
            case 5 -> {
                if (entity.isBlinking()) {
                    yield VARIANT_5_BLINK;
                }
                yield VARIANT_5;
            }
            default -> entity.isBlinking() ? VARIANT_0_BLINK : VARIANT_0;
        };
    }

    private static class LayerHippocampusRainbow
    extends RenderLayer<EntityHippocampus, ModelHippocampus> {
        private final RenderType TEXTURE = RenderType.m_110482_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/rainbow.png"));
        private final RenderType TEXTURE_BLINK = RenderType.m_110482_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/rainbow_blink.png"));

        public LayerHippocampusRainbow(RenderHippocampus renderer) {
            super((RenderLayerParent)renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityHippocampus hippo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            assert (hippo.m_7770_() != null);
            if (hippo.m_8077_() && hippo.m_7770_().toString().toLowerCase(Locale.ROOT).contains("rainbow")) {
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(hippo.isBlinking() ? this.TEXTURE_BLINK : this.TEXTURE);
                int i = hippo.f_19797_ / 25 + hippo.m_19879_();
                int j = DyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f = ((float)(hippo.f_19797_ % 25) + partialTicks) / 25.0f;
                float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)k));
                float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
                ((ModelHippocampus)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)hippo, (float)0.0f), afloat1[0] * (1.0f - f) + afloat2[0] * f, afloat1[1] * (1.0f - f) + afloat2[1] * f, afloat1[2] * (1.0f - f) + afloat2[2] * f, 1.0f);
            }
        }
    }

    private static class LayerHippocampusSaddle
    extends RenderLayer<EntityHippocampus, ModelHippocampus> {
        private final RenderType SADDLE_TEXTURE = RenderType.m_110482_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/saddle.png"));
        private final RenderType BRIDLE = RenderType.m_110482_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/bridle.png"));
        private final RenderType CHEST = RenderType.m_110473_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/chest.png"));
        private final RenderType TEXTURE_DIAMOND = RenderType.m_110452_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/armor_diamond.png"));
        private final RenderType TEXTURE_GOLD = RenderType.m_110452_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/armor_gold.png"));
        private final RenderType TEXTURE_IRON = RenderType.m_110452_((ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/hippocampus/armor_iron.png"));

        public LayerHippocampusSaddle(RenderHippocampus renderer) {
            super((RenderLayerParent)renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityHippocampus hippo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder;
            if (hippo.m_6254_()) {
                ivertexbuilder = bufferIn.m_6299_(this.SADDLE_TEXTURE);
                ((ModelHippocampus)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.m_6254_() && hippo.m_6688_() != null) {
                ivertexbuilder = bufferIn.m_6299_(this.BRIDLE);
                ((ModelHippocampus)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isChested()) {
                ivertexbuilder = bufferIn.m_6299_(this.CHEST);
                ((ModelHippocampus)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.m_21230_() != 0) {
                RenderType type = switch (hippo.m_21230_()) {
                    case 1 -> this.TEXTURE_IRON;
                    case 2 -> this.TEXTURE_GOLD;
                    case 3 -> this.TEXTURE_DIAMOND;
                    default -> null;
                };
                VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(type);
                ((ModelHippocampus)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

