/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.block;

import com.iafenvoy.iceandfire.entity.block.BlockEntityJar;
import com.iafenvoy.iceandfire.item.block.BlockJar;
import com.iafenvoy.iceandfire.render.entity.RenderPixie;
import com.iafenvoy.iceandfire.render.model.ModelPixie;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class RenderJar<T extends BlockEntityJar>
implements BlockEntityRenderer<T> {
    public static final RenderType TEXTURE_0 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_0, (boolean)false);
    public static final RenderType TEXTURE_1 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_1, (boolean)false);
    public static final RenderType TEXTURE_2 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_2, (boolean)false);
    public static final RenderType TEXTURE_3 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_3, (boolean)false);
    public static final RenderType TEXTURE_4 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_4, (boolean)false);
    public static final RenderType TEXTURE_5 = RenderType.m_110443_((ResourceLocation)RenderPixie.TEXTURE_5, (boolean)false);
    public static final RenderType TEXTURE_0_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_0);
    public static final RenderType TEXTURE_1_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_1);
    public static final RenderType TEXTURE_2_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_2);
    public static final RenderType TEXTURE_3_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_3);
    public static final RenderType TEXTURE_4_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_4);
    public static final RenderType TEXTURE_5_GLO = RenderType.m_110488_((ResourceLocation)RenderPixie.TEXTURE_5);
    private static final Supplier<ModelPixie> MODEL_PIXIE = ModelPixie::new;

    public void render(T entity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int meta = 0;
        boolean hasPixie = false;
        if (entity.m_58904_() != null) {
            Block block = entity.m_58900_().m_60734_();
            if (block instanceof BlockJar) {
                BlockJar jar = (BlockJar)block;
                meta = jar.getPixieType();
                hasPixie = !jar.isEmpty();
            } else {
                meta = ((BlockEntityJar)((Object)entity)).pixieType;
                hasPixie = ((BlockEntityJar)((Object)entity)).hasPixie;
            }
        }
        if (hasPixie) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(0.5f, 1.501f, 0.5f);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            matrixStackIn.m_85836_();
            RenderType type = switch (meta) {
                case 1 -> TEXTURE_1;
                case 2 -> TEXTURE_2;
                case 3 -> TEXTURE_3;
                case 4 -> TEXTURE_4;
                default -> TEXTURE_0;
            };
            RenderType typeGlow = switch (meta) {
                case 1 -> TEXTURE_1_GLO;
                case 2 -> TEXTURE_2_GLO;
                case 3 -> TEXTURE_3_GLO;
                case 4 -> TEXTURE_4_GLO;
                default -> TEXTURE_0_GLO;
            };
            VertexConsumer buffer = bufferIn.m_6299_(type);
            if (entity.m_58904_() != null) {
                if (((BlockEntityJar)((Object)entity)).hasProduced) {
                    matrixStackIn.m_252880_(0.0f, 0.9f, 0.0f);
                } else {
                    matrixStackIn.m_252880_(0.0f, 0.6f, 0.0f);
                }
                matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(this.interpolateRotation(((BlockEntityJar)((Object)entity)).prevRotationYaw, ((BlockEntityJar)((Object)entity)).rotationYaw, partialTicks)));
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                ModelPixie model = MODEL_PIXIE.get();
                model.animateInJar(((BlockEntityJar)((Object)entity)).hasProduced, (BlockEntityJar)((Object)entity), 0.0f);
                model.m_7695_(matrixStackIn, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                model.m_7695_(matrixStackIn, bufferIn.m_6299_(typeGlow), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrixStackIn.m_85849_();
            matrixStackIn.m_85849_();
        }
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }
}

