/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.armor;

import com.iafenvoy.iceandfire.data.DragonArmor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.item.armor.ItemScaleArmor;
import com.iafenvoy.iceandfire.render.model.armor.ModelFireDragonScaleArmor;
import com.iafenvoy.iceandfire.render.model.armor.ModelIceDragonScaleArmor;
import com.iafenvoy.iceandfire.render.model.armor.ModelLightningDragonScaleArmor;
import com.iafenvoy.uranus.client.render.armor.IArmorRendererBase;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ScaleArmorRenderer
implements IArmorRendererBase<LivingEntity> {
    public HumanoidModel<LivingEntity> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<LivingEntity> bipedEntityModel) {
        boolean inner = armorSlot == EquipmentSlot.LEGS || armorSlot == EquipmentSlot.HEAD;
        Item item = itemStack.m_41720_();
        if (item instanceof ItemScaleArmor) {
            ItemScaleArmor scaleArmor = (ItemScaleArmor)item;
            DragonType dragonType = scaleArmor.armorType.getColor().dragonType();
            if (DragonType.FIRE == dragonType) {
                return new ModelFireDragonScaleArmor(inner);
            }
            if (DragonType.ICE == dragonType) {
                return new ModelIceDragonScaleArmor(inner);
            }
            if (DragonType.LIGHTNING == dragonType) {
                return new ModelLightningDragonScaleArmor(inner);
            }
        }
        return null;
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot) {
        DragonArmor armor_type = ((ItemScaleArmor)stack.m_41720_()).armorType;
        return ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/armor/armor_" + armor_type.getColor().name() + (slot == EquipmentSlot.LEGS ? "_legs.png" : ".png")));
    }
}

