/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.tag.IafBiomeTags;
import com.iafenvoy.iceandfire.world.feature.SpawnDeathWorm;
import com.iafenvoy.iceandfire.world.feature.SpawnDragonSkeleton;
import com.iafenvoy.iceandfire.world.feature.SpawnHippocampus;
import com.iafenvoy.iceandfire.world.feature.SpawnSeaSerpent;
import com.iafenvoy.iceandfire.world.feature.SpawnStymphalianBird;
import com.iafenvoy.iceandfire.world.feature.SpawnWanderingCyclops;
import com.mojang.serialization.Codec;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public final class IafFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((String)"iceandfire", (ResourceKey)Registries.f_256833_);
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_DEATH_WORM = IafFeatures.feature("spawn_death_worm", () -> new SpawnDeathWorm((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_L = IafFeatures.feature("spawn_dragon_skeleton_lightning", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntities.LIGHTNING_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_F = IafFeatures.feature("spawn_dragon_skeleton_fire", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntities.FIRE_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_I = IafFeatures.feature("spawn_dragon_skeleton_ice", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntities.ICE_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_HIPPOCAMPUS = IafFeatures.feature("spawn_hippocampus", () -> new SpawnHippocampus((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_SEA_SERPENT = IafFeatures.feature("spawn_sea_serpent", () -> new SpawnSeaSerpent((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_STYMPHALIAN_BIRD = IafFeatures.feature("spawn_stymphalian_bird", () -> new SpawnStymphalianBird((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final RegistrySupplier<Feature<NoneFeatureConfiguration>> SPAWN_WANDERING_CYCLOPS = IafFeatures.feature("spawn_wandering_cyclops", () -> new SpawnWanderingCyclops((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static final ResourceKey<ConfiguredFeature<?, ?>> DREADWOOD = IafFeatures.configuredFeature("dreadwood");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DREADWOOD_LARGE = IafFeatures.configuredFeature("dreadwood_large");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DEATH_WORM = IafFeatures.placeFeature("spawn_death_worm");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DRAGON_SKELETON_L = IafFeatures.placeFeature("spawn_dragon_skeleton_lightning");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DRAGON_SKELETON_F = IafFeatures.placeFeature("spawn_dragon_skeleton_fire");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DRAGON_SKELETON_I = IafFeatures.placeFeature("spawn_dragon_skeleton_ice");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_HIPPOCAMPUS = IafFeatures.placeFeature("spawn_hippocampus");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_SEA_SERPENT = IafFeatures.placeFeature("spawn_sea_serpent");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_STYMPHALIAN_BIRD = IafFeatures.placeFeature("spawn_stymphalian_bird");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_WANDERING_CYCLOPS = IafFeatures.placeFeature("spawn_wandering_cyclops");
    public static final ResourceKey<PlacedFeature> PLACED_SILVER_ORE = IafFeatures.placeFeature("silver_ore");
    public static final ResourceKey<PlacedFeature> PLACED_SAPPHIRE_ORE = IafFeatures.placeFeature("sapphire_ore");
    public static final ResourceKey<PlacedFeature> PLACED_FIRE_LILY = IafFeatures.placeFeature("fire_lily");
    public static final ResourceKey<PlacedFeature> PLACED_LIGHTNING_LILY = IafFeatures.placeFeature("lightning_lily");
    public static final ResourceKey<PlacedFeature> PLACED_FROST_LILY = IafFeatures.placeFeature("frost_lily");

    private static <F extends Feature<? extends FeatureConfiguration>> RegistrySupplier<F> feature(String name, Supplier<F> feature) {
        return REGISTRY.register(name, feature);
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> configuredFeature(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)name));
    }

    public static ResourceKey<PlacedFeature> placeFeature(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)ResourceLocation.m_214293_((String)"iceandfire", (String)name));
    }

    public static void init() {
        IafFeatures.addFeatureToBiome(IafBiomeTags.FIRE, PLACED_FIRE_LILY, GenerationStep.Decoration.VEGETAL_DECORATION);
        IafFeatures.addFeatureToBiome(IafBiomeTags.ICE, PLACED_FROST_LILY, GenerationStep.Decoration.VEGETAL_DECORATION);
        IafFeatures.addFeatureToBiome(IafBiomeTags.LIGHTNING, PLACED_LIGHTNING_LILY, GenerationStep.Decoration.VEGETAL_DECORATION);
        IafFeatures.addFeatureToBiome(IafBiomeTags.FIRE, PLACED_SPAWN_DRAGON_SKELETON_F, GenerationStep.Decoration.SURFACE_STRUCTURES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.ICE, PLACED_SPAWN_DRAGON_SKELETON_I, GenerationStep.Decoration.SURFACE_STRUCTURES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.LIGHTNING, PLACED_SPAWN_DRAGON_SKELETON_L, GenerationStep.Decoration.SURFACE_STRUCTURES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.SILVER_ORE, PLACED_SILVER_ORE, GenerationStep.Decoration.UNDERGROUND_ORES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.SAPPHIRE_ORE, PLACED_SAPPHIRE_ORE, GenerationStep.Decoration.UNDERGROUND_ORES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.DEATHWORM, PLACED_SPAWN_DEATH_WORM, GenerationStep.Decoration.SURFACE_STRUCTURES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.WANDERING_CYCLOPS, PLACED_SPAWN_WANDERING_CYCLOPS, GenerationStep.Decoration.SURFACE_STRUCTURES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.HIPPOCAMPUS, PLACED_SPAWN_HIPPOCAMPUS, GenerationStep.Decoration.SURFACE_STRUCTURES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.SEA_SERPENT, PLACED_SPAWN_SEA_SERPENT, GenerationStep.Decoration.SURFACE_STRUCTURES);
        IafFeatures.addFeatureToBiome(IafBiomeTags.STYMPHALIAN_BIRD, PLACED_SPAWN_STYMPHALIAN_BIRD, GenerationStep.Decoration.SURFACE_STRUCTURES);
    }

    private static void addFeatureToBiome(TagKey<Biome> biomeTag, ResourceKey<PlacedFeature> featureResource, GenerationStep.Decoration step) {
        BiomeModifications.addProperties(context -> context.hasTag(biomeTag), (context, mutable) -> mutable.getGenerationProperties().addFeature(step, featureResource));
    }
}

