/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.mixin;

import com.iafenvoy.iceandfire.registry.IafItems;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin
extends Entity {
    public MobEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Unique
    private static boolean isSkeleton(Entity entity) {
        return WitherSkeleton.class.isAssignableFrom(entity.getClass());
    }

    @Inject(method={"dropLoot"}, at={@At(value="HEAD")})
    public void dropHandler(DamageSource damageSource, boolean causedByPlayer, CallbackInfo ci) {
        Entity entity;
        if (causedByPlayer && (entity = damageSource.m_7640_()) instanceof Player) {
            Player player = (Player)entity;
            if (MobEntityMixin.isSkeleton(this)) {
                this.m_19983_(new ItemStack((ItemLike)IafItems.WITHERBONE.get(), this.f_19796_.m_188503_(2)));
            }
        }
    }
}

