/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.item.ItemDragonEgg;
import com.iafenvoy.iceandfire.item.ItemDragonScales;
import com.iafenvoy.iceandfire.item.ItemDragonSkull;
import com.iafenvoy.iceandfire.item.food.ItemDragonFlesh;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafLoots;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CustomizeToDragon
extends LootItemConditionalFunction {
    public CustomizeToDragon(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Object object;
        if (!stack.m_41619_() && (object = context.m_78953_(LootContextParams.f_81455_)) instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)object;
            if (stack.m_41720_() == IafItems.DRAGON_BONE.get()) {
                stack.m_41764_(1 + dragon.m_217043_().m_188503_(1 + dragon.getAgeInDays() / 25));
                return stack;
            }
            if (stack.m_41720_() instanceof ItemDragonScales) {
                stack.m_41764_(dragon.getAgeInDays() / 25 + dragon.m_217043_().m_188503_(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getScaleItem(), stack.m_41613_());
            }
            if (stack.m_41720_() instanceof ItemDragonEgg) {
                if (dragon.m_6125_()) {
                    return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getEggItem(), stack.m_41613_());
                }
                stack.m_41764_(1 + dragon.m_217043_().m_188503_(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getScaleItem(), stack.m_41613_());
            }
            if (stack.m_41720_() instanceof ItemDragonFlesh) {
                return new ItemStack((ItemLike)dragon.getFleshItem(), 1 + dragon.m_217043_().m_188503_(1 + dragon.getAgeInDays() / 25));
            }
            if (stack.m_41720_() instanceof ItemDragonSkull) {
                ItemStack skull = dragon.getSkull();
                skull.m_41764_(stack.m_41613_());
                skull.m_41751_(stack.m_41783_());
                return skull;
            }
            if (stack.m_204117_(IafItemTags.DRAGON_BLOODS)) {
                return new ItemStack((ItemLike)dragon.getBloodItem(), stack.m_41613_());
            }
            if (stack.m_204117_(IafItemTags.DRAGON_HEARTS)) {
                return new ItemStack(dragon.getHeartItem(), stack.m_41613_());
            }
        }
        return stack;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)IafLoots.CUSTOMIZE_TO_DRAGON.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<CustomizeToDragon> {
        public CustomizeToDragon fromJson(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new CustomizeToDragon(conditionsIn);
        }
    }
}

