/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.tool;

import com.google.common.collect.Multimap;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.registry.IafItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public interface DragonSteelOverrides<T extends TieredItem> {
    @Deprecated
    public Multimap<Attribute, AttributeModifier> bakeDragonsteel();

    default public float getAttackDamage(T item) {
        if (item instanceof SwordItem) {
            SwordItem swordItem = (SwordItem)item;
            return swordItem.m_43299_();
        }
        if (item instanceof DiggerItem) {
            DiggerItem toolItem = (DiggerItem)item;
            return toolItem.m_41008_();
        }
        return item.m_43314_().m_6631_();
    }

    default public boolean isDragonSteel(Tier tier) {
        return this.isDragonSteelFire(tier) || this.isDragonSteelIce(tier) || this.isDragonSteelLightning(tier);
    }

    default public boolean isDragonSteelFire(Tier tier) {
        return tier.m_6282_().test(((Item)IafItems.DRAGONSTEEL_FIRE_INGOT.get()).m_7968_());
    }

    default public boolean isDragonSteelIce(Tier tier) {
        return tier.m_6282_().test(((Item)IafItems.DRAGONSTEEL_ICE_INGOT.get()).m_7968_());
    }

    default public boolean isDragonSteelLightning(Tier tier) {
        return tier.m_6282_().test(((Item)IafItems.DRAGONSTEEL_LIGHTNING_INGOT.get()).m_7968_());
    }

    default public void hurtEnemy(T item, ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (item.m_43314_() == IafItems.SILVER_TOOL_MATERIAL && target.m_6336_() == MobType.f_21641_) {
            target.m_6469_(attacker.m_9236_().m_269111_().m_269425_(), this.getAttackDamage(item) + 3.0f);
        }
        if (item.m_43314_() == IafItems.MYRMEX_CHITIN_TOOL_MATERIAL) {
            if (target.m_6336_() != MobType.f_21642_) {
                target.m_6469_(attacker.m_9236_().m_269111_().m_269264_(), this.getAttackDamage(item) + 5.0f);
            }
            if (target instanceof EntityDeathWorm) {
                target.m_6469_(attacker.m_9236_().m_269111_().m_269264_(), this.getAttackDamage(item) + 5.0f);
            }
        }
        if (this.isDragonSteelFire(item.m_43314_()) && ((Boolean)IafCommonConfig.INSTANCE.armors.dragonFireAbility.getValue()).booleanValue()) {
            target.m_20254_(15);
            target.m_147240_(1.0, attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_());
        }
        if (this.isDragonSteelIce(item.m_43314_()) && ((Boolean)IafCommonConfig.INSTANCE.armors.dragonIceAbility.getValue()).booleanValue()) {
            IafEntityData data = IafEntityData.get(target);
            data.frozenData.setFrozen(target, 300);
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 2));
            target.m_147240_(1.0, attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_());
        }
        if (this.isDragonSteelLightning(item.m_43314_()) && ((Boolean)IafCommonConfig.INSTANCE.armors.dragonLightningAbility.getValue()).booleanValue()) {
            boolean flag = true;
            if (attacker instanceof Player && (double)attacker.f_20921_ > 0.2) {
                flag = false;
            }
            if (!attacker.m_9236_().f_46443_ && flag) {
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(target.m_9236_());
                if (!1.$assertionsDisabled && lightningboltentity == null) {
                    throw new AssertionError();
                }
                lightningboltentity.m_19880_().add("iceandfire.bolt_skip_loot");
                lightningboltentity.m_19880_().add(attacker.m_20149_());
                lightningboltentity.m_20219_(target.m_20182_());
                if (!target.m_9236_().f_46443_) {
                    target.m_9236_().m_7967_((Entity)lightningboltentity);
                }
            }
            target.m_147240_(1.0, attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_());
        }
    }

    default public void appendHoverText(Tier tier, ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (tier == IafItems.SILVER_TOOL_MATERIAL) {
            tooltip.add((Component)Component.m_237115_((String)"silvertools.hurt").m_130940_(ChatFormatting.GREEN));
        }
        if (tier == IafItems.MYRMEX_CHITIN_TOOL_MATERIAL) {
            tooltip.add((Component)Component.m_237115_((String)"myrmextools.hurt").m_130940_(ChatFormatting.GREEN));
        }
        if (this.isDragonSteelFire(tier) && ((Boolean)IafCommonConfig.INSTANCE.armors.dragonFireAbility.getValue()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_fire.hurt2").m_130940_(ChatFormatting.DARK_RED));
        }
        if (this.isDragonSteelIce(tier) && ((Boolean)IafCommonConfig.INSTANCE.armors.dragonIceAbility.getValue()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_ice.hurt2").m_130940_(ChatFormatting.AQUA));
        }
        if (this.isDragonSteelLightning(tier) && ((Boolean)IafCommonConfig.INSTANCE.armors.dragonLightningAbility.getValue()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)"dragon_sword_lightning.hurt2").m_130940_(ChatFormatting.DARK_PURPLE));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

