/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.entity.block.BlockEntityPixieHouse;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class BlockPixieHouse
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    public BlockPixieHouse() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_278183_().m_60955_().m_60988_().m_60913_(2.0f, 5.0f).m_60977_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static String name(String type) {
        return "pixie_house_%s".formatted(type);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropPixie(worldIn, pos);
        BlockPixieHouse.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this, 0));
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void dropPixie(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (world.m_7702_(pos) != null && (blockEntity = world.m_7702_(pos)) instanceof BlockEntityPixieHouse) {
            BlockEntityPixieHouse house = (BlockEntityPixieHouse)blockEntity;
            if (house.hasPixie) {
                house.releasePixie();
            }
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return level.f_46443_ ? BlockPixieHouse.m_152132_(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_HOUSE.get()), BlockEntityPixieHouse::tickClient) : BlockPixieHouse.m_152132_(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_HOUSE.get()), BlockEntityPixieHouse::tickServer);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityPixieHouse(pos, state);
    }
}

