/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.entity.block.BlockEntityJar;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockJar
extends BaseEntityBlock {
    protected static final VoxelShape AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private final boolean empty;
    private final int pixieType;

    public BlockJar(int pixieType) {
        super(pixieType != -1 ? BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_280658_(NoteBlockInstrument.HAT).m_60955_().m_60988_().m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56744_).m_60953_(state -> 10).m_60916_((Block)IafBlocks.JAR_EMPTY.get()) : BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_280658_(NoteBlockInstrument.HAT).m_60955_().m_60988_().m_60913_(1.0f, 2.0f).m_60918_(SoundType.f_56744_));
        this.empty = pixieType == -1;
        this.pixieType = pixieType;
    }

    public static String name(int pixieType) {
        if (pixieType == -1) {
            return "pixie_jar_empty";
        }
        return "pixie_jar_%d".formatted(pixieType);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.dropPixie(worldIn, pos);
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void dropPixie(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (world.m_7702_(pos) != null && (blockEntity = world.m_7702_(pos)) instanceof BlockEntityJar) {
            BlockEntityJar jar = (BlockEntityJar)blockEntity;
            if (jar.hasPixie) {
                jar.releasePixie();
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult resultIn) {
        BlockEntity blockEntity;
        if (!this.empty && world.m_7702_(pos) != null && (blockEntity = world.m_7702_(pos)) instanceof BlockEntityJar) {
            BlockEntityJar jar = (BlockEntityJar)blockEntity;
            if (jar.hasPixie && jar.hasProduced) {
                jar.hasProduced = false;
                ItemEntity item = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)IafItems.PIXIE_DUST.get()));
                if (!world.f_46443_) {
                    world.m_7967_((Entity)item);
                }
                world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)IafSounds.PIXIE_HURT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityJar) {
            BlockEntityJar jar = (BlockEntityJar)blockEntity;
            if (!this.empty) {
                jar.hasPixie = true;
                jar.pixieType = this.pixieType;
            } else {
                jar.hasPixie = false;
            }
            jar.m_6596_();
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockJar.m_152132_(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_JAR.get()), BlockEntityJar::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityJar(pos, state, this.empty);
    }

    public int getPixieType() {
        return this.pixieType;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

