/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.item.block.util.INoTab;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDragonForgeCore
extends BaseEntityBlock
implements IDragonProof,
INoTab {
    private final int isFire;
    private final boolean activated;

    public BlockDragonForgeCore(int isFire, boolean activated) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60988_().m_60913_(40.0f, 500.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> activated ? 15 : 0));
        this.isFire = isFire;
        this.activated = activated;
    }

    public static String name(int dragonType, boolean activated) {
        return "dragonforge_%s_core%s".formatted(DragonType.getNameFromInt(dragonType), activated ? "" : "_disabled");
    }

    public static void setState(int dragonType, boolean active, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (active) {
            switch (dragonType) {
                case 0: {
                    worldIn.m_7731_(pos, ((Block)IafBlocks.DRAGONFORGE_FIRE_CORE.get()).m_49966_(), 3);
                    break;
                }
                case 1: {
                    worldIn.m_7731_(pos, ((Block)IafBlocks.DRAGONFORGE_ICE_CORE.get()).m_49966_(), 3);
                    break;
                }
                case 2: {
                    worldIn.m_7731_(pos, ((Block)IafBlocks.DRAGONFORGE_LIGHTNING_CORE.get()).m_49966_(), 3);
                }
            }
        } else {
            switch (dragonType) {
                case 0: {
                    worldIn.m_7731_(pos, ((Block)IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()).m_49966_(), 3);
                    break;
                }
                case 1: {
                    worldIn.m_7731_(pos, ((Block)IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()).m_49966_(), 3);
                    break;
                }
                case 2: {
                    worldIn.m_7731_(pos, ((Block)IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()).m_49966_(), 3);
                }
            }
        }
        if (blockEntity != null) {
            blockEntity.m_6339_();
            worldIn.m_151523_(blockEntity);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.m_6144_()) {
            MenuProvider screenHandlerFactory;
            if (!world.f_46443_ && (screenHandlerFactory = this.m_7246_(state, world, pos)) != null) {
                player.m_5893_(screenHandlerFactory);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public ItemStack getItem(Level world, BlockPos pos, BlockState state) {
        return switch (this.isFire) {
            case 1 -> new ItemStack((ItemLike)((Block)IafBlocks.DRAGONFORGE_ICE_CORE_DISABLED.get()).m_5456_());
            case 2 -> new ItemStack((ItemLike)((Block)IafBlocks.DRAGONFORGE_LIGHTNING_CORE_DISABLED.get()).m_5456_());
            default -> new ItemStack((ItemLike)((Block)IafBlocks.DRAGONFORGE_FIRE_CORE_DISABLED.get()).m_5456_());
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BlockEntityDragonForge) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((BlockEntityDragonForge)blockEntity));
            world.m_46717_(pos, (Block)this);
            world.m_46747_(pos);
        }
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Override
    public boolean shouldBeInTab() {
        return !this.activated;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return BlockDragonForgeCore.m_152132_(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.DRAGONFORGE_CORE.get()), BlockEntityDragonForge::tick);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityDragonForge(pos, state, this.isFire);
    }
}

