/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.iafenvoy.iceandfire.item.armor.IProtectAgainstDragonItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemDragonSteelArmor
extends ArmorItem
implements IProtectAgainstDragonItem {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final ArmorMaterial material;
    private Multimap<Attribute, AttributeModifier> attributeModifierMultimap;

    public ItemDragonSteelArmor(ArmorMaterial material, int renderIndex, ArmorItem.Type slot) {
        super(material, slot, new Item.Properties());
        this.material = material;
        this.attributeModifierMultimap = this.createAttributeMap();
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[this.f_265916_.m_266308_().m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)this.material.m_7366_(this.f_265916_), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)this.material.m_6651_(), AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    private Multimap<Attribute, AttributeModifier> getOrUpdateAttributeMap() {
        if (this.attributeModifierMultimap.containsKey((Object)Attributes.f_22284_) && !this.attributeModifierMultimap.get((Object)Attributes.f_22284_).isEmpty() && this.attributeModifierMultimap.get((Object)Attributes.f_22284_).toArray()[0] instanceof AttributeModifier && ((AttributeModifier)this.attributeModifierMultimap.get((Object)Attributes.f_22284_).toArray()[0]).m_22218_() != (double)this.m_40404_()) {
            this.attributeModifierMultimap = this.createAttributeMap();
        }
        return this.attributeModifierMultimap;
    }

    public int m_8105_(ItemStack stack) {
        if (this.f_265916_ != null) {
            return this.m_40401_().m_266425_(this.f_265916_);
        }
        return super.m_8105_(stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"item.dragonscales_armor.desc").m_130940_(ChatFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == this.f_265916_.m_266308_() ? this.getOrUpdateAttributeMap() : super.m_7167_(equipmentSlot);
    }

    public int m_40404_() {
        if (this.material != null) {
            return this.material.m_7366_(this.m_266204_());
        }
        return super.m_40404_();
    }
}

