/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.forge.component;

import com.iafenvoy.iceandfire.forge.component.EntityDataStorage;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityDataProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Capability<EntityDataStorage> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityDataStorage>(){});
    private EntityDataStorage storage;
    private final LazyOptional<EntityDataStorage> storageLazyOptional = LazyOptional.of(this::getOrCreateStorage);
    private final LivingEntity living;

    public EntityDataProvider(LivingEntity living) {
        this.living = living;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return CAPABILITY.orEmpty(capability, this.storageLazyOptional);
    }

    public CompoundTag serializeNBT() {
        return this.getOrCreateStorage().serializeNBT();
    }

    public void deserializeNBT(CompoundTag arg) {
        this.getOrCreateStorage().deserializeNBT(arg);
    }

    private EntityDataStorage getOrCreateStorage() {
        if (this.storage == null) {
            this.storage = new EntityDataStorage(this.living);
        }
        return this.storage;
    }
}

