/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.event;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityAmphithere;
import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.entity.EntityCyclops;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityGhost;
import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.entity.EntityHydraHead;
import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import com.iafenvoy.iceandfire.entity.EntityStoneStatue;
import com.iafenvoy.iceandfire.entity.ai.EntitySheepAIFollowCyclops;
import com.iafenvoy.iceandfire.entity.ai.VillagerAIFearUntamed;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.item.ItemChain;
import com.iafenvoy.iceandfire.item.ItemDragonHorn;
import com.iafenvoy.iceandfire.item.armor.ItemDragonSteelArmor;
import com.iafenvoy.iceandfire.item.armor.ItemScaleArmor;
import com.iafenvoy.iceandfire.item.armor.ItemTrollArmor;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.network.PacketBufferUtils;
import com.iafenvoy.uranus.util.RandomHelper;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.value.IntValue;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class ServerEvents {
    public static final UUID ALEX_UUID = UUID.fromString("71363abe-fd03-49c9-940d-aae8b8209b7c");
    public static final String BOLT_DONT_DESTROY_LOOT = "iceandfire.bolt_skip_loot";
    private static final Predicate<LivingEntity> VILLAGER_FEAR = entity -> {
        IVillagerFear fear;
        return entity instanceof IVillagerFear && (fear = (IVillagerFear)entity).shouldFear();
    };
    private static final String[] VILLAGE_TYPES = new String[]{"plains", "desert", "snowy", "savanna", "taiga"};

    private static void signalChickenAlarm(LivingEntity chicken, LivingEntity attacker) {
        float d0 = ((Integer)IafCommonConfig.INSTANCE.cockatrice.chickenSearchLength.getValue()).intValue();
        List list = chicken.m_9236_().m_45976_(EntityCockatrice.class, new AABB(chicken.m_20185_(), chicken.m_20186_(), chicken.m_20189_(), chicken.m_20185_() + 1.0, chicken.m_20186_() + 1.0, chicken.m_20189_() + 1.0).m_82377_((double)d0, 10.0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (EntityCockatrice cockatrice : list) {
            if (attacker instanceof EntityCockatrice || DragonUtils.hasSameOwner(cockatrice, (Entity)attacker)) continue;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                if (player.m_7500_() || cockatrice.m_21830_((LivingEntity)player)) continue;
                cockatrice.m_6710_((LivingEntity)player);
                continue;
            }
            cockatrice.m_6710_(attacker);
        }
    }

    private static void signalAmphithereAlarm(LivingEntity villager, LivingEntity attacker) {
        float d0 = ((Double)IafCommonConfig.INSTANCE.amphithere.villagerSearchLength.getValue()).floatValue();
        List list = villager.m_9236_().m_45976_(EntityAmphithere.class, new AABB(villager.m_20185_() - 1.0, villager.m_20186_() - 1.0, villager.m_20189_() - 1.0, villager.m_20185_() + 1.0, villager.m_20186_() + 1.0, villager.m_20189_() + 1.0).m_82377_((double)d0, (double)d0, (double)d0));
        if (list.isEmpty()) {
            return;
        }
        for (Entity entity : list) {
            if (!(entity instanceof EntityAmphithere)) continue;
            EntityAmphithere amphithere = (EntityAmphithere)entity;
            if (attacker instanceof EntityAmphithere || DragonUtils.hasSameOwner(amphithere, (Entity)attacker)) continue;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                if (player.m_7500_() || amphithere.m_21830_((LivingEntity)player)) continue;
                amphithere.m_6710_((LivingEntity)player);
                continue;
            }
            amphithere.m_6710_(attacker);
        }
    }

    public static boolean isRidingOrBeingRiddenBy(Entity first, Entity entityIn) {
        if (first == null || entityIn == null) {
            return false;
        }
        for (Entity entity : first.m_20197_()) {
            if (!entity.equals((Object)entityIn) && !ServerEvents.isRidingOrBeingRiddenBy(entity, entityIn)) continue;
            return true;
        }
        return false;
    }

    public static void onEntityFall(LivingEntity entity, float fallDistance, float multiplier, DamageSource source) {
        if (entity instanceof Player) {
            IafEntityData data = IafEntityData.get(entity);
            if (data.miscData.hasDismounted) {
                data.miscData.setDismounted(false);
            }
        }
    }

    public static float onEntityDamage(LivingEntity entity, DamageSource source, float amount) {
        float multi;
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            multi = 1.0f;
            if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.1f;
            }
            if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.3f;
            }
            if (entity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.2f;
            }
            if (entity.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ItemTrollArmor) {
                multi -= 0.1f;
            }
            amount *= multi;
        }
        if (source.m_276093_(IafDamageTypes.DRAGON_FIRE_TYPE) || source.m_276093_(IafDamageTypes.DRAGON_ICE_TYPE) || source.m_276093_(IafDamageTypes.DRAGON_LIGHTNING_TYPE)) {
            multi = 1.0f;
            if (entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemScaleArmor || entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemDragonSteelArmor) {
                multi -= 0.1f;
            }
            if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ItemScaleArmor || entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ItemDragonSteelArmor) {
                multi -= 0.3f;
            }
            if (entity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemScaleArmor || entity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof ItemDragonSteelArmor) {
                multi -= 0.2f;
            }
            if (entity.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ItemScaleArmor || entity.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof ItemDragonSteelArmor) {
                multi -= 0.1f;
            }
            amount *= multi;
        }
        return amount;
    }

    public static void onLivingSetTarget(Entity tracking, ServerPlayer player) {
        if (tracking instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)tracking;
            if (target.m_6095_().m_204039_(IafEntityTags.CHICKENS)) {
                ServerEvents.signalChickenAlarm(target, (LivingEntity)player);
            } else if (DragonUtils.isVillager((Entity)target)) {
                ServerEvents.signalAmphithereAlarm(target, (LivingEntity)player);
            }
        }
    }

    public static EventResult onPlayerAttack(Player player, Level world, Entity entity, InteractionHand hand, @Nullable EntityHitResult hitResult) {
        if (entity != null && entity.m_6095_().m_204039_(IafEntityTags.SHEEP)) {
            float dist = ((Integer)IafCommonConfig.INSTANCE.cyclops.sheepSearchLength.getValue()).intValue();
            List list = entity.m_9236_().m_45933_(entity, entity.m_20191_().m_82377_((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity e : list) {
                    EntityCyclops cyclops;
                    if (!(e instanceof EntityCyclops) || (cyclops = (EntityCyclops)e).isBlinded() || player.m_7500_()) continue;
                    cyclops.m_6710_((LivingEntity)player);
                }
            }
        }
        if (entity instanceof EntityStoneStatue) {
            EntityStoneStatue statue = (EntityStoneStatue)entity;
            statue.m_21153_(statue.m_21233_());
            if (player != null) {
                ItemStack stack = player.m_21205_();
                entity.m_5496_(SoundEvents.f_12442_, 2.0f, 0.5f + (float)(RandomHelper.nextDouble((double)-1.0, (double)1.0) * 0.2 + 0.5));
                if (stack.m_41720_().m_8096_(Blocks.f_50069_.m_49966_()) || stack.m_41720_().m_5524_().contains("pickaxe")) {
                    statue.setCrackAmount(statue.getCrackAmount() + 1);
                    if (statue.getCrackAmount() > 9) {
                        CompoundTag writtenTag = new CompoundTag();
                        entity.m_20240_(writtenTag);
                        entity.m_5496_(SoundEvents.f_12442_, 2.0f, (float)(RandomHelper.nextDouble((double)-1.0, (double)1.0) * 0.2 + 0.5));
                        entity.m_142687_(Entity.RemovalReason.KILLED);
                        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) > 0) {
                            ItemStack statuette = new ItemStack((ItemLike)IafItems.STONE_STATUE.get());
                            CompoundTag tag = statuette.m_41784_();
                            tag.m_128379_("IAFStoneStatuePlayerEntity", statue.getTrappedEntityTypeString().equalsIgnoreCase("minecraft:player"));
                            tag.m_128359_("IAFStoneStatueEntityID", statue.getTrappedEntityTypeString());
                            tag.m_128365_("IAFStoneStatueNBT", (Tag)writtenTag);
                            statue.m_7380_(tag);
                            if (!statue.m_9236_().m_5776_()) {
                                statue.m_5552_(statuette, 1.0f);
                            }
                        } else if (!statue.m_9236_().f_46443_) {
                            statue.m_20000_((ItemLike)Blocks.f_50652_, 2 + player.m_217043_().m_188503_(4));
                        }
                        statue.m_142687_(Entity.RemovalReason.KILLED);
                    }
                    return EventResult.interruptTrue();
                }
            }
            return EventResult.interruptDefault();
        }
        if (entity instanceof EntityMultipartPart) {
            EntityMultipartPart mutlipartPart = (EntityMultipartPart)entity;
            Entity parent = mutlipartPart.getParent();
            try {
                if (parent != null) {
                    player.m_5706_(parent);
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Exception thrown while interacting with entity.", (Throwable)e);
            }
            int extraData = 0;
            if (mutlipartPart instanceof EntityHydraHead) {
                EntityHydraHead hydraHead = (EntityHydraHead)mutlipartPart;
                if (parent instanceof EntityHydra) {
                    EntityHydra hydra = (EntityHydra)parent;
                    extraData = hydraHead.headIndex;
                    hydra.triggerHeadFlags(extraData);
                }
            }
            if (mutlipartPart.m_9236_().f_46443_ && parent != null) {
                FriendlyByteBuf buf = PacketBufferUtils.create();
                buf.writeInt(parent.m_19879_()).writeInt(extraData);
                NetworkManager.sendToServer((ResourceLocation)StaticVariables.PLAYER_HIT_MULTIPART, (FriendlyByteBuf)buf);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.m_6095_().m_204039_(IafEntityTags.CHICKENS)) {
                ServerEvents.signalChickenAlarm(livingEntity, (LivingEntity)player);
            } else if (DragonUtils.isVillager(entity)) {
                ServerEvents.signalAmphithereAlarm(livingEntity, (LivingEntity)player);
            }
        }
        return EventResult.pass();
    }

    public static EventResult onEntityDie(LivingEntity entity, DamageSource damageSource) {
        LivingEntity attacker;
        IafEntityData data = IafEntityData.get(entity);
        if (entity.m_9236_().f_46443_) {
            return EventResult.pass();
        }
        if (!data.chainData.getChainedTo().isEmpty()) {
            ItemEntity entityitem = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), new ItemStack((ItemLike)IafItems.CHAIN.get(), data.chainData.getChainedTo().size()));
            entityitem.m_32060_();
            entity.m_9236_().m_7967_((Entity)entityitem);
            data.chainData.clearChains();
        }
        if (entity.m_20148_().equals(ALEX_UUID)) {
            entity.m_5552_(new ItemStack((ItemLike)IafItems.WEEZER_BLUE_ALBUM.get()), 1.0f);
        }
        if (entity instanceof Player && ((Boolean)IafCommonConfig.INSTANCE.ghost.fromPlayerDeaths.getValue()).booleanValue() && (attacker = entity.m_21188_()) instanceof Player && entity.m_217043_().m_188503_(3) == 0) {
            boolean flag;
            CombatTracker combat = entity.m_21231_();
            CombatEntry entry = combat.m_19298_();
            boolean bl = flag = entry != null && (entry.f_19250_().m_276093_(DamageTypes.f_268671_) || entry.f_19250_().m_276093_(DamageTypes.f_268722_) || entry.f_19250_().m_276093_(DamageTypes.f_268546_));
            if (entity.m_21023_(MobEffects.f_19614_)) {
                flag = true;
            }
            if (flag) {
                Level world = entity.m_9236_();
                EntityGhost ghost = (EntityGhost)((EntityType)IafEntities.GHOST.get()).m_20615_(world);
                assert (ghost != null);
                ghost.m_20359_((Entity)entity);
                if (!world.f_46443_) {
                    ghost.m_6518_((ServerLevelAccessor)world, world.m_6436_(entity.m_20183_()), MobSpawnType.SPAWNER, null, null);
                    world.m_7967_((Entity)ghost);
                }
                ghost.setDaytimeMode(true);
            }
        }
        return EventResult.pass();
    }

    public static CompoundEventResult<ItemStack> onEntityUseItem(Player player, InteractionHand hand) {
        EntityDragonBase dragon;
        Entity entity;
        ItemStack stack = player.m_21120_(hand);
        if (player.m_20185_() > 87.0 && player.m_20202_() != null && (entity = player.m_20202_()) instanceof EntityDragonBase && (dragon = (EntityDragonBase)entity).m_6071_(player, hand) == InteractionResult.SUCCESS) {
            return CompoundEventResult.interruptTrue((Object)stack);
        }
        return CompoundEventResult.pass();
    }

    public static EventResult onEntityInteract(Player player, Entity entity, InteractionHand hand) {
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (!player.m_5833_()) {
                IafEntityData data = IafEntityData.get(target);
                if (data.chainData.isChainedTo(entity)) {
                    data.chainData.removeChain(entity);
                    if (!player.m_9236_().f_46443_) {
                        entity.m_20000_((ItemLike)IafItems.CHAIN.get(), 1);
                    }
                    return EventResult.interruptTrue();
                }
            }
        }
        if (entity instanceof EntityMultipartPart) {
            EntityMultipartPart multipart = (EntityMultipartPart)entity;
            multipart.m_6096_(player, hand);
            Item item = player.m_21120_(hand).m_41720_();
            if (item instanceof ItemDragonHorn) {
                ItemDragonHorn horn = (ItemDragonHorn)item;
                item = multipart.getParent();
                if (item instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)item;
                    horn.m_6880_(player.m_21120_(hand), player, living, hand);
                }
            }
        }
        return EventResult.pass();
    }

    public static EventResult onPlayerRightClick(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        Level world = player.m_9236_();
        if (world.m_8055_(pos).m_60734_() instanceof AbstractChestBlock && !player.m_7500_()) {
            float dist = ((Integer)IafCommonConfig.INSTANCE.dragon.goldSearchLength.getValue()).intValue();
            List list = world.m_45933_((Entity)player, player.m_20191_().m_82377_((double)dist, (double)dist, (double)dist));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).m_21824_() || dragon.isModelDead() || dragon.m_21830_((LivingEntity)player)) continue;
                    dragon.m_21837_(false);
                    dragon.m_21839_(false);
                    dragon.m_6710_((LivingEntity)player);
                }
            }
        }
        if (world.m_8055_(pos).m_60734_() instanceof WallBlock) {
            ItemChain.attachToFence(player, world, pos);
        }
        return EventResult.pass();
    }

    public static EventResult onBreakBlock(Level world, BlockPos pos, BlockState state, Player player, @Nullable IntValue xp) {
        if (player != null && (state.m_60734_() instanceof AbstractChestBlock || state.m_60713_((Block)IafBlocks.GOLD_PILE.get()) || state.m_60713_((Block)IafBlocks.SILVER_PILE.get()) || state.m_60713_((Block)IafBlocks.COPPER_PILE.get()))) {
            float dist = ((Integer)IafCommonConfig.INSTANCE.dragon.goldSearchLength.getValue()).intValue();
            List list = world.m_45933_((Entity)player, player.m_20191_().m_82377_((double)dist, (double)dist, (double)dist));
            if (list.isEmpty()) {
                return EventResult.pass();
            }
            for (Entity entity : list) {
                EntityDragonBase dragon;
                if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).m_21824_() || dragon.isModelDead() || dragon.m_21830_((LivingEntity)player) || player.m_7500_()) continue;
                dragon.m_21837_(false);
                dragon.m_21839_(false);
                dragon.m_6710_((LivingEntity)player);
            }
        }
        return EventResult.pass();
    }

    public static void onPlayerLeaveEvent(Player player) {
        if (player != null && !player.m_20197_().isEmpty()) {
            for (Entity entity : player.m_20197_()) {
                entity.m_8127_();
            }
        }
    }

    public static boolean onEntityJoinWorld(Entity entity, Level world) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            try {
                if (mob.m_6095_().m_204039_(IafEntityTags.SHEEP) && mob instanceof Animal) {
                    Animal animal = (Animal)mob;
                    animal.f_21345_.m_25352_(8, (Goal)new EntitySheepAIFollowCyclops(animal, 1.2));
                }
                if (mob.m_6095_().m_204039_(IafEntityTags.VILLAGERS) && ((Boolean)IafCommonConfig.INSTANCE.dragon.villagersFear.getValue()).booleanValue()) {
                    mob.f_21345_.m_25352_(1, (Goal)new VillagerAIFearUntamed((PathfinderMob)mob, LivingEntity.class, 8.0f, 0.8, 0.8, VILLAGER_FEAR));
                }
                if (mob.m_6095_().m_204039_(IafEntityTags.FEAR_DRAGONS) && ((Boolean)IafCommonConfig.INSTANCE.dragon.animalsFear.getValue()).booleanValue()) {
                    mob.f_21345_.m_25352_(1, (Goal)new VillagerAIFearUntamed((PathfinderMob)mob, LivingEntity.class, 30.0f, 1.0, 0.5, e -> {
                        IAnimalFear fear;
                        return e instanceof IAnimalFear && (fear = (IAnimalFear)e).shouldAnimalsFear((Entity)mob);
                    }));
                }
            }
            catch (Exception e2) {
                IceAndFire.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
            }
        }
        return true;
    }
}

