/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDreadQueen;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.registry.IafSounds;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class IafDragonLogic {
    private final EntityDragonBase dragon;
    long ticksAfterClearingTarget;

    public IafDragonLogic(EntityDragonBase dragon) {
        this.dragon = dragon;
    }

    public void updateDragonServer() {
        this.dragon.updateRider();
        this.dragon.updatePitch(this.dragon.f_19855_ - this.dragon.m_20186_());
        if (this.dragon.lookingForRoostAIFlag && this.dragon.m_21188_() != null || this.dragon.m_5803_()) {
            this.dragon.lookingForRoostAIFlag = false;
        }
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.sleep.getValue()).booleanValue() && !this.dragon.m_5803_() && !this.dragon.isTimeToWake() && this.dragon.m_20197_().isEmpty() && this.dragon.getCommand() != 2) {
            if (this.dragon.hasHomePosition && this.dragon.m_21534_() != null && DragonUtils.isInHomeDimension(this.dragon) && this.dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)this.dragon.m_21534_())) > this.dragon.m_20205_() * 10.0f && this.dragon.getCommand() != 2 && this.dragon.getCommand() != 1) {
                this.dragon.lookingForRoostAIFlag = true;
            } else {
                this.dragon.lookingForRoostAIFlag = false;
                if (this.dragon.m_9236_().m_46467_() - this.ticksAfterClearingTarget >= 20L && !this.dragon.m_20069_() && this.dragon.m_20096_() && !this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.m_5448_() == null) {
                    this.dragon.m_21837_(true);
                }
            }
        } else {
            this.dragon.lookingForRoostAIFlag = false;
        }
        if (this.dragon.m_5803_() && (this.dragon.isFlying() || this.dragon.isHovering() || this.dragon.m_20069_() || this.dragon.m_9236_().m_46861_(this.dragon.m_20183_()) && this.dragon.isTimeToWake() && !this.dragon.m_21824_() || this.dragon.isTimeToWake() && this.dragon.m_21824_() || this.dragon.m_5448_() != null || !this.dragon.m_20197_().isEmpty())) {
            this.dragon.m_21837_(false);
        }
        if (this.dragon.m_21827_() && this.dragon.m_6688_() != null) {
            this.dragon.m_21839_(false);
        }
        if (this.dragon.blockBreakCounter <= 0) {
            this.dragon.blockBreakCounter = (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue();
        }
        this.dragon.updateBurnTarget();
        if (this.dragon.m_21827_()) {
            if (this.dragon.getCommand() != 1 || this.dragon.m_6688_() != null) {
                this.dragon.m_21839_(false);
            }
        } else if (this.dragon.getCommand() == 1 && this.dragon.m_6688_() == null) {
            this.dragon.m_21839_(true);
        }
        if (this.dragon.m_21827_()) {
            this.dragon.m_21573_().m_26573_();
        }
        if (this.dragon.m_27593_()) {
            this.dragon.m_9236_().m_7605_((Entity)this.dragon, (byte)18);
        }
        this.dragon.ticksStill = new Vec3i((int)this.dragon.f_19854_, (int)this.dragon.f_19855_, (int)this.dragon.f_19856_).m_123331_((Vec3i)this.dragon.m_20183_()) <= 0.5 ? ++this.dragon.ticksStill : 0;
        if (this.dragon.m_6688_() == null && this.dragon.isTackling() && !this.dragon.isFlying() && this.dragon.m_20096_()) {
            ++this.dragon.tacklingTicks;
            if (this.dragon.tacklingTicks == 40) {
                this.dragon.tacklingTicks = 0;
                this.dragon.setTackling(false);
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.m_217043_().m_188503_(500) == 0 && !this.dragon.isModelDead() && !this.dragon.m_5803_()) {
            this.dragon.roar();
        }
        if (this.dragon.isFlying() && this.dragon.m_5448_() != null) {
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE) {
                this.dragon.setTackling(true);
            }
            if (this.dragon.isTackling() && this.dragon.m_20191_().m_82363_(2.0, 2.0, 2.0).m_82381_(this.dragon.m_5448_().m_20191_())) {
                this.dragon.usingGroundAttack = true;
                this.dragon.randomizeAttacks();
                this.attackTarget((Entity)this.dragon.m_5448_(), null, this.dragon.getDragonStage() * 3);
                this.dragon.setFlying(false);
                this.dragon.setHovering(false);
            }
        }
        if (this.dragon.m_6688_() == null && this.dragon.isTackling() && (this.dragon.m_5448_() == null || this.dragon.airAttack != IafDragonAttacks.Air.TACKLE)) {
            this.dragon.setTackling(false);
            this.dragon.randomizeAttacks();
        }
        if (this.dragon.m_20159_()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
            this.dragon.m_21837_(false);
        }
        if (this.dragon.isFlying() && this.dragon.f_19797_ % 40 == 0 || this.dragon.isFlying() && this.dragon.m_5803_()) {
            this.dragon.m_21837_(false);
        }
        if (!this.dragon.canMove()) {
            if (this.dragon.m_5448_() != null) {
                this.dragon.m_6710_(null);
                this.ticksAfterClearingTarget = this.dragon.m_9236_().m_46467_();
            }
            this.dragon.m_21573_().m_26573_();
        }
        if (!this.dragon.m_21824_()) {
            this.dragon.updateCheckPlayer();
        }
        if (this.dragon.isModelDead() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.m_6688_() == null) {
            if ((this.dragon.useFlyingPathFinder() || this.dragon.isHovering()) && this.dragon.navigatorType != 1) {
                this.dragon.switchNavigator(1);
            }
        } else if ((this.dragon.useFlyingPathFinder() || this.dragon.isHovering()) && this.dragon.navigatorType != 2) {
            this.dragon.switchNavigator(2);
        }
        if (this.dragon.m_6688_() == null && !this.dragon.useFlyingPathFinder() && !this.dragon.isHovering() && this.dragon.navigatorType != 0) {
            this.dragon.switchNavigator(0);
        }
        if (this.dragon.m_6688_() == null && !this.dragon.isOverAir() && this.dragon.doesWantToLand() && (this.dragon.isFlying() || this.dragon.isHovering()) && !this.dragon.m_20069_()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.isHovering()) {
            if (this.dragon.isFlying() && this.dragon.flyTicks > 40) {
                this.dragon.setHovering(false);
                this.dragon.setFlying(true);
            }
            ++this.dragon.hoverTicks;
        } else {
            this.dragon.hoverTicks = 0;
        }
        if (this.dragon.isHovering() && !this.dragon.isFlying()) {
            if (this.dragon.m_5803_()) {
                this.dragon.setHovering(false);
            }
            if (this.dragon.m_6688_() == null && this.dragon.doesWantToLand() && !this.dragon.m_20096_() && !this.dragon.m_20069_()) {
                this.dragon.m_20256_(this.dragon.m_20184_().m_82520_(0.0, -0.25, 0.0));
            } else {
                if ((this.dragon.m_6688_() == null || this.dragon.m_6688_() instanceof EntityDreadQueen) && !this.dragon.isBeyondHeight()) {
                    double up = this.dragon.m_20069_() ? 0.12 : 0.08;
                    this.dragon.m_20256_(this.dragon.m_20184_().m_82520_(0.0, up, 0.0));
                }
                if (this.dragon.hoverTicks > 40) {
                    this.dragon.setHovering(false);
                    this.dragon.setFlying(true);
                    this.dragon.flyHovering = 0;
                    this.dragon.hoverTicks = 0;
                    this.dragon.flyTicks = 0;
                }
            }
        }
        if (this.dragon.m_5803_()) {
            this.dragon.m_21573_().m_26573_();
        }
        if ((this.dragon.m_20096_() || this.dragon.m_20069_()) && this.dragon.flyTicks != 0) {
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.isAllowedToTriggerFlight() && this.dragon.isFlying() && this.dragon.doesWantToLand()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(this.dragon.isOverAir());
            if (!this.dragon.isOverAir()) {
                this.dragon.flyTicks = 0;
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.isFlying()) {
            ++this.dragon.flyTicks;
        }
        if ((this.dragon.isHovering() || this.dragon.isFlying()) && this.dragon.m_5803_()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (!this.dragon.isFlying() && !this.dragon.isHovering() && (this.dragon.isAllowedToTriggerFlight() || this.dragon.m_20186_() < (double)this.dragon.m_9236_().m_141937_()) && (this.dragon.m_217043_().m_188503_(this.dragon.getFlightChancePerTick()) == 0 || this.dragon.m_20186_() < (double)this.dragon.m_9236_().m_141937_() || this.dragon.m_5448_() != null && Math.abs(this.dragon.m_5448_().m_20186_() - this.dragon.m_20186_()) > 5.0 || this.dragon.m_20069_())) {
            this.dragon.setHovering(true);
            this.dragon.m_21837_(false);
            this.dragon.m_21839_(false);
            this.dragon.flyHovering = 0;
            this.dragon.hoverTicks = 0;
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.m_5448_() != null && !DragonUtils.isAlive(this.dragon.m_5448_())) {
            this.dragon.m_6710_(null);
            this.ticksAfterClearingTarget = this.dragon.m_9236_().m_46467_();
        }
        if (!this.dragon.isAgingDisabled()) {
            this.dragon.setAgeInTicks(this.dragon.getAgeInTicks() + 1);
            if (this.dragon.getAgeInTicks() % 24000 == 0) {
                this.dragon.updateAttributes();
                this.dragon.growDragon(0);
            }
        }
        if ((Integer)IafCommonConfig.INSTANCE.dragon.hungerTickRate.getValue() > 0 && this.dragon.f_19797_ % (Integer)IafCommonConfig.INSTANCE.dragon.hungerTickRate.getValue() == 0 && this.dragon.getHunger() > 0) {
            this.dragon.setHunger(this.dragon.getHunger() - 1);
        }
        if (this.dragon.groundAttack == IafDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            this.dragon.usingGroundAttack = true;
            this.dragon.randomizeAttacks();
            this.dragon.m_5496_(this.dragon.getBabyFireSound(), 1.0f, 1.0f);
        }
        if (this.dragon.isBreathingFire()) {
            if (this.dragon.m_5803_() || this.dragon.isModelDead()) {
                this.dragon.setBreathingFire(false);
                this.dragon.randomizeAttacks();
                this.dragon.fireBreathTicks = 0;
            }
            if (this.dragon.burningTarget == null && (this.dragon.m_20094_() > this.dragon.getDragonStage() * 25 || this.dragon.m_269323_() != null && this.dragon.m_20197_().contains(this.dragon.m_269323_()) && this.dragon.fireStopTicks <= 0)) {
                this.dragon.setBreathingFire(false);
                this.dragon.randomizeAttacks();
                this.dragon.fireBreathTicks = 0;
            }
            if (this.dragon.fireStopTicks > 0 && this.dragon.m_269323_() != null && this.dragon.m_20197_().contains(this.dragon.m_269323_())) {
                --this.dragon.fireStopTicks;
            }
        }
        if (this.dragon.isFlying()) {
            if (this.dragon.m_5448_() != null && this.dragon.m_20191_().m_82363_(3.0, 3.0, 3.0).m_82381_(this.dragon.m_5448_().m_20191_())) {
                this.dragon.m_7327_((Entity)this.dragon.m_5448_());
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && (this.dragon.f_19862_ || this.dragon.m_20096_())) {
                this.dragon.usingGroundAttack = true;
                if (this.dragon.m_6688_() == null) {
                    this.dragon.setFlying(false);
                    this.dragon.setHovering(false);
                }
            }
            if (this.dragon.usingGroundAttack) {
                this.dragon.airAttack = IafDragonAttacks.Air.TACKLE;
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && this.dragon.m_5448_() != null && this.dragon.isTargetBlocked(this.dragon.m_5448_().m_20182_())) {
                this.dragon.randomizeAttacks();
            }
        }
    }

    public boolean attackTarget(Entity target, Player ridingPlayer, float damage) {
        if (ridingPlayer == null) {
            return target.m_6469_(target.m_9236_().m_269111_().m_269333_((LivingEntity)this.dragon), damage);
        }
        return target.m_6469_(target.m_9236_().m_269111_().m_269104_((Entity)this.dragon, (Entity)ridingPlayer), damage);
    }

    public void updateDragonClient() {
        if (!this.dragon.isModelDead()) {
            this.dragon.turn_buffer.calculateChainSwingBuffer(50.0f, 0, 4.0f, (LivingEntity)this.dragon);
            this.dragon.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (LivingEntity)this.dragon);
            if (!this.dragon.m_20096_()) {
                this.dragon.roll_buffer.calculateChainFlapBuffer(55.0f, 1, 2.0f, 0.5f, (LivingEntity)this.dragon);
                this.dragon.pitch_buffer.calculateChainWaveBuffer(90.0f, 10, 1.0f, 0.5f, (LivingEntity)this.dragon);
                this.dragon.pitch_buffer_body.calculateChainWaveBuffer(80.0f, 10, 1.0f, 0.5f, (LivingEntity)this.dragon);
            }
        }
        this.dragon.walkCycle = this.dragon.walkCycle < 39 ? ++this.dragon.walkCycle : 0;
        if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 17 || this.dragon.getAnimationTick() == 22 || this.dragon.getAnimationTick() == 28)) {
            this.dragon.spawnGroundEffects();
        }
        this.dragon.legSolver.update(this.dragon, this.dragon.getRenderSize() / 3.0f);
        if (this.dragon.flightCycle == 11) {
            this.dragon.spawnGroundEffects();
        }
        if (this.dragon.isModelDead() && this.dragon.flightCycle != 0) {
            this.dragon.flightCycle = 0;
        }
    }

    public void updateDragonCommon() {
        boolean riding;
        boolean modelDead;
        boolean tackling;
        boolean diving;
        boolean hovering;
        boolean sitting;
        boolean sleeping;
        if ((double)this.dragon.fireBreathTicks > (double)this.dragon.getAgeInDays() * (Double)IafCommonConfig.INSTANCE.dragon.maxBreathTimeMul.getValue()) {
            this.dragon.fireBreathTicks = 0;
            this.dragon.setBreathingFire(false);
        }
        if (this.dragon.isBreathingFire()) {
            ++this.dragon.fireBreathTicks;
            if (this.dragon.burnProgress < 40) {
                ++this.dragon.burnProgress;
            }
        } else {
            this.dragon.burnProgress = 0;
        }
        if (this.dragon.flightCycle == 2 && !this.dragon.isDiving() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            float dragonSoundVolume = ((Integer)IafCommonConfig.INSTANCE.dragon.flapNoiseDistance.getValue()).intValue();
            float dragonSoundPitch = this.dragon.m_6100_();
            this.dragon.m_5496_((SoundEvent)IafSounds.DRAGON_FLIGHT.get(), dragonSoundVolume, dragonSoundPitch);
        }
        this.dragon.flightCycle = this.dragon.flightCycle < 58 ? (this.dragon.flightCycle += 2) : 0;
        boolean flying = this.dragon.isFlying();
        if (flying) {
            if (this.dragon.flyProgress < 20.0f) {
                this.dragon.flyProgress += 0.5f;
            }
        } else if (this.dragon.flyProgress > 0.0f) {
            this.dragon.flyProgress -= 2.0f;
        }
        boolean bl = sleeping = this.dragon.m_5803_() && !this.dragon.isHovering() && !flying;
        if (sleeping) {
            if (this.dragon.sleepProgress < 20.0f) {
                this.dragon.sleepProgress += 0.5f;
            }
        } else if (this.dragon.sleepProgress > 0.0f) {
            this.dragon.sleepProgress -= 0.5f;
        }
        boolean bl2 = sitting = this.dragon.m_21827_() && !this.dragon.isModelDead() && !sleeping;
        if (sitting) {
            if (this.dragon.sitProgress < 20.0f) {
                this.dragon.sitProgress += 0.5f;
            }
        } else if (this.dragon.sitProgress > 0.0f) {
            this.dragon.sitProgress -= 0.5f;
        }
        boolean fireBreathing = this.dragon.isBreathingFire();
        this.dragon.prevFireBreathProgress = this.dragon.fireBreathProgress;
        if (fireBreathing) {
            if (this.dragon.fireBreathProgress < 10.0f) {
                this.dragon.fireBreathProgress += 0.5f;
            }
        } else if (this.dragon.fireBreathProgress > 0.0f) {
            this.dragon.fireBreathProgress -= 0.5f;
        }
        boolean bl3 = hovering = this.dragon.isHovering() || this.dragon.isFlying() && this.dragon.airAttack == IafDragonAttacks.Air.HOVER_BLAST && this.dragon.m_5448_() != null && this.dragon.m_20270_((Entity)this.dragon.m_5448_()) < 17.0f;
        if (hovering) {
            if (this.dragon.hoverProgress < 20.0f) {
                this.dragon.hoverProgress += 0.5f;
            }
        } else if (this.dragon.hoverProgress > 0.0f) {
            this.dragon.hoverProgress -= 2.0f;
        }
        if (diving = this.dragon.isDiving()) {
            if (this.dragon.diveProgress < 10.0f) {
                this.dragon.diveProgress += 1.0f;
            }
        } else if (this.dragon.diveProgress > 0.0f) {
            this.dragon.diveProgress -= 2.0f;
        }
        boolean bl4 = tackling = this.dragon.isTackling() && this.dragon.isOverAir();
        if (tackling) {
            if (this.dragon.tackleProgress < 5.0f) {
                this.dragon.tackleProgress += 0.5f;
            }
        } else if (this.dragon.tackleProgress > 0.0f) {
            this.dragon.tackleProgress -= 1.5f;
        }
        if (modelDead = this.dragon.isModelDead()) {
            if (this.dragon.modelDeadProgress < 20.0f) {
                this.dragon.modelDeadProgress += 0.5f;
            }
        } else if (this.dragon.modelDeadProgress > 0.0f) {
            this.dragon.modelDeadProgress -= 0.5f;
        }
        boolean bl5 = riding = this.dragon.m_20159_() && this.dragon.m_20202_() != null && this.dragon.m_20202_() instanceof Player;
        if (riding) {
            if (this.dragon.ridingProgress < 20.0f) {
                this.dragon.ridingProgress += 0.5f;
            }
        } else if (this.dragon.ridingProgress > 0.0f) {
            this.dragon.ridingProgress -= 0.5f;
        }
        if (this.dragon.hasHadHornUse) {
            this.dragon.hasHadHornUse = false;
        }
        if (this.dragon.groundAttack == IafDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            if (this.dragon.m_9236_().f_46443_) {
                this.dragon.spawnBabyParticles();
            }
            this.dragon.randomizeAttacks();
        }
    }

    public void updateDragonAttack() {
        LivingEntity target;
        double dist;
        Player ridingPlayer = this.dragon.getRidingPlayer();
        if (this.dragon.isPlayingAttackAnimation() && this.dragon.m_5448_() != null && this.dragon.m_142582_((Entity)this.dragon.m_5448_()) && (dist = (double)this.dragon.m_20270_((Entity)(target = this.dragon.m_5448_()))) < (double)this.dragon.getRenderSize() * 0.2574 * 2.0 + 2.0) {
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_BITE) {
                if (this.dragon.getAnimationTick() > 15 && this.dragon.getAnimationTick() < 25) {
                    this.attackTarget((Entity)target, ridingPlayer, (int)this.dragon.m_21051_(Attributes.f_22281_).m_22135_());
                    this.dragon.usingGroundAttack = this.dragon.m_217043_().m_188499_();
                    this.dragon.randomizeAttacks();
                }
            } else if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_TAILWHACK) {
                if (this.dragon.getAnimationTick() > 20 && this.dragon.getAnimationTick() < 30) {
                    this.attackTarget((Entity)target, ridingPlayer, (int)this.dragon.m_21051_(Attributes.f_22281_).m_22135_());
                    target.m_147240_((double)((float)this.dragon.getDragonStage() * 0.6f), (double)Mth.m_14031_((float)(this.dragon.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.dragon.m_146908_() * ((float)Math.PI / 180)))));
                    this.dragon.usingGroundAttack = this.dragon.m_217043_().m_188499_();
                    this.dragon.randomizeAttacks();
                }
            } else if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 15 || this.dragon.getAnimationTick() == 25 || this.dragon.getAnimationTick() == 35)) {
                this.attackTarget((Entity)target, ridingPlayer, (int)this.dragon.m_21051_(Attributes.f_22281_).m_22135_());
                target.m_147240_((double)((float)this.dragon.getDragonStage() * 0.6f), (double)Mth.m_14031_((float)(this.dragon.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.dragon.m_146908_() * ((float)Math.PI / 180)))));
                this.dragon.usingGroundAttack = this.dragon.m_217043_().m_188499_();
                this.dragon.randomizeAttacks();
            }
        }
    }

    public void debug() {
        String side = this.dragon.m_9236_().f_46443_ ? "CLIENT" : "SERVER";
        String owner = this.dragon.m_269323_() == null ? "null" : this.dragon.m_269323_().m_7755_().getString();
        String attackTarget = this.dragon.m_5448_() == null ? "null" : this.dragon.m_5448_().m_7755_().getString();
        IceAndFire.LOGGER.warn("DRAGON DEBUG[{}]:\nStage: {}\nAge: {}\nVariant: {}\nOwner: {}\nAttack Target: {}\nFlying: {}\nHovering: {}\nHovering Time: {}\nWidth: {}\nMoveHelper: {}\nGround Attack: {}\nAir Attack: {}\nTackling: {}", new Object[]{side, this.dragon.getDragonStage(), this.dragon.getAgeInDays(), this.dragon.getVariant(), owner, attackTarget, this.dragon.isFlying(), this.dragon.isHovering(), this.dragon.hoverTicks, Float.valueOf(this.dragon.m_20205_()), this.dragon.m_21566_(), this.dragon.groundAttack, this.dragon.airAttack, this.dragon.isTackling()});
    }
}

