/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeInput;
import com.iafenvoy.iceandfire.entity.util.BlockLaunchExplosion;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.item.block.BlockCharedPath;
import com.iafenvoy.iceandfire.item.block.BlockFallingReturningState;
import com.iafenvoy.iceandfire.item.block.BlockReturningState;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class IafDragonDestructionManager {
    public static void destroyAreaBreath(Level level, BlockPos center, EntityDragonBase dragon) {
        float damageScale;
        int statusDuration;
        if (((IafEvents.DragonFireDamageWorld)IafEvents.ON_DRAGON_DAMAGE_BLOCK.invoker()).onDamageBlock(dragon, center.m_123341_(), center.m_123342_(), center.m_123343_())) {
            return;
        }
        if (dragon.dragonType == DragonType.FIRE) {
            statusDuration = 5 + dragon.getDragonStage() * 5;
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageFire.getValue()).floatValue();
        } else if (dragon.dragonType == DragonType.ICE) {
            statusDuration = 50 * dragon.getDragonStage();
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageIce.getValue()).floatValue();
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            statusDuration = 3;
            damageScale = ((Double)IafCommonConfig.INSTANCE.dragon.attackDamageLightning.getValue()).floatValue();
        } else {
            return;
        }
        double damageRadius = 3.5;
        boolean canBreakBlocks = level.m_46469_().m_46207_(GameRules.f_46132_);
        if (dragon.getDragonStage() <= 3) {
            BlockPos.m_121990_((BlockPos)center.m_7918_(-1, -1, -1), (BlockPos)center.m_7918_(1, 1, 1)).forEach(position -> {
                BlockEntity patt2721$temp = level.m_7702_(position);
                if (patt2721$temp instanceof BlockEntityDragonForgeInput) {
                    BlockEntityDragonForgeInput forge = (BlockEntityDragonForgeInput)patt2721$temp;
                    forge.onHitWithFlame();
                    return;
                }
                if (canBreakBlocks && DragonUtils.canGrief(dragon) && dragon.m_217043_().m_188499_()) {
                    IafDragonDestructionManager.attackBlock(level, dragon, position);
                }
            });
        } else {
            int radius = dragon.getDragonStage() == 4 ? 2 : 3;
            int x = radius + level.f_46441_.m_188503_(1);
            int y = radius + level.f_46441_.m_188503_(1);
            int z = radius + level.f_46441_.m_188503_(1);
            float f = (float)(x + y + z) * 0.333f + 0.5f;
            float ff = f * f;
            damageRadius = 2.5f + f * 1.2f;
            BlockPos.m_121990_((BlockPos)center.m_7918_(-x, -y, -z), (BlockPos)center.m_7918_(x, y, z)).forEach(position -> {
                BlockEntity patt3596$temp = level.m_7702_(position);
                if (patt3596$temp instanceof BlockEntityDragonForgeInput) {
                    BlockEntityDragonForgeInput forge = (BlockEntityDragonForgeInput)patt3596$temp;
                    forge.onHitWithFlame();
                    return;
                }
                if (canBreakBlocks && center.m_123331_((Vec3i)position) <= (double)ff && DragonUtils.canGrief(dragon) && level.f_46441_.m_188501_() > (float)center.m_123331_((Vec3i)position) / ff) {
                    IafDragonDestructionManager.attackBlock(level, dragon, position);
                }
            });
        }
        DamageSource damageSource = IafDragonDestructionManager.getDamageSource(dragon);
        float stageDamage = (float)dragon.getDragonStage() * damageScale;
        level.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - damageRadius, (double)center.m_123342_() - damageRadius, (double)center.m_123343_() - damageRadius, (double)center.m_123341_() + damageRadius, (double)center.m_123342_() + damageRadius, (double)center.m_123343_() + damageRadius)).forEach(target -> {
            if (!DragonUtils.onSameTeam((Entity)dragon, (Entity)target) && !dragon.m_7306_((Entity)target) && dragon.m_142582_((Entity)target)) {
                target.m_6469_(damageSource, stageDamage);
                IafDragonDestructionManager.applyDragonEffect(target, dragon, statusDuration);
            }
        });
    }

    public static void destroyAreaCharge(Level level, BlockPos center, EntityDragonBase dragon) {
        int statusDuration;
        boolean canBreakBlocks;
        if (dragon == null) {
            return;
        }
        if (((IafEvents.DragonFireDamageWorld)IafEvents.ON_DRAGON_DAMAGE_BLOCK.invoker()).onDamageBlock(dragon, center.m_123341_(), center.m_123342_(), center.m_123343_())) {
            return;
        }
        int x = 2;
        int y = 2;
        int z = 2;
        boolean bl = canBreakBlocks = DragonUtils.canGrief(dragon) && level.m_46469_().m_46207_(GameRules.f_46132_);
        if (canBreakBlocks) {
            if (dragon.getDragonStage() <= 3) {
                BlockPos.m_121990_((BlockPos)center.m_7918_(-x, -y, -z), (BlockPos)center.m_7918_(x, y, z)).forEach(position -> {
                    BlockState state = level.m_8055_(position);
                    if (state.m_60734_() instanceof IDragonProof) {
                        return;
                    }
                    if ((double)(dragon.m_217043_().m_188501_() * 3.0f) > center.m_123331_((Vec3i)position) && DragonUtils.canDragonBreak(state, (Entity)dragon)) {
                        level.m_46961_(position, false);
                    }
                    if (dragon.m_217043_().m_188499_()) {
                        IafDragonDestructionManager.attackBlock(level, dragon, position, state);
                    }
                });
            } else {
                int radius = dragon.getDragonStage() == 4 ? 2 : 3;
                x = radius + level.f_46441_.m_188503_(2);
                y = radius + level.f_46441_.m_188503_(2);
                z = radius + level.f_46441_.m_188503_(2);
                float f = (float)(x + y + z) * 0.333f + 0.5f;
                float ff = f * f;
                IafDragonDestructionManager.destroyBlocks(level, center, x, y, z, ff, (Entity)dragon);
                BlockPos.m_121990_((BlockPos)center.m_7918_(-(++x), -(++y), -(++z)), (BlockPos)center.m_7918_(x, y, z)).forEach(position -> {
                    if (center.m_123331_((Vec3i)position) <= (double)ff) {
                        IafDragonDestructionManager.attackBlock(level, dragon, position);
                    }
                });
            }
        }
        if (dragon.dragonType == DragonType.FIRE) {
            statusDuration = 15;
        } else if (dragon.dragonType == DragonType.ICE) {
            statusDuration = 400;
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            statusDuration = 9;
        } else {
            return;
        }
        float stageDamage = (float)Math.max(1, dragon.getDragonStage() - 1) * 2.0f;
        DamageSource damageSource = IafDragonDestructionManager.getDamageSource(dragon);
        level.m_45976_(LivingEntity.class, new AABB((double)center.m_123341_() - (double)x, (double)center.m_123342_() - (double)y, (double)center.m_123343_() - (double)z, (double)center.m_123341_() + (double)x, (double)center.m_123342_() + (double)y, (double)center.m_123343_() + (double)z)).forEach(target -> {
            if (!dragon.m_7307_((Entity)target) && !dragon.m_7306_((Entity)target) && dragon.m_142582_((Entity)target)) {
                target.m_6469_(damageSource, stageDamage);
                IafDragonDestructionManager.applyDragonEffect(target, dragon, statusDuration);
            }
        });
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.explosiveBreath.getValue()).booleanValue()) {
            IafDragonDestructionManager.causeExplosion(level, center, dragon, damageSource, dragon.getDragonStage());
        }
    }

    private static DamageSource getDamageSource(EntityDragonBase dragon) {
        Player player = dragon.getRidingPlayer();
        if (dragon.dragonType == DragonType.FIRE) {
            return player != null ? IafDamageTypes.causeIndirectDragonFireDamage((Entity)dragon, (Entity)player) : IafDamageTypes.causeDragonFireDamage((Entity)dragon);
        }
        if (dragon.dragonType == DragonType.ICE) {
            return player != null ? IafDamageTypes.causeIndirectDragonIceDamage((Entity)dragon, (Entity)player) : IafDamageTypes.causeDragonIceDamage((Entity)dragon);
        }
        if (dragon.dragonType == DragonType.LIGHTNING) {
            return player != null ? IafDamageTypes.causeIndirectDragonLightningDamage((Entity)dragon, (Entity)player) : IafDamageTypes.causeDragonLightningDamage((Entity)dragon);
        }
        return dragon.m_9236_().m_269111_().m_269333_((LivingEntity)dragon);
    }

    private static void attackBlock(Level level, EntityDragonBase dragon, BlockPos position, BlockState state) {
        boolean doPlaceBlock;
        Block elementalBlock;
        BlockState transformed;
        if (state.m_60734_() instanceof IDragonProof || !DragonUtils.canDragonBreak(state, (Entity)dragon)) {
            return;
        }
        if (dragon.dragonType == DragonType.FIRE) {
            transformed = IafDragonDestructionManager.transformBlockFire(state);
        } else if (dragon.dragonType == DragonType.ICE) {
            transformed = IafDragonDestructionManager.transformBlockIce(state);
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            transformed = IafDragonDestructionManager.transformBlockLightning(state);
        } else {
            return;
        }
        if (!transformed.m_60713_(state.m_60734_())) {
            level.m_46597_(position, transformed);
        }
        if (dragon.dragonType == DragonType.FIRE) {
            elementalBlock = Blocks.f_50083_;
            doPlaceBlock = dragon.m_217043_().m_188499_();
        } else if (dragon.dragonType == DragonType.ICE) {
            elementalBlock = (Block)IafBlocks.DRAGON_ICE_SPIKES.get();
            doPlaceBlock = dragon.m_217043_().m_188503_(9) == 0;
        } else {
            return;
        }
        BlockState stateAbove = level.m_8055_(position.m_7494_());
        if (doPlaceBlock && transformed.m_280296_() && stateAbove.m_60819_().m_76178_() && !stateAbove.m_60815_() && state.m_60815_() && DragonUtils.canDragonBreak(stateAbove, (Entity)dragon)) {
            level.m_46597_(position.m_7494_(), elementalBlock.m_49966_());
        }
    }

    private static void attackBlock(Level level, EntityDragonBase dragon, BlockPos position) {
        IafDragonDestructionManager.attackBlock(level, dragon, position, level.m_8055_(position));
    }

    private static void applyDragonEffect(LivingEntity target, EntityDragonBase dragon, int statusDuration) {
        if (dragon.dragonType == DragonType.FIRE) {
            target.m_20254_(statusDuration);
        } else if (dragon.dragonType == DragonType.ICE) {
            IafEntityData data = IafEntityData.get(target);
            data.frozenData.setFrozen(target, statusDuration);
        } else if (dragon.dragonType == DragonType.LIGHTNING) {
            double x = dragon.m_20185_() - target.m_20185_();
            double y = dragon.m_20189_() - target.m_20189_();
            target.m_147240_((double)statusDuration / 10.0, x, y);
        }
    }

    private static void causeExplosion(Level world, BlockPos center, EntityDragonBase destroyer, DamageSource source, int stage) {
        Explosion.BlockInteraction mode = world.m_46469_().m_46207_(GameRules.f_46132_) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        BlockLaunchExplosion explosion = new BlockLaunchExplosion(world, (Mob)destroyer, source, center.m_123341_(), center.m_123342_(), center.m_123343_(), Math.min(2, stage - 2), mode);
        explosion.m_46061_();
        explosion.m_46075_(true);
    }

    private static void destroyBlocks(Level world, BlockPos center, int x, int y, int z, double radius2, Entity destroyer) {
        BlockPos.m_121990_((BlockPos)center.m_7918_(-x, -y, -z), (BlockPos)center.m_7918_(x, y, z)).forEach(pos -> {
            if (center.m_123331_((Vec3i)pos) <= radius2) {
                BlockState state = world.m_8055_(pos);
                if (state.m_60734_() instanceof IDragonProof) {
                    return;
                }
                if ((double)(world.f_46441_.m_188501_() * 3.0f) > (double)((float)center.m_123331_((Vec3i)pos)) / radius2 && DragonUtils.canDragonBreak(state, destroyer)) {
                    world.m_46961_(pos, false);
                }
            }
        });
    }

    public static BlockState transformBlockFire(BlockState in) {
        if (in.m_60734_() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlocks.CHARRED_GRASS.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60713_(Blocks.f_50493_)) {
            return (BlockState)((Block)IafBlocks.CHARRED_DIRT.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13029_) && in.m_60734_() == Blocks.f_49994_) {
            return (BlockState)((Block)IafBlocks.CHARRED_GRAVEL.get()).m_49966_().m_61124_((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13061_) && (in.m_60734_() == Blocks.f_50652_ || in.m_60734_().m_7705_().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlocks.CHARRED_COBBLESTONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13061_) && in.m_60734_() != IafBlocks.CHARRED_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlocks.CHARRED_STONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60734_() == Blocks.f_152481_) {
            return (BlockState)((Block)IafBlocks.CHARRED_DIRT_PATH.get()).m_49966_().m_61124_((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13106_) || in.m_204336_(BlockTags.f_13090_)) {
            return ((Block)IafBlocks.ASH.get()).m_49966_();
        }
        if (in.m_204336_(BlockTags.f_13035_) || in.m_204336_(BlockTags.f_13041_) || in.m_204336_(BlockTags.f_13073_) || in.m_60734_() == Blocks.f_50125_) {
            return Blocks.f_50016_.m_49966_();
        }
        return in;
    }

    public static BlockState transformBlockIce(BlockState in) {
        if (in.m_60734_() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlocks.FROZEN_GRASS.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_144274_) && in.m_60734_() == Blocks.f_50493_ || in.m_204336_(BlockTags.f_144279_)) {
            return (BlockState)((Block)IafBlocks.FROZEN_DIRT.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13029_) && in.m_60734_() == Blocks.f_49994_) {
            return (BlockState)((Block)IafBlocks.FROZEN_GRAVEL.get()).m_49966_().m_61124_((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13029_) && in.m_60734_() != Blocks.f_49994_) {
            return in;
        }
        if (in.m_204336_(BlockTags.f_13061_) && (in.m_60734_() == Blocks.f_50652_ || in.m_60734_().m_7705_().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlocks.FROZEN_COBBLESTONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13061_) && in.m_60734_() != IafBlocks.FROZEN_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlocks.FROZEN_STONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60734_() == Blocks.f_152481_) {
            return (BlockState)((Block)IafBlocks.FROZEN_DIRT_PATH.get()).m_49966_().m_61124_((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13106_) || in.m_204336_(BlockTags.f_13090_)) {
            return ((Block)IafBlocks.FROZEN_SPLINTERS.get()).m_49966_();
        }
        if (in.m_60713_(Blocks.f_49990_)) {
            return Blocks.f_50126_.m_49966_();
        }
        if (in.m_204336_(BlockTags.f_13035_) || in.m_204336_(BlockTags.f_13041_) || in.m_204336_(BlockTags.f_13073_) || in.m_60734_() == Blocks.f_50125_) {
            return Blocks.f_50016_.m_49966_();
        }
        return in;
    }

    public static BlockState transformBlockLightning(BlockState in) {
        if (in.m_60734_() instanceof SpreadingSnowyDirtBlock) {
            return (BlockState)((Block)IafBlocks.CRACKLED_GRASS.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_144274_) && in.m_60734_() == Blocks.f_50493_) {
            return (BlockState)((Block)IafBlocks.CRACKLED_DIRT.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13029_) && in.m_60734_() == Blocks.f_49994_) {
            return (BlockState)((Block)IafBlocks.CRACKLED_GRAVEL.get()).m_49966_().m_61124_((Property)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13061_) && (in.m_60734_() == Blocks.f_50652_ || in.m_60734_().m_7705_().contains("cobblestone"))) {
            return (BlockState)((Block)IafBlocks.CRACKLED_COBBLESTONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13061_) && in.m_60734_() != IafBlocks.CRACKLED_COBBLESTONE.get()) {
            return (BlockState)((Block)IafBlocks.CRACKLED_STONE.get()).m_49966_().m_61124_((Property)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_60734_() == Blocks.f_152481_) {
            return (BlockState)((Block)IafBlocks.CRACKLED_DIRT_PATH.get()).m_49966_().m_61124_((Property)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.m_204336_(BlockTags.f_13106_) || in.m_204336_(BlockTags.f_13090_)) {
            return ((Block)IafBlocks.ASH.get()).m_49966_();
        }
        if (in.m_204336_(BlockTags.f_13035_) || in.m_204336_(BlockTags.f_13041_) || in.m_204336_(BlockTags.f_13073_) || in.m_60734_() == Blocks.f_50125_) {
            return Blocks.f_50016_.m_49966_();
        }
        return in;
    }
}

