/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.EntityDragonEgg;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityEggInIce
extends BlockEntity {
    public DragonColor type;
    public int age;
    public int ticksExisted;
    public UUID ownerUUID;
    private boolean spawned;

    public BlockEntityEggInIce(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.EGG_IN_ICE.get(), pos, state);
    }

    public static void tickEgg(Level level, BlockPos pos, BlockState state, BlockEntityEggInIce entityEggInIce) {
        ++entityEggInIce.age;
        if (entityEggInIce.age >= (Integer)IafCommonConfig.INSTANCE.dragon.eggBornTime.getValue() && entityEggInIce.type != null && !entityEggInIce.spawned && !level.f_46443_) {
            EntityIceDragon dragon = (EntityIceDragon)((EntityType)IafEntities.ICE_DRAGON.get()).m_20615_(level);
            assert (dragon != null);
            dragon.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
            dragon.setVariant(entityEggInIce.type.name());
            dragon.setGender(ThreadLocalRandom.current().nextBoolean());
            dragon.m_7105_(true);
            dragon.setHunger(50);
            dragon.m_21816_(entityEggInIce.ownerUUID);
            level.m_7967_((Entity)dragon);
            entityEggInIce.spawned = true;
            level.m_46961_(pos, false);
            level.m_46597_(pos, Blocks.f_49990_.m_49966_());
        }
        ++entityEggInIce.ticksExisted;
    }

    public void m_183515_(CompoundTag tag) {
        if (this.type != null) {
            tag.m_128359_("Color", this.type.name());
        } else {
            tag.m_128344_("Color", (byte)0);
        }
        tag.m_128405_("Age", this.age);
        if (this.ownerUUID == null) {
            tag.m_128359_("OwnerUUID", "");
        } else {
            tag.m_128362_("OwnerUUID", this.ownerUUID);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.type = DragonColor.getById(tag.m_128461_("Color"));
        this.age = tag.m_128451_("Age");
        UUID s = null;
        if (tag.m_128403_("OwnerUUID")) {
            s = tag.m_128342_("OwnerUUID");
        } else {
            try {
                String s1 = tag.m_128461_("OwnerUUID");
                assert (this.f_58857_ != null);
                s = OldUsersConverter.m_11083_((MinecraftServer)this.f_58857_.m_7654_(), (String)s1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s != null) {
            this.ownerUUID = s;
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.m_183515_(nbtTagCompound);
        return nbtTagCompound;
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.m_183515_(nbtTagCompound);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void spawnEgg() {
        if (this.type != null) {
            EntityDragonEgg egg = new EntityDragonEgg((EntityType<EntityDragonEgg>)((EntityType)IafEntities.DRAGON_EGG.get()), this.f_58857_);
            egg.setEggType(this.type);
            egg.m_6034_((double)this.f_58858_.m_123341_() + 0.5, this.f_58858_.m_123342_() + 1, (double)this.f_58858_.m_123343_() + 0.5);
            egg.setOwnerId(this.ownerUUID);
            assert (this.f_58857_ != null);
            if (!this.f_58857_.f_46443_) {
                this.f_58857_.m_7967_((Entity)egg);
            }
        }
    }
}

