/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexWorker;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MyrmexAIForage
extends Goal {
    private static final int RADIUS = 16;
    private final EntityMyrmexWorker myrmex;
    private final BlockSorter targetSorter;
    private final int chance;
    private BlockPos targetBlock = null;
    private int wanderRadius;
    private PathResult path;
    private int failedToFindPath = 0;

    public MyrmexAIForage(EntityMyrmexWorker myrmex, int chanceIn) {
        this.myrmex = myrmex;
        this.targetSorter = new BlockSorter();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.chance = chanceIn;
    }

    public boolean m_8036_() {
        if (!this.myrmex.canMove() || this.myrmex.holdingSomething() || !this.myrmex.m_21573_().m_26571_() || this.myrmex.isInHive() || this.myrmex.shouldEnterHive()) {
            return false;
        }
        if (!(this.myrmex.m_21573_() instanceof AdvancedPathNavigate) || this.myrmex.m_20159_()) {
            return false;
        }
        if (this.myrmex.getWaitTicks() > 0) {
            return false;
        }
        List<BlockPos> edibleBlocks = this.getEdibleBlocks();
        if (edibleBlocks.isEmpty()) {
            return this.myrmex.m_217043_().m_188503_(this.chance) == 0 && this.increaseRadiusAndWander();
        }
        edibleBlocks.sort(this.targetSorter);
        this.targetBlock = edibleBlocks.get(0);
        this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_(), 1.0);
        return this.myrmex.m_217043_().m_188503_(this.chance) == 0;
    }

    public boolean m_8045_() {
        if (this.targetBlock == null) {
            return false;
        }
        if (this.myrmex.getWaitTicks() > 0) {
            return false;
        }
        if (this.myrmex.shouldEnterHive()) {
            this.myrmex.keepSearching = false;
            return false;
        }
        return !this.myrmex.holdingSomething();
    }

    public void m_8037_() {
        if (this.targetBlock != null && this.myrmex.keepSearching) {
            if (this.myrmex.isCloseEnoughToTarget(this.targetBlock, 12.0) || !this.myrmex.pathReachesTarget(this.path, this.targetBlock, 12.0)) {
                this.failedToFindPath = 0;
                List<BlockPos> edibleBlocks = this.getEdibleBlocks();
                if (!edibleBlocks.isEmpty()) {
                    this.myrmex.keepSearching = false;
                    edibleBlocks.sort(this.targetSorter);
                    this.targetBlock = edibleBlocks.get(0);
                    this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_(), 1.0);
                } else {
                    this.increaseRadiusAndWander();
                }
            }
        } else if (!this.myrmex.keepSearching) {
            this.failedToFindPath = 0;
            BlockState block = this.myrmex.m_9236_().m_8055_(this.targetBlock);
            if (block.m_204336_(IafBlockTags.MYRMEX_HARVESTABLES)) {
                double distance = this.getDistanceSq(this.targetBlock);
                if (distance < 6.0) {
                    block.m_60734_();
                    List drops = Block.m_49869_((BlockState)block, (ServerLevel)((ServerLevel)this.myrmex.m_9236_()), (BlockPos)this.targetBlock, (BlockEntity)this.myrmex.m_9236_().m_7702_(this.targetBlock));
                    if (!drops.isEmpty()) {
                        this.myrmex.m_9236_().m_46961_(this.targetBlock, false);
                        ItemStack heldStack = ((ItemStack)drops.get(0)).m_41777_();
                        heldStack.m_41764_(1);
                        ((ItemStack)drops.get(0)).m_41774_(1);
                        this.myrmex.m_21008_(InteractionHand.MAIN_HAND, heldStack);
                        for (ItemStack stack : drops) {
                            ItemEntity itemEntity = new ItemEntity(this.myrmex.m_9236_(), (double)this.targetBlock.m_123341_() + this.myrmex.m_217043_().m_188500_(), (double)this.targetBlock.m_123342_() + this.myrmex.m_217043_().m_188500_(), (double)this.targetBlock.m_123343_() + this.myrmex.m_217043_().m_188500_(), stack);
                            itemEntity.m_32060_();
                            if (this.myrmex.m_9236_().f_46443_) continue;
                            this.myrmex.m_9236_().m_7967_((Entity)itemEntity);
                        }
                        this.targetBlock = null;
                        this.m_8041_();
                        this.myrmex.keepSearching = false;
                        this.wanderRadius = 16;
                    }
                } else if (!this.myrmex.pathReachesTarget(this.path, this.targetBlock, 12.0)) {
                    List<BlockPos> edibleBlocks = this.getEdibleBlocks();
                    if (!edibleBlocks.isEmpty()) {
                        this.myrmex.keepSearching = false;
                        this.targetBlock = edibleBlocks.get(this.myrmex.m_217043_().m_188503_(edibleBlocks.size()));
                        this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_(), 1.0);
                    } else {
                        this.myrmex.keepSearching = true;
                    }
                }
            }
        }
    }

    public void m_8041_() {
        this.targetBlock = null;
        this.myrmex.keepSearching = true;
    }

    private double getDistanceSq(BlockPos pos) {
        double deltaX = this.myrmex.m_20185_() - ((double)pos.m_123341_() + 0.5);
        double deltaY = this.myrmex.m_20186_() + (double)this.myrmex.m_20192_() - ((double)pos.m_123342_() + 0.5);
        double deltaZ = this.myrmex.m_20189_() - ((double)pos.m_123343_() + 0.5);
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    private List<BlockPos> getEdibleBlocks() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos.m_121990_((BlockPos)this.myrmex.m_20183_().m_7918_(-16, -8, -16), (BlockPos)this.myrmex.m_20183_().m_7918_(16, 8, 16)).map(BlockPos::m_7949_).forEach(pos -> {
            BlockState blockState;
            if (!((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this.myrmex, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) && (blockState = this.myrmex.m_9236_().m_8055_(pos)).m_204336_(IafBlockTags.MYRMEX_HARVESTABLES)) {
                allBlocks.add((BlockPos)pos);
                this.myrmex.keepSearching = false;
            }
        });
        return allBlocks;
    }

    private boolean increaseRadiusAndWander() {
        Vec3 vec;
        this.myrmex.keepSearching = true;
        if (this.myrmex.getHive() != null) {
            this.wanderRadius = this.myrmex.getHive().getWanderRadius();
            this.myrmex.getHive().setWanderRadius(this.wanderRadius * 2);
        }
        this.wanderRadius *= 2;
        if (this.wanderRadius >= (Integer)IafCommonConfig.INSTANCE.myrmex.maximumWanderRadius.getValue()) {
            this.wanderRadius = (Integer)IafCommonConfig.INSTANCE.myrmex.maximumWanderRadius.getValue();
            this.myrmex.setWaitTicks(80 + ThreadLocalRandom.current().nextInt(40));
            ++this.failedToFindPath;
            if (this.failedToFindPath >= 10) {
                this.myrmex.setWaitTicks(800 + ThreadLocalRandom.current().nextInt(40));
            }
        }
        if ((vec = DefaultRandomPos.m_148403_((PathfinderMob)this.myrmex, (int)this.wanderRadius, (int)7)) != null) {
            this.targetBlock = BlockPos.m_274446_((Position)vec);
        }
        if (this.targetBlock != null) {
            this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_(), 1.0);
            return true;
        }
        return false;
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = MyrmexAIForage.this.getDistanceSq(pos1);
            double distance2 = MyrmexAIForage.this.getDistanceSq(pos2);
            return Double.compare(distance1, distance2);
        }
    }
}

