/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexEgg;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIForage;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIForageForItems;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIMoveThroughHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIPickupBabies;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIStoreBabies;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIStoreItems;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIWander;
import com.iafenvoy.iceandfire.entity.util.MyrmexTrades;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.item.ItemMyrmexEgg;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.animation.Animation;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityMyrmexWorker
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final ResourceLocation DESERT_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/myrmex_worker_desert");
    public static final ResourceLocation JUNGLE_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/myrmex_worker_jungle");
    private static final ResourceLocation TEXTURE_DESERT = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_worker.png");
    private static final ResourceLocation TEXTURE_JUNGLE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_worker.png");
    public boolean keepSearching = true;

    public EntityMyrmexWorker(EntityType<EntityMyrmexWorker> t, Level worldIn) {
        super(t, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return EntityMyrmexWorker.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, ((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue()).doubleValue()).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 4.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue()).doubleValue());
    }

    protected ResourceLocation m_7582_() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    public void m_6667_(DamageSource cause) {
        if (!this.m_9236_().f_46443_ && !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        super.m_6667_(cause);
    }

    @Override
    public int m_213860_() {
        return 3;
    }

    @Override
    public boolean isSmallerThanBlock() {
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && this.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof ItemMyrmexEgg) {
            boolean isJungle = this.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == IafItems.MYRMEX_JUNGLE_EGG.get();
            CompoundTag tag = this.m_21120_(InteractionHand.MAIN_HAND).m_41783_();
            int metadata = 0;
            if (tag != null) {
                metadata = tag.m_128451_("EggOrdinal");
            }
            EntityMyrmexEgg egg = new EntityMyrmexEgg((EntityType<? extends EntityMyrmexEgg>)((EntityType)IafEntities.MYRMEX_EGG.get()), this.m_9236_());
            egg.m_20359_((Entity)this);
            egg.setJungle(isJungle);
            egg.setMyrmexCaste(metadata);
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7967_((Entity)egg);
            }
            egg.m_20329_((Entity)this);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if (!this.m_20197_().isEmpty()) {
            for (Entity entity : this.m_20197_()) {
                if (!(entity instanceof EntityMyrmexBase) || ((EntityMyrmexBase)entity).getGrowthStage() < 2) continue;
                entity.m_8127_();
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new MyrmexAITradePlayer(this));
        this.f_21345_.m_25352_(0, (Goal)new MyrmexAILookAtTradePlayer(this));
        this.f_21345_.m_25352_(1, (Goal)new MyrmexAIAttackMelee(this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MyrmexAIStoreBabies(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MyrmexAIStoreItems(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MyrmexAIReEnterHive(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MyrmexAILeaveHive(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new MyrmexAIForage(this, 2));
        this.f_21345_.m_25352_(7, (Goal)new MyrmexAIMoveThroughHive(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new MyrmexAIWander(this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new MyrmexAIDefendHive(this));
        this.f_21346_.m_25352_(2, (Goal)new MyrmexAIForageForItems(this));
        this.f_21346_.m_25352_(3, new MyrmexAIPickupBabies(this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new MyrmexAIAttackPlayers(this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, (Predicate)((com.google.common.base.Predicate)entity -> this.m_21205_().m_41619_() && entity != null && !EntityMyrmexWorker.haveSameHive(this, (Entity)entity) && DragonUtils.isAlive(entity) && !(entity instanceof Enemy))));
    }

    @Override
    public boolean shouldWander() {
        return super.shouldWander() && this.canSeeSky();
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel1Trades() {
        return this.isJungle() ? (VillagerTrades.ItemListing[])MyrmexTrades.JUNGLE_WORKER.get(1) : (VillagerTrades.ItemListing[])MyrmexTrades.DESERT_WORKER.get(1);
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel2Trades() {
        return this.isJungle() ? (VillagerTrades.ItemListing[])MyrmexTrades.JUNGLE_WORKER.get(2) : (VillagerTrades.ItemListing[])MyrmexTrades.DESERT_WORKER.get(2);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.6f;
    }

    @Override
    public boolean shouldLeaveHive() {
        return !this.holdingSomething();
    }

    @Override
    public boolean shouldEnterHive() {
        if (this.holdingSomething()) {
            return true;
        }
        if (this.m_9236_().m_46461_()) {
            return false;
        }
        return (Boolean)IafCommonConfig.INSTANCE.myrmex.hiveIgnoreDaytime.getValue() == false;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return !this.shouldLeaveHive() && !this.holdingSomething();
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_STING : ANIMATION_BITE);
            float f = (float)this.m_21133_(Attributes.f_22281_);
            this.m_21335_(entityIn);
            boolean flag = entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), f);
            if (this.getAnimation() == ANIMATION_STING && flag) {
                this.playStingSound();
                if (entityIn instanceof LivingEntity) {
                    ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 2));
                    this.m_6710_((LivingEntity)entityIn);
                }
            } else {
                this.playBiteSound();
            }
            if (!this.m_9236_().f_46443_ && this.m_217043_().m_188503_(3) == 0 && this.m_21120_(InteractionHand.MAIN_HAND) != ItemStack.f_41583_) {
                this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            if (!this.m_20197_().isEmpty()) {
                for (Entity entity : this.m_20197_()) {
                    entity.m_8127_();
                }
            }
            return true;
        }
        return false;
    }

    public boolean holdingSomething() {
        return this.getHeldEntity() != null || !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_() || this.m_5448_() != null;
    }

    public boolean holdingBaby() {
        return this.getHeldEntity() != null && (this.getHeldEntity() instanceof EntityMyrmexBase || this.getHeldEntity() instanceof EntityMyrmexEgg);
    }

    @Override
    public int getCasteImportance() {
        return 0;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING};
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (this.m_20363_(passenger)) {
            this.f_20883_ = this.m_146908_();
            float radius = 1.05f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + 0.25, this.m_20189_() + extraZ);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if ((double)amount >= 1.0 && !this.m_9236_().f_46443_ && this.m_217043_().m_188503_(3) == 0 && this.m_21120_(InteractionHand.MAIN_HAND) != ItemStack.f_41583_) {
            this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        if ((double)amount >= 1.0 && !this.m_20197_().isEmpty()) {
            for (Entity entity : this.m_20197_()) {
                entity.m_8127_();
            }
        }
        return super.m_6469_(source, amount);
    }

    public Entity getHeldEntity() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public void onPickupItem(ItemEntity itemEntity) {
        Item item = itemEntity.m_32055_().m_41720_();
        if (item == IafItems.MYRMEX_JUNGLE_RESIN.get() && this.isJungle() || item == IafItems.MYRMEX_DESERT_RESIN.get() && !this.isJungle()) {
            Player owner = null;
            try {
                if (itemEntity.m_19749_() != null) {
                    owner = (Player)itemEntity.m_19749_();
                }
            }
            catch (Exception e) {
                IceAndFire.LOGGER.warn("Myrmex picked up resin that wasn't thrown!");
            }
            if (owner != null && this.getHive() != null) {
                this.getHive().modifyPlayerReputation(owner.m_20148_(), 5);
                this.m_5496_(SoundEvents.f_12388_, 1.0f, 1.0f);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 1 + this.f_19796_.m_188503_(3)));
                }
            }
        }
    }

    public int m_7809_() {
        return 0;
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }
}

