/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityMyrmexBase;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIFindHidingSpot;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILeaveHive;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.iafenvoy.iceandfire.entity.ai.MyrmexAIWander;
import com.iafenvoy.iceandfire.entity.util.MyrmexTrades;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.uranus.animation.Animation;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class EntityMyrmexSentinel
extends EntityMyrmexBase {
    public static final Animation ANIMATION_GRAB = Animation.create((int)15);
    public static final Animation ANIMATION_NIBBLE = Animation.create((int)10);
    public static final Animation ANIMATION_STING = Animation.create((int)25);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final ResourceLocation DESERT_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/myrmex_sentinel_desert");
    public static final ResourceLocation JUNGLE_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/myrmex_sentinel_jungle");
    private static final ResourceLocation TEXTURE_DESERT = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_sentinel.png");
    private static final ResourceLocation TEXTURE_JUNGLE = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_sentinel.png");
    private static final ResourceLocation TEXTURE_DESERT_HIDDEN = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/myrmex/myrmex_desert_sentinel_hidden.png");
    private static final ResourceLocation TEXTURE_JUNGLE_HIDDEN = ResourceLocation.m_214293_((String)"iceandfire", (String)"textures/models/myrmex/myrmex_jungle_sentinel_hidden.png");
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.m_135353_(EntityMyrmexSentinel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float holdingProgress;
    public float hidingProgress;
    public int visibleTicks = 0;
    public int daylightTicks = 0;

    public EntityMyrmexSentinel(EntityType<? extends EntityMyrmexSentinel> t, Level worldIn) {
        super(t, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return EntityMyrmexSentinel.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, (Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 3.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22284_, 12.0);
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel1Trades() {
        return this.isJungle() ? (VillagerTrades.ItemListing[])MyrmexTrades.JUNGLE_SENTINEL.get(1) : (VillagerTrades.ItemListing[])MyrmexTrades.DESERT_SENTINEL.get(1);
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel2Trades() {
        return this.isJungle() ? (VillagerTrades.ItemListing[])MyrmexTrades.JUNGLE_SENTINEL.get(2) : (VillagerTrades.ItemListing[])MyrmexTrades.DESERT_SENTINEL.get(2);
    }

    protected ResourceLocation m_7582_() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    public int m_213860_() {
        return 8;
    }

    public Entity getHeldEntity() {
        return this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
    }

    public void m_8107_() {
        double dist;
        boolean hiding;
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        this.visibleTicks = this.visibleTicks > 0 ? --this.visibleTicks : 0;
        if (attackTarget != null) {
            this.visibleTicks = 100;
        }
        this.daylightTicks = this.canSeeSky() ? ++this.daylightTicks : 0;
        boolean holding = this.getHeldEntity() != null;
        boolean bl = hiding = this.isHiding() && !this.hasCustomer();
        if (holding || this.isOnResin() || attackTarget != null || this.visibleTicks > 0) {
            this.setHiding(false);
        }
        if (holding && this.holdingProgress < 20.0f) {
            this.holdingProgress += 1.0f;
        } else if (!holding && this.holdingProgress > 0.0f) {
            this.holdingProgress -= 1.0f;
        }
        if (hiding) {
            this.m_146922_(this.f_19859_);
        }
        if (hiding && this.hidingProgress < 20.0f) {
            this.hidingProgress += 1.0f;
        } else if (!hiding && this.hidingProgress > 0.0f) {
            this.hidingProgress -= 1.0f;
        }
        if (this.getHeldEntity() != null) {
            this.setAnimation(ANIMATION_NIBBLE);
            if (this.getAnimationTick() == 5) {
                this.playBiteSound();
                this.getHeldEntity().m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()) / 6.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_GRAB && attackTarget != null && this.getAnimationTick() == 7) {
            this.playStingSound();
            if (this.getAttackBounds().m_82381_(attackTarget.m_20191_())) {
                attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()) / 2.0f);
                if (attackTarget instanceof EntityDragonBase) {
                    if (!((EntityDragonBase)attackTarget).isMobDead()) {
                        attackTarget.m_20329_((Entity)this);
                    }
                } else {
                    attackTarget.m_20329_((Entity)this);
                }
            }
        }
        if (this.getAnimation() == ANIMATION_SLASH && attackTarget != null && this.getAnimationTick() % 5 == 0 && this.getAnimationTick() <= 20) {
            this.playBiteSound();
            if (this.getAttackBounds().m_82381_(attackTarget.m_20191_())) {
                attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()) / 4.0f);
            }
        }
        if (this.getAnimation() == ANIMATION_STING && (this.getAnimationTick() == 0 || this.getAnimationTick() == 10)) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && attackTarget != null && (this.getAnimationTick() == 6 || this.getAnimationTick() == 16) && (dist = this.m_20280_((Entity)attackTarget)) < 18.0) {
            attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
            attackTarget.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 3));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new MyrmexAIFindHidingSpot(this));
        this.f_21345_.m_25352_(0, (Goal)new MyrmexAITradePlayer(this));
        this.f_21345_.m_25352_(0, (Goal)new MyrmexAILookAtTradePlayer(this));
        this.f_21345_.m_25352_(1, (Goal)new MyrmexAIAttackMelee(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new MyrmexAILeaveHive(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MyrmexAIWander(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new MyrmexAIDefendHive(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new MyrmexAIAttackPlayers(this));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 4, true, true, (Predicate)((com.google.common.base.Predicate)entity -> entity != null && !EntityMyrmexSentinel.haveSameHive(this, (Entity)entity) && DragonUtils.isAlive(entity) && !(entity instanceof Enemy))));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HIDING, (Object)Boolean.FALSE);
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((Double)IafCommonConfig.INSTANCE.myrmex.baseAttackDamage.getValue() * 3.0);
    }

    @Override
    public ResourceLocation getAdultTexture() {
        if (this.isHiding()) {
            return this.isJungle() ? TEXTURE_JUNGLE_HIDDEN : TEXTURE_DESERT_HIDDEN;
        }
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 0.8f;
    }

    @Override
    public int getCasteImportance() {
        return 2;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Hiding", this.isHiding());
        tag.m_128405_("DaylightTicks", this.daylightTicks);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHiding(tag.m_128471_("Hiding"));
        this.daylightTicks = tag.m_128451_("DaylightTicks");
    }

    @Override
    public boolean shouldLeaveHive() {
        return true;
    }

    @Override
    public boolean shouldEnterHive() {
        return false;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (this.m_20363_(passenger)) {
            this.f_20883_ = this.m_146908_();
            float radius = 1.25f;
            float extraY = 0.35f;
            if (this.getAnimation() == ANIMATION_GRAB) {
                int modTick = Mth.m_14045_((int)this.getAnimationTick(), (int)0, (int)10);
                radius = 3.25f - (float)modTick * 0.2f;
                extraY = (float)modTick * 0.035f;
            }
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            if (passenger.m_20206_() >= 1.75f) {
                extraY = passenger.m_20206_() - 2.0f;
            }
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + (double)extraY, this.m_20189_() + extraZ);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if ((double)amount >= 1.0 && !this.m_20197_().isEmpty() && this.f_19796_.m_188503_(2) == 0) {
            for (Entity entity : this.m_20197_()) {
                entity.m_8127_();
            }
        }
        this.visibleTicks = 300;
        this.setHiding(false);
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_SLASH && this.getAnimation() != ANIMATION_GRAB && this.getHeldEntity() == null) {
            if (this.m_217043_().m_188503_(2) == 0 && entityIn.m_20205_() < 2.0f) {
                this.setAnimation(ANIMATION_GRAB);
            } else {
                this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_STING : ANIMATION_SLASH);
            }
            this.visibleTicks = 300;
            return true;
        }
        return false;
    }

    @Override
    public boolean needsGaurding() {
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_SLASH, ANIMATION_STING, ANIMATION_GRAB, ANIMATION_NIBBLE};
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.getHeldEntity() == null && !this.isHiding();
    }

    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(HIDING);
    }

    public void setHiding(boolean hiding) {
        this.f_19804_.m_135381_(HIDING, (Object)hiding);
    }

    public int m_7809_() {
        return 4;
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }
}

