/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDragonLightningCharge;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonDestructionManager;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityLightningDragon
extends EntityDragonBase {
    public static final ResourceLocation FEMALE_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/dragon/lightning_dragon_female");
    public static final ResourceLocation MALE_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/dragon/lightning_dragon_male");
    public static final ResourceLocation SKELETON_LOOT = ResourceLocation.m_214293_((String)"iceandfire", (String)"entities/dragon/lightning_dragon_skeleton");
    private static final EntityDataAccessor<Boolean> HAS_LIGHTNING_TARGET = SynchedEntityData.m_135353_(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> LIGHTNING_TARGET_X = SynchedEntityData.m_135353_(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> LIGHTNING_TARGET_Y = SynchedEntityData.m_135353_(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> LIGHTNING_TARGET_Z = SynchedEntityData.m_135353_(EntityLightningDragon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public EntityLightningDragon(EntityType<? extends EntityLightningDragon> t, Level worldIn) {
        super(t, worldIn, DragonType.LIGHTNING, 1.0, 1 + (Integer)IafCommonConfig.INSTANCE.dragon.attackDamage.getValue(), (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue() * 0.04, (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue(), 0.15f, 0.4f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)30);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_LIGHTNING_TARGET, (Object)false);
        this.f_19804_.m_135372_(LIGHTNING_TARGET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIGHTNING_TARGET_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIGHTNING_TARGET_Z, (Object)Float.valueOf(0.0f));
    }

    @Override
    public int getStartMetaForType() {
        return 8;
    }

    @Override
    protected boolean shouldTarget(Entity entity) {
        if (entity instanceof EntityDragonBase && !this.m_21824_()) {
            return entity.m_6095_() != this.m_6095_() && this.m_20205_() >= entity.m_20205_() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof Player || DragonUtils.isDragonTargetable(entity, IafEntityTags.LIGHTNING_DRAGON_TARGETS) || !this.m_21824_() && DragonUtils.isVillager(entity);
    }

    @Override
    public boolean isTimeToWake() {
        return !this.m_9236_().m_46461_() || this.getCommand() == 2;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    public String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "amethyst_";
            case 2 -> "copper_";
            case 3 -> "black_";
            default -> "electric_";
        };
    }

    public boolean m_6673_(DamageSource i) {
        if (i.m_19385_().equals(this.m_9236_().m_269111_().m_269548_().m_19385_())) {
            this.m_5634_(15.0f);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 20, 1));
            return true;
        }
        return super.m_6673_(i);
    }

    public void setHasLightningTarget(boolean lightning_target) {
        this.f_19804_.m_135381_(HAS_LIGHTNING_TARGET, (Object)lightning_target);
    }

    public boolean hasLightningTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_LIGHTNING_TARGET);
    }

    public void setLightningTargetVec(float x, float y, float z) {
        this.f_19804_.m_135381_(LIGHTNING_TARGET_X, (Object)Float.valueOf(x));
        this.f_19804_.m_135381_(LIGHTNING_TARGET_Y, (Object)Float.valueOf(y));
        this.f_19804_.m_135381_(LIGHTNING_TARGET_Z, (Object)Float.valueOf(z));
    }

    public float getLightningTargetX() {
        return ((Float)this.f_19804_.m_135370_(LIGHTNING_TARGET_X)).floatValue();
    }

    public float getLightningTargetY() {
        return ((Float)this.f_19804_.m_135370_(LIGHTNING_TARGET_Y)).floatValue();
    }

    public float getLightningTargetZ() {
        return ((Float)this.f_19804_.m_135370_(LIGHTNING_TARGET_Z)).floatValue();
    }

    @Override
    public boolean m_7327_(Entity entityIn) {
        this.m_21563_().m_24960_(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0), entityIn.m_20182_().m_82520_(0.0, (double)(entityIn.m_20206_() / 2.0f), 0.0)) && entityIn.m_20205_() < this.m_20205_() * 0.5f && this.m_6688_() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.m_20329_((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        LivingEntity attackTarget = this.m_5448_();
        if (!this.m_9236_().f_46443_ && attackTarget != null) {
            if (this.m_20191_().m_82377_((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).m_82381_(attackTarget.m_20191_())) {
                this.m_7327_((Entity)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.m_20096_())) {
                this.shootFireAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.m_20280_((Entity)attackTarget) < 100.0) {
                double difX = attackTarget.m_20185_() - this.m_20185_();
                double difY = attackTarget.m_20186_() + (double)attackTarget.m_20206_() - this.m_20186_();
                double difZ = attackTarget.m_20189_() - this.m_20189_();
                this.m_20256_(this.m_20184_().m_82520_(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.m_20191_().m_82377_((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).m_82381_(attackTarget.m_20191_())) {
                    this.m_7327_((Entity)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
        if (!this.isBreathingFire()) {
            this.setHasLightningTarget(false);
        }
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.m_146922_(this.f_20883_);
                if (this.fireBreathTicks % 7 == 0) {
                    this.m_5496_((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.m_123341_() + 0.5f, (float)burningTarget.m_123342_() + 0.5f, (float)burningTarget.m_123343_() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.m_217043_().m_188503_(5) == 0 && !this.m_6162_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.m_146922_(this.f_20883_);
                Vec3 headVec = this.getHeadPosition();
                this.m_5496_((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH_CRACKLE.get(), 4.0f, 1.0f);
                double d2 = controller.m_20154_().f_82479_;
                double d3 = controller.m_20154_().f_82480_;
                double d4 = controller.m_20154_().f_82481_;
                float inaccuracy = 1.0f;
                EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.LIGHTNING_DRAGON_CHARGE.get()), this.m_9236_(), this, d2 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7967_((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                HitResult mop;
                this.m_146922_(this.f_20883_);
                if (this.fireBreathTicks % 7 == 0) {
                    this.m_5496_((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.m_82450_().f_82479_, mop.m_82450_().f_82480_, mop.m_82450_().f_82481_, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public Item getBloodItem() {
        return (Item)IafItems.LIGHTNING_DRAGON_BLOOD.get();
    }

    @Override
    public Item getFleshItem() {
        return (Item)IafItems.LIGHTNING_DRAGON_FLESH.get();
    }

    @Override
    public ItemLike getHeartItem() {
        return (ItemLike)IafItems.LIGHTNING_DRAGON_HEART.get();
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(LivingEntity entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.m_217043_().m_188503_(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 20) {
                    this.m_146922_(this.f_20883_);
                    Vec3 headVec = this.getHeadPosition();
                    double d2 = entity.m_20185_() - headVec.f_82479_;
                    double d3 = entity.m_20186_() - headVec.f_82480_;
                    double d4 = entity.m_20189_() - headVec.f_82481_;
                    float inaccuracy = 1.0f;
                    this.m_5496_((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                    EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.LIGHTNING_DRAGON_CHARGE.get()), this.m_9236_(), this, d2 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_7967_((Entity)entitylargefireball);
                    }
                    if (!entity.m_6084_()) {
                        this.setBreathingFire(false);
                    }
                    this.randomizeAttacks();
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.m_146922_(this.f_20883_);
                    if (this.f_19797_ % 5 == 0) {
                        this.m_5496_((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH.get(), 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 1);
                    if (!entity.m_6084_()) {
                        this.setBreathingFire(false);
                        this.randomizeAttacks();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.m_21391_((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (((IafEvents.DragonFire)IafEvents.ON_DRAGON_FIRE_BLOCK.invoker()).onFireBlock(this, burnX, burnY, burnZ)) {
            return;
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.m_146922_(this.f_20883_);
                Vec3 headVec = this.getHeadPosition();
                double d2 = burnX - headVec.f_82479_;
                double d3 = burnY - headVec.f_82480_;
                double d4 = burnZ - headVec.f_82481_;
                float inaccuracy = 1.0f;
                this.m_5496_((SoundEvent)IafSounds.LIGHTNINGDRAGON_BREATH_CRACKLE.get(), 4.0f, 1.0f);
                EntityDragonLightningCharge entitylargefireball = new EntityDragonLightningCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.LIGHTNING_DRAGON_CHARGE.get()), this.m_9236_(), this, d2 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, d3 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, d4 += this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.m_6034_(headVec.f_82479_, headVec.f_82480_, headVec.f_82481_);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7967_((Entity)entitylargefireball);
                }
            }
            return;
        }
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vec3 headPos = this.getHeadPosition();
        double d2 = burnX - headPos.f_82479_;
        double d3 = burnY - headPos.f_82480_;
        double d4 = burnZ - headPos.f_82481_;
        double distance = Math.max(2.5 * Math.sqrt(this.m_20275_(burnX, burnY, burnZ)), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.f_82479_ + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.f_82480_ + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.f_82481_ + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                this.setHasLightningTarget(true);
                this.setLightningTargetVec((float)burnX, (float)burnY, (float)burnZ);
            } else if (!this.m_9236_().f_46443_) {
                BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_()), new Vec3(progressX, progressY, progressZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                Vec3 vec3 = result.m_82450_();
                BlockPos pos = BlockPos.m_274446_((Position)vec3);
                IafDragonDestructionManager.destroyAreaBreath(this.m_9236_(), pos, this);
                this.setHasLightningTarget(true);
                this.setLightningTargetVec((float)result.m_82450_().f_82479_, (float)result.m_82450_().f_82480_, (float)result.m_82450_().f_82481_);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.f_19796_.m_188501_() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.f_19796_.m_188501_() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.f_19796_.m_188501_() * 3.0 - 1.5;
            this.setHasLightningTarget(true);
            this.setLightningTargetVec((float)spawnX, (float)spawnY, (float)spawnZ);
            if (!this.m_9236_().f_46443_) {
                IafDragonDestructionManager.destroyAreaBreath(this.m_9236_(), BlockPos.m_274561_((double)spawnX, (double)spawnY, (double)spawnZ), this);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_IDLE.get() : (this.m_6125_() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_IDLE.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_IDLE.get());
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_HURT.get() : (this.m_6125_() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_HURT.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_HURT.get());
    }

    protected SoundEvent m_5592_() {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_DEATH.get() : (this.m_6125_() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_DEATH.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_DEATH.get());
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_TEEN_ROAR.get() : (this.m_6125_() ? (SoundEvent)IafSounds.LIGHTNINGDRAGON_ADULT_ROAR.get() : (SoundEvent)IafSounds.LIGHTNINGDRAGON_CHILD_ROAR.get());
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT, ANIMATION_SPEAK, ANIMATION_BITE, ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR, ANIMATION_EPIC_ROAR};
    }

    public boolean m_6898_(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() != null && stack.m_41720_() == IafItems.LIGHTNING_STEW.get();
    }

    @Override
    protected void spawnDeathParticles() {
        for (int k = 0; k < 3; ++k) {
            double d2 = this.f_19796_.m_188583_() * 0.02;
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            if (!this.m_9236_().f_46443_) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123761_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d2, d0, d1);
        }
    }

    @Override
    public void spawnBabyParticles() {
        for (int i = 0; i < 5; ++i) {
            float radiusAdd = (float)i * 0.15f;
            float headPosX = (float)(this.m_20185_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
            float headPosZ = (float)(this.m_20186_() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
            float headPosY = (float)(this.m_20189_() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ItemStack getSkull() {
        return new ItemStack((ItemLike)IafItems.DRAGON_SKULL_LIGHTNING.get());
    }
}

