/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.ai.AquaticAIFindWaterTarget;
import com.iafenvoy.iceandfire.entity.ai.AquaticAIGetInWater;
import com.iafenvoy.iceandfire.entity.ai.HippocampusAIWander;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.screen.handler.HippocampusScreenHandler;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.data.EntityPropertyDelegate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityHippocampus
extends TamableAnimal
implements MenuProvider,
ISyncMount,
IAnimatedEntity,
ICustomMoveController,
ContainerListener,
Saddleable {
    public static final int INV_SLOT_SADDLE = 0;
    public static final int INV_SLOT_CHEST = 1;
    public static final int INV_SLOT_ARMOR = 2;
    public static final int INV_BASE_COUNT = 3;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLE = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ARMOR = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.m_135353_(EntityHippocampus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_SITTING = 1;
    private static final int FLAG_TAME = 4;
    private static final Component CONTAINER_TITLE = Component.m_237115_((String)"entity.iceandfire.hippocampus");
    public static Animation ANIMATION_SPEAK;
    public float onLandProgress;
    public ChainBuffer tail_buffer;
    public SimpleContainer inventory;
    public float sitProgress;
    private int animationTick;
    private Animation currentAnimation;

    public EntityHippocampus(EntityType<? extends EntityHippocampus> entityType, Level worldIn) {
        super(entityType, worldIn);
        ANIMATION_SPEAK = Animation.create((int)15);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new HippoMoveControl(this);
        this.m_274367_(1.0f);
        if (worldIn.f_46443_) {
            this.tail_buffer = new ChainBuffer();
        }
        this.createInventory();
    }

    public static int getIntFromArmor(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42651_) {
            return 1;
        }
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42652_) {
            return 2;
        }
        if (!stack.m_41619_() && stack.m_41720_() == Items.f_42653_) {
            return 3;
        }
        return 0;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AquaticAIFindWaterTarget((Mob)this, 10, true));
        this.f_21345_.m_25352_(2, (Goal)new AquaticAIGetInWater((Mob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new HippocampusAIWander((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(0, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(IafItemTags.TEMPT_HIPPOCAMPUS), false));
    }

    public int m_213860_() {
        return 2;
    }

    public float m_21692_(BlockPos pos) {
        return this.m_9236_().m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49990_) ? 10.0f : (float)this.m_9236_().m_46803_(pos) - 0.5f;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                TamableAnimal tameable = (TamableAnimal)entityIn;
                return tameable.m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(ARMOR, (Object)0);
        this.f_19804_.m_135372_(SADDLE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CONTROL_STATE, (Object)0);
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob;
        }
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public ItemStack m_255207_(ItemStack itemStackIn) {
        if (itemStackIn == null) {
            return ItemStack.f_41583_;
        }
        EquipmentSlot equipmentSlot = EntityHippocampus.m_147233_((ItemStack)itemStackIn);
        int j = equipmentSlot.m_20749_() - 500 + 2;
        if (j >= 0 && j < this.inventory.m_6643_()) {
            this.inventory.m_6836_(j, itemStackIn);
            return itemStackIn;
        }
        return ItemStack.f_41583_;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null && !this.m_9236_().f_46443_) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.isChested()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
            }
            this.setChested(false);
        }
    }

    protected void dropChestItems() {
        for (int i = 3; i < 18; ++i) {
            if (this.inventory.m_8020_(i).m_41619_()) continue;
            if (!this.m_9236_().f_46443_) {
                this.m_5552_(this.inventory.m_8020_(i), 1.0f);
            }
            this.inventory.m_8016_(i);
        }
    }

    private void updateControlState(int i, boolean newState) {
        byte prevState = (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
        if (newState) {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.f_19804_.m_135381_(CONTROL_STATE, (Object)state);
    }

    public boolean m_7341_(Entity rider) {
        return true;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (this.m_20363_(passenger)) {
            this.f_20883_ = this.m_146908_();
            this.m_5618_(passenger.m_146908_());
        }
        double ymod1 = (double)this.onLandProgress * -0.02;
        passenger.m_6034_(this.m_20185_(), this.m_20186_() + (double)0.6f + ymod1, this.m_20189_());
    }

    public void m_8107_() {
        boolean inWater;
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.f_19796_.m_188503_(900) == 0 && this.f_20919_ == 0) {
            this.m_5634_(1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.m_6688_() != null && this.f_19797_ % 20 == 0) {
            this.m_6688_().m_7292_(new MobEffectInstance(MobEffects.f_19608_, 30, 0, true, false));
        }
        if (this.m_9236_().f_46443_) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 1.0f, (LivingEntity)this);
        }
        if (!(inWater = this.m_20069_()) && this.onLandProgress < 20.0f) {
            this.onLandProgress += 1.0f;
        } else if (inWater && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        boolean sitting = this.m_21827_();
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += 0.5f;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= 0.5f;
        }
    }

    protected void m_274498_(Player player, Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_6109_()) {
            Vec3 vec3 = this.m_20184_();
            if (this.isGoingUp()) {
                if (!this.m_20069_() && this.m_20096_()) {
                    this.m_6135_();
                } else if (this.m_20069_()) {
                    this.m_20256_(vec3.m_82520_(0.0, (double)0.04f, 0.0));
                }
            }
            if (this.isGoingDown() && this.m_20069_()) {
                this.m_20256_(vec3.m_82520_(0.0, (double)-0.025f, 0.0));
            }
        }
    }

    protected Vec3 m_274312_(Player player, Vec3 travelVector) {
        float f = player.f_20900_ * 0.5f;
        float f1 = player.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.m_146909_() * 0.5f, entity.m_146908_());
    }

    protected float m_245547_(Player player) {
        float speed = (float)this.m_21133_(Attributes.f_22279_) * 0.6f;
        speed = this.m_20069_() ? (speed *= ((Double)IafCommonConfig.INSTANCE.hippocampus.swimSpeedMod.getValue()).floatValue()) : (speed *= 0.2f);
        return speed;
    }

    public boolean isGoingUp() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) & 1) == 1;
    }

    public boolean isGoingDown() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean isBlinking() {
        return this.f_19797_ % 50 > 43;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Chested", this.isChested());
        compound.m_128379_("Saddled", this.m_6254_());
        compound.m_128405_("Armor", this.m_21230_());
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag CompoundNBT = new CompoundTag();
            CompoundNBT.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(CompoundNBT);
            nbttaglist.add((Object)CompoundNBT);
        }
        compound.m_128365_("Items", (Tag)nbttaglist);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setChested(compound.m_128471_("Chested"));
        this.setSaddled(compound.m_128471_("Saddled"));
        this.setArmor(compound.m_128451_("Armor"));
        if (this.inventory != null) {
            ListTag nbttaglist = compound.m_128437_("Items", 10);
            this.createInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag CompoundNBT = nbttaglist.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        }
    }

    protected int getInventorySize() {
        return this.isChested() ? 18 : 3;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.setSaddled(!this.inventory.m_8020_(0).m_41619_());
            this.setChested(!this.inventory.m_8020_(1).m_41619_());
            this.setArmor(EntityHippocampus.getIntFromArmor(this.inventory.m_8020_(2)));
        }
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.inventory != pInventory;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_() && this.m_21824_();
    }

    public void m_5853_(SoundSource pSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42450_));
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(SADDLE);
    }

    public void setSaddled(boolean saddle) {
        this.f_19804_.m_135381_(SADDLE, (Object)saddle);
    }

    public boolean isChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setChested(boolean chested) {
        this.f_19804_.m_135381_(CHESTED, (Object)chested);
        if (!chested) {
            this.dropChestItems();
        }
    }

    public int m_21230_() {
        return (Integer)this.f_19804_.m_135370_(ARMOR);
    }

    public void setArmor(int armorType) {
        this.f_19804_.m_135381_(ARMOR, (Object)armorType);
        double armorValue = switch (armorType) {
            case 1 -> 10.0;
            case 2 -> 20.0;
            case 3 -> 30.0;
            default -> 0.0;
        };
        this.m_21051_(Attributes.f_22284_).m_22100_(armorValue);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.m_217043_().m_188503_(6));
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_SPEAK};
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        if (ageable instanceof EntityHippocampus) {
            EntityHippocampus hippo = new EntityHippocampus((EntityType<? extends EntityHippocampus>)((EntityType)IafEntities.HIPPOCAMPUS.get()), this.m_9236_());
            hippo.setVariant(this.m_217043_().m_188499_() ? this.getVariant() : ((EntityHippocampus)ageable).getVariant());
            return hippo;
        }
        return null;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(0.1f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(IafItemTags.BREED_HIPPOCAMPUS);
    }

    public void m_8032_() {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_8032_();
    }

    protected void m_6677_(DamageSource source) {
        if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.m_6677_(source);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_204117_(IafItemTags.BREED_HIPPOCAMPUS) && this.m_146764_() == 0 && !this.m_27593_()) {
            this.m_21839_(false);
            this.m_27595_(player);
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_204117_(IafItemTags.HEAL_HIPPOCAMPUS)) {
            int i;
            if (!this.m_9236_().f_46443_) {
                this.m_5634_(5.0f);
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                for (i = 0; i < 3; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
            }
            if (!this.m_21824_() && this.m_217043_().m_188503_(3) == 0) {
                this.m_21828_(player);
                for (i = 0; i < 6; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)player) && itemstack.m_41720_() == Items.f_42398_) {
            this.m_21839_(!this.m_21827_());
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)player) && itemstack.m_41619_() && player.m_6144_()) {
            this.openInventory(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21830_((LivingEntity)player) && this.m_6254_() && !this.m_6162_() && !player.m_20159_()) {
            this.doPlayerRide(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void doPlayerRide(Player pPlayer) {
        this.m_21839_(false);
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new HippocampusScreenHandler(syncId, (Container)this.inventory, inv, this, new EntityPropertyDelegate(this.m_19879_()));
    }

    public void openInventory(Player player) {
        player.m_5893_((MenuProvider)this);
    }

    @Override
    public void up(boolean up) {
        this.updateControlState(0, up);
    }

    @Override
    public void down(boolean down) {
        this.updateControlState(1, down);
    }

    @Override
    public void attack(boolean attack) {
    }

    @Override
    public void strike(boolean strike) {
    }

    @Override
    public void dismount(boolean dismount) {
        this.updateControlState(2, dismount);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IafSounds.HIPPOCAMPUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)IafSounds.HIPPOCAMPUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IafSounds.HIPPOCAMPUS_DIE.get();
    }

    public boolean m_21532_() {
        return true;
    }

    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    public int getInventoryColumns() {
        return 5;
    }

    public void m_5757_(Container pInvBasic) {
        boolean flag = this.m_6254_();
        this.updateContainerEquipment();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
        }
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20301_(this.m_6062_());
    }

    class HippoMoveControl
    extends MoveControl {
        private final EntityHippocampus hippo;

        public HippoMoveControl(EntityHippocampus entityHippocampus) {
            super((Mob)entityHippocampus);
            this.hippo = EntityHippocampus.this;
        }

        private void updateSpeed() {
            if (this.hippo.m_20069_()) {
                this.hippo.m_20256_(this.hippo.m_20184_().m_82520_(0.0, 0.005, 0.0));
            } else if (this.hippo.m_20096_()) {
                this.hippo.m_7910_(Math.max(this.hippo.m_6113_() / 4.0f, 0.06f));
            }
        }

        public void m_8126_() {
            this.updateSpeed();
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.hippo.m_21573_().m_26571_()) {
                double d2;
                double d1;
                double d0 = this.f_24975_ - this.hippo.m_20185_();
                double distance = Math.sqrt(d0 * d0 + (d1 = this.f_24976_ - this.hippo.m_20186_()) * d1 + (d2 = this.f_24977_ - this.hippo.m_20189_()) * d2);
                if (distance < (double)1.0E-5f) {
                    this.f_24974_.m_7910_(0.0f);
                } else {
                    d1 /= distance;
                    float minRotation = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.hippo.m_146922_(this.m_24991_(this.hippo.m_146908_(), minRotation, 90.0f));
                    this.hippo.f_20883_ = this.hippo.m_146908_();
                    float maxSpeed = (float)(this.f_24978_ * this.hippo.m_21133_(Attributes.f_22279_));
                    maxSpeed *= 0.6f;
                    maxSpeed = this.hippo.m_20069_() ? (maxSpeed *= ((Double)IafCommonConfig.INSTANCE.hippocampus.swimSpeedMod.getValue()).floatValue()) : (maxSpeed *= 0.2f);
                    this.hippo.m_7910_(Mth.m_14179_((float)0.125f, (float)this.hippo.m_6113_(), (float)maxSpeed));
                    this.hippo.m_20256_(this.hippo.m_20184_().m_82520_(0.0, (double)this.hippo.m_6113_() * d1 * 0.1, 0.0));
                }
            } else {
                this.hippo.m_7910_(0.0f);
            }
        }
    }
}

