/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.EntityDreadMob;
import com.iafenvoy.iceandfire.entity.ai.DreadAITargetNonDread;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IDreadMob;
import com.iafenvoy.iceandfire.entity.util.IHasArmorVariant;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityDreadThrall
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
IHasArmorVariant {
    public static final Animation ANIMATION_SPAWN = Animation.create((int)40);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_HEAD = SynchedEntityData.m_135353_(EntityDreadThrall.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_CHEST = SynchedEntityData.m_135353_(EntityDreadThrall.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_LEGS = SynchedEntityData.m_135353_(EntityDreadThrall.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CUSTOM_ARMOR_FEET = SynchedEntityData.m_135353_(EntityDreadThrall.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CUSTOM_ARMOR_INDEX = SynchedEntityData.m_135353_(EntityDreadThrall.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int animationTick;
    private Animation currentAnimation;

    public EntityDreadThrall(EntityType<? extends EntityDreadThrall> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return EntityDreadThrall.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{IDreadMob.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (Predicate)((com.google.common.base.Predicate)DragonUtils::canHostilesTarget)));
        this.f_21346_.m_25352_(3, (Goal)new DreadAITargetNonDread((Mob)this, LivingEntity.class, false, (Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity))));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CUSTOM_ARMOR_INDEX, (Object)0);
        this.f_19804_.m_135372_(CUSTOM_ARMOR_HEAD, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CUSTOM_ARMOR_CHEST, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CUSTOM_ARMOR_LEGS, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CUSTOM_ARMOR_FEET, (Object)Boolean.FALSE);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30) {
            BlockState belowBlock = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            if (belowBlock.m_60734_() != Blocks.f_50016_) {
                for (int i = 0; i < 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, belowBlock), this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20191_().f_82289_, this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                }
            }
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.m_21205_().m_41720_() == Items.f_42411_) {
            this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42500_));
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        super.m_213945_(randomSource, difficulty);
        if (this.f_19796_.m_188501_() < 0.75f) {
            double chance = this.f_19796_.m_188501_();
            if (chance < (double)0.0025f) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IafItems.DRAGONSTEEL_ICE_SWORD.get()));
            }
            if (chance < (double)0.01f) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42388_));
            }
            if (chance < (double)0.1f) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            }
            if (chance < 0.75) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IafItems.DREAD_SWORD.get()));
            }
        }
        if (this.f_19796_.m_188501_() < 0.75f) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
            this.setCustomArmorHead(this.f_19796_.m_188503_(8) != 0);
        }
        if (this.f_19796_.m_188501_() < 0.75f) {
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
            this.setCustomArmorChest(this.f_19796_.m_188503_(8) != 0);
        }
        if (this.f_19796_.m_188501_() < 0.75f) {
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
            this.setCustomArmorLegs(this.f_19796_.m_188503_(8) != 0);
        }
        if (this.f_19796_.m_188501_() < 0.75f) {
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
            this.setCustomArmorFeet(this.f_19796_.m_188503_(8) != 0);
        }
        this.setBodyArmorVariant(this.f_19796_.m_188503_(8));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setAnimation(ANIMATION_SPAWN);
        this.m_213945_(worldIn.m_213780_(), difficultyIn);
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ArmorVariant", this.getBodyArmorVariant());
        compound.m_128379_("HasCustomHelmet", this.hasCustomArmorHead());
        compound.m_128379_("HasCustomChestplate", this.hasCustomArmorChest());
        compound.m_128379_("HasCustomLeggings", this.hasCustomArmorLegs());
        compound.m_128379_("HasCustomBoots", this.hasCustomArmorFeet());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBodyArmorVariant(compound.m_128451_("ArmorVariant"));
        this.setCustomArmorHead(compound.m_128471_("HasCustomHelmet"));
        this.setCustomArmorChest(compound.m_128471_("HasCustomChestplate"));
        this.setCustomArmorLegs(compound.m_128471_("HasCustomLeggings"));
        this.setCustomArmorFeet(compound.m_128471_("HasCustomBoots"));
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean hasCustomArmorHead() {
        return (Boolean)this.f_19804_.m_135370_(CUSTOM_ARMOR_HEAD);
    }

    public void setCustomArmorHead(boolean head) {
        this.f_19804_.m_135381_(CUSTOM_ARMOR_HEAD, (Object)head);
    }

    public boolean hasCustomArmorChest() {
        return (Boolean)this.f_19804_.m_135370_(CUSTOM_ARMOR_CHEST);
    }

    public void setCustomArmorChest(boolean head) {
        this.f_19804_.m_135381_(CUSTOM_ARMOR_CHEST, (Object)head);
    }

    public boolean hasCustomArmorLegs() {
        return (Boolean)this.f_19804_.m_135370_(CUSTOM_ARMOR_LEGS);
    }

    public void setCustomArmorLegs(boolean head) {
        this.f_19804_.m_135381_(CUSTOM_ARMOR_LEGS, (Object)head);
    }

    public boolean hasCustomArmorFeet() {
        return (Boolean)this.f_19804_.m_135370_(CUSTOM_ARMOR_FEET);
    }

    public void setCustomArmorFeet(boolean head) {
        this.f_19804_.m_135381_(CUSTOM_ARMOR_FEET, (Object)head);
    }

    @Override
    public int getBodyArmorVariant() {
        return (Integer)this.f_19804_.m_135370_(CUSTOM_ARMOR_INDEX);
    }

    @Override
    public void setBodyArmorVariant(int variant) {
        this.f_19804_.m_135381_(CUSTOM_ARMOR_INDEX, (Object)variant);
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12451_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12453_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12452_;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.m_5496_(SoundEvents.f_12454_, 0.15f, 1.0f);
    }
}

