/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonArmor;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDragonEgg;
import com.iafenvoy.iceandfire.entity.EntityDragonPart;
import com.iafenvoy.iceandfire.entity.EntityDreadQueen;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.ai.DragonAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.DragonAIEscort;
import com.iafenvoy.iceandfire.entity.ai.DragonAILookIdle;
import com.iafenvoy.iceandfire.entity.ai.DragonAIMate;
import com.iafenvoy.iceandfire.entity.ai.DragonAIReturnToRoost;
import com.iafenvoy.iceandfire.entity.ai.DragonAITarget;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItems;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetNonTamed;
import com.iafenvoy.iceandfire.entity.ai.DragonAIWander;
import com.iafenvoy.iceandfire.entity.ai.DragonAIWatchClosest;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeInput;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.EntityUtil;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.entity.util.IDropArmor;
import com.iafenvoy.iceandfire.entity.util.IFlyingMount;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IMultipartEntity;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.ReversedBuffer;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IDragonFlute;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonFlightManager;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonLogic;
import com.iafenvoy.iceandfire.item.ItemSummoningCrystal;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.render.model.IFChainBuffer;
import com.iafenvoy.iceandfire.render.model.util.LegSolverQuadruped;
import com.iafenvoy.iceandfire.screen.handler.DragonScreenHandler;
import com.iafenvoy.iceandfire.world.DragonPosWorldData;
import com.iafenvoy.uranus.ServerHelper;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.data.EntityPropertyDelegate;
import com.iafenvoy.uranus.network.PacketBufferUtils;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IPassabilityNavigator;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathingStuckHandler;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.iafenvoy.uranus.object.item.FoodUtils;
import dev.architectury.networking.NetworkManager;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class EntityDragonBase
extends TamableAnimal
implements MenuProvider,
IPassabilityNavigator,
ISyncMount,
IFlyingMount,
IMultipartEntity,
IAnimatedEntity,
IDragonFlute,
IDeadMob,
IVillagerFear,
IAnimalFear,
IDropArmor,
IHasCustomizableAttributes,
ICustomSizeNavigator,
ICustomMoveController,
ContainerListener {
    public static final int FLIGHT_CHANCE_PER_TICK = 1500;
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    protected static final EntityDataAccessor<Boolean> SWIMMING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE_TICKS = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FIREBREATHING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MODEL_DEAD = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DEATH_STAGE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> TACKLE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AGINGDISABLED = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DRAGON_PITCH = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> CRYSTAL_BOUND = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> CUSTOM_POSE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static Animation ANIMATION_FIRECHARGE;
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public static Animation ANIMATION_WINGBLAST;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_EPIC_ROAR;
    public static Animation ANIMATION_TAILWHACK;
    public final DragonType dragonType;
    public final double minimumDamage;
    public final double maximumDamage;
    public final double minimumHealth;
    public final double maximumHealth;
    public final double minimumSpeed;
    public final double maximumSpeed;
    public final double minimumArmor;
    public final double maximumArmor;
    public final float[] prevAnimationProgresses = new float[10];
    public final float[][] growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    public final LegSolverQuadruped legSolver;
    public final IafDragonLogic logic;
    public final IafDragonFlightManager flightManager;
    public final boolean allowLocalMotionControl = true;
    public final boolean allowMousePitchControl = true;
    public float sitProgress;
    public float sleepProgress;
    public float hoverProgress;
    public float flyProgress;
    public float fireBreathProgress;
    public float diveProgress;
    public float prevDiveProgress;
    public float prevFireBreathProgress;
    public int fireStopTicks;
    public int flyTicks;
    public float modelDeadProgress;
    public float prevModelDeadProgress;
    public float ridingProgress;
    public float tackleProgress;
    public boolean isSwimming;
    public float prevSwimProgress;
    public float swimProgress;
    public int ticksSwiming;
    public int swimCycle;
    public boolean isDaytime;
    public int flightCycle;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    public IFChainBuffer roll_buffer;
    public IFChainBuffer pitch_buffer;
    public IFChainBuffer pitch_buffer_body;
    public ReversedBuffer turn_buffer;
    public ChainBuffer tail_buffer;
    public int spacebarTicks;
    public int walkCycle;
    public BlockPos burningTarget;
    public int burnProgress;
    public double burnParticleX;
    public double burnParticleY;
    public double burnParticleZ;
    public float prevDragonPitch;
    public IafDragonAttacks.Air airAttack;
    public IafDragonAttacks.Ground groundAttack;
    public boolean usingGroundAttack = true;
    public int hoverTicks;
    public int tacklingTicks;
    public int ticksStill;
    public int navigatorType;
    public SimpleContainer dragonInventory;
    public boolean lookingForRoostAIFlag = false;
    public int flyHovering;
    public boolean hasHadHornUse = false;
    public int blockBreakCounter;
    public int fireBreathTicks;
    protected boolean gliding = false;
    protected float glidingSpeedBonus = 0.0f;
    protected float riderWalkingExtraY = 0.0f;
    private int prevFlightCycle;
    private boolean isModelDead;
    private int animationTick;
    private Animation currentAnimation;
    private float lastScale;
    private EntityDragonPart headPart;
    private EntityDragonPart neckPart;
    private EntityDragonPart rightWingUpperPart;
    private EntityDragonPart rightWingLowerPart;
    private EntityDragonPart leftWingUpperPart;
    private EntityDragonPart leftWingLowerPart;
    private EntityDragonPart tail1Part;
    private EntityDragonPart tail2Part;
    private EntityDragonPart tail3Part;
    private EntityDragonPart tail4Part;
    private boolean isOverAir;

    public EntityDragonBase(EntityType<? extends EntityDragonBase> t, Level world, DragonType type, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(t, world);
        this.dragonType = type;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.minimumArmor = 1.0;
        this.maximumArmor = 20.0;
        ANIMATION_EAT = Animation.create((int)20);
        this.createInventory();
        if (world.f_46443_) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.pitch_buffer_body = new IFChainBuffer();
            this.turn_buffer = new ReversedBuffer();
            this.tail_buffer = new ChainBuffer();
        }
        this.legSolver = new LegSolverQuadruped(0.3f, 0.35f, 0.2f, 1.45f, 1.0f);
        this.flightManager = new IafDragonFlightManager(this);
        this.logic = this.createDragonLogic();
        this.f_19811_ = true;
        this.switchNavigator(0);
        this.randomizeAttacks();
        this.lastScale = 0.0f;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, (double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue())).m_22268_(Attributes.f_22284_, 4.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.m_21051_(Attributes.f_22277_).m_22100_((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
    }

    public BlockPos m_21534_() {
        return this.homePos == null ? super.m_21534_() : this.homePos.getPosition();
    }

    public float m_21535_() {
        return ((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue();
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean m_21536_() {
        return this.hasHomePosition && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.m_9236_())) || super.m_21536_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new DragonAIMate(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new DragonAIReturnToRoost(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new DragonAIEscort(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DragonAIAttackMelee(this, 1.5, false));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(IafItemTags.TEMPT_DRAGON), false));
        this.f_21345_.m_25352_(7, (Goal)new DragonAIWander(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new DragonAIWatchClosest((PathfinderMob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new DragonAILookIdle(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new DragonAITargetItems(this, 60, false, false, true));
        this.f_21346_.m_25352_(5, new DragonAITargetNonTamed<LivingEntity>(this, LivingEntity.class, false, (Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_();
            }
            if (this.m_217043_().m_188503_(100) > this.getHunger()) {
                return entity.m_6095_() != this.m_6095_() && DragonUtils.canHostilesTarget((Entity)entity) && DragonUtils.isAlive(entity) && this.shouldTarget((Entity)entity);
            }
            return false;
        })));
        this.f_21346_.m_25352_(6, new DragonAITarget<LivingEntity>(this, LivingEntity.class, true, (Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> DragonUtils.canHostilesTarget((Entity)entity) && entity.m_6095_() != this.m_6095_() && this.shouldTarget((Entity)entity) && DragonUtils.isAlive(entity))));
        this.f_21346_.m_25352_(7, new DragonAITargetItems(this, false));
    }

    protected abstract boolean shouldTarget(Entity var1);

    public void updateScale(float scale) {
        if (this.headPart == null || this.headPart.m_213877_()) {
            this.headPart = new EntityDragonPart(this, 1.55f, 0.0f, 0.6f, 0.5f, 0.35f, 1.5f);
            this.m_9236_().m_7967_((Entity)this.headPart);
        }
        this.headPart.updateScale(scale);
        if (this.neckPart == null || this.neckPart.m_213877_()) {
            this.neckPart = new EntityDragonPart(this, 0.85f, 0.0f, 0.7f, 0.5f, 0.2f, 1.0f);
            this.m_9236_().m_7967_((Entity)this.neckPart);
        }
        this.neckPart.updateScale(scale);
        if (this.rightWingUpperPart == null || this.rightWingUpperPart.m_213877_()) {
            this.rightWingUpperPart = new EntityDragonPart(this, 1.0f, 90.0f, 0.5f, 0.85f, 0.3f, 0.5f);
            this.m_9236_().m_7967_((Entity)this.rightWingUpperPart);
        }
        this.rightWingUpperPart.updateScale(scale);
        if (this.rightWingLowerPart == null || this.rightWingLowerPart.m_213877_()) {
            this.rightWingLowerPart = new EntityDragonPart(this, 1.4f, 100.0f, 0.3f, 0.85f, 0.2f, 0.5f);
            this.m_9236_().m_7967_((Entity)this.rightWingLowerPart);
        }
        this.rightWingLowerPart.updateScale(scale);
        if (this.leftWingUpperPart == null || this.leftWingUpperPart.m_213877_()) {
            this.leftWingUpperPart = new EntityDragonPart(this, 1.0f, -90.0f, 0.5f, 0.85f, 0.3f, 0.5f);
            this.m_9236_().m_7967_((Entity)this.leftWingUpperPart);
        }
        this.leftWingUpperPart.updateScale(scale);
        if (this.leftWingLowerPart == null || this.leftWingLowerPart.m_213877_()) {
            this.leftWingLowerPart = new EntityDragonPart(this, 1.4f, -100.0f, 0.3f, 0.85f, 0.2f, 0.5f);
            this.m_9236_().m_7967_((Entity)this.leftWingLowerPart);
        }
        this.leftWingLowerPart.updateScale(scale);
        if (this.tail1Part == null || this.tail1Part.m_213877_()) {
            this.tail1Part = new EntityDragonPart(this, -0.75f, 0.0f, 0.6f, 0.35f, 0.35f, 1.0f);
            this.m_9236_().m_7967_((Entity)this.tail1Part);
        }
        this.tail1Part.updateScale(scale);
        if (this.tail2Part == null || this.tail2Part.m_213877_()) {
            this.tail2Part = new EntityDragonPart(this, -1.15f, 0.0f, 0.45f, 0.35f, 0.35f, 1.0f);
            this.m_9236_().m_7967_((Entity)this.tail2Part);
        }
        this.tail2Part.updateScale(scale);
        if (this.tail3Part == null || this.tail3Part.m_213877_()) {
            this.tail3Part = new EntityDragonPart(this, -1.5f, 0.0f, 0.35f, 0.35f, 0.35f, 1.0f);
            this.m_9236_().m_7967_((Entity)this.tail3Part);
        }
        this.tail3Part.updateScale(scale);
        if (this.tail4Part == null || this.tail4Part.m_213877_()) {
            this.tail4Part = new EntityDragonPart(this, -1.95f, 0.0f, 0.25f, 0.45f, 0.3f, 1.5f);
            this.m_9236_().m_7967_((Entity)this.tail4Part);
        }
        this.tail4Part.updateScale(scale);
    }

    public void removeParts() {
        if (this.headPart != null) {
            this.headPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.headPart = null;
        }
        if (this.neckPart != null) {
            this.neckPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.neckPart = null;
        }
        if (this.rightWingUpperPart != null) {
            this.rightWingUpperPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.rightWingUpperPart = null;
        }
        if (this.rightWingLowerPart != null) {
            this.rightWingLowerPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.rightWingLowerPart = null;
        }
        if (this.leftWingUpperPart != null) {
            this.leftWingUpperPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.leftWingUpperPart = null;
        }
        if (this.leftWingLowerPart != null) {
            this.leftWingLowerPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.leftWingLowerPart = null;
        }
        if (this.tail1Part != null) {
            this.tail1Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail1Part = null;
        }
        if (this.tail2Part != null) {
            this.tail2Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail2Part = null;
        }
        if (this.tail3Part != null) {
            this.tail3Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail3Part = null;
        }
        if (this.tail4Part != null) {
            this.tail4Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail4Part = null;
        }
    }

    public void updateParts() {
        if (this.m_213877_()) {
            return;
        }
        this.headPart.m_20359_((Entity)this);
        this.neckPart.m_20359_((Entity)this);
        this.rightWingUpperPart.m_20359_((Entity)this);
        this.rightWingLowerPart.m_20359_((Entity)this);
        this.leftWingUpperPart.m_20359_((Entity)this);
        this.leftWingLowerPart.m_20359_((Entity)this);
        this.tail1Part.m_20359_((Entity)this);
        this.tail2Part.m_20359_((Entity)this);
        this.tail3Part.m_20359_((Entity)this);
        this.tail4Part.m_20359_((Entity)this);
        EntityUtil.updatePart(this.headPart, (LivingEntity)this);
        EntityUtil.updatePart(this.neckPart, (LivingEntity)this);
        EntityUtil.updatePart(this.rightWingUpperPart, (LivingEntity)this);
        EntityUtil.updatePart(this.rightWingLowerPart, (LivingEntity)this);
        EntityUtil.updatePart(this.leftWingUpperPart, (LivingEntity)this);
        EntityUtil.updatePart(this.leftWingLowerPart, (LivingEntity)this);
        EntityUtil.updatePart(this.tail1Part, (LivingEntity)this);
        EntityUtil.updatePart(this.tail2Part, (LivingEntity)this);
        EntityUtil.updatePart(this.tail3Part, (LivingEntity)this);
        EntityUtil.updatePart(this.tail4Part, (LivingEntity)this);
    }

    public void updateBurnTarget() {
        if (!(this.burningTarget == null || this.m_5803_() || this.isModelDead() || this.m_6162_())) {
            BlockEntityDragonForgeInput forge;
            float maxDist = 115 * this.getDragonStage();
            BlockEntity blockEntity = this.m_9236_().m_7702_(this.burningTarget);
            if (blockEntity instanceof BlockEntityDragonForgeInput && (forge = (BlockEntityDragonForgeInput)blockEntity).isAssembled() && this.m_20275_((double)this.burningTarget.m_123341_() + 0.5, (double)this.burningTarget.m_123342_() + 0.5, (double)this.burningTarget.m_123343_() + 0.5) < (double)maxDist && this.canPositionBeSeen((double)this.burningTarget.m_123341_() + 0.5, (double)this.burningTarget.m_123342_() + 0.5, (double)this.burningTarget.m_123343_() + 0.5)) {
                this.m_21563_().m_24950_((double)this.burningTarget.m_123341_() + 0.5, (double)this.burningTarget.m_123342_() + 0.5, (double)this.burningTarget.m_123343_() + 0.5, 180.0f, 180.0f);
                this.breathFireAtPos(this.burningTarget);
                this.setBreathingFire(true);
            } else {
                if (!this.m_9236_().f_46443_) {
                    FriendlyByteBuf buf = PacketBufferUtils.create();
                    buf.writeInt(this.m_19879_()).writeBoolean(true);
                    buf.m_130064_(this.burningTarget);
                    ServerHelper.sendToAll((ResourceLocation)StaticVariables.DRAGON_SET_BURN_BLOCK, (FriendlyByteBuf)buf);
                }
                this.burningTarget = null;
            }
        }
    }

    protected abstract void breathFireAtPos(BlockPos var1);

    protected PathingStuckHandler createStuckHandler() {
        return PathingStuckHandler.createStuckHandler();
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.WALKING);
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type) {
        return this.createNavigator(worldIn, type, this.createStuckHandler());
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler) {
        return this.createNavigator(worldIn, type, stuckHandler, 4.0f);
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler, float width) {
        AdvancedPathNavigate newNavigator = new AdvancedPathNavigate((Mob)this, this.m_9236_(), type, width, 4.0f);
        this.f_21344_ = newNavigator;
        newNavigator.m_7008_(true);
        newNavigator.m_26575_().m_77355_(true);
        return newNavigator;
    }

    public void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.f_21342_ = new IafDragonFlightManager.GroundMoveHelper((Mob)this);
            this.f_21344_ = this.createNavigator(this.m_9236_(), AdvancedPathNavigate.MovementType.WALKING, this.createStuckHandler().withTeleportSteps(5));
            this.navigatorType = 0;
            this.setFlying(false);
            this.setHovering(false);
        } else if (navigatorType == 1) {
            this.f_21342_ = new IafDragonFlightManager.FlightMoveHelper(this);
            this.f_21344_ = this.createNavigator(this.m_9236_(), AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 1;
        } else {
            this.f_21342_ = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityDragonBase>(this);
            this.f_21344_ = this.createNavigator(this.m_9236_(), AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 2;
        }
    }

    public boolean m_7341_(Entity rider) {
        return true;
    }

    protected void m_8024_() {
        super.m_8024_();
        this.breakBlocks(false);
    }

    public void m_6043_() {
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.canDespawn.getValue()).booleanValue()) {
            super.m_6043_();
        }
    }

    public boolean canDestroyBlock(BlockPos pos, BlockState state) {
        return state.m_60734_().m_155943_() <= 100.0f;
    }

    @Override
    public boolean isMobDead() {
        return this.isModelDead();
    }

    public int m_8085_() {
        return 30 * this.getDragonStage() / 5;
    }

    public void openInventory(Player player) {
        player.m_5893_((MenuProvider)this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new DragonScreenHandler(syncId, (Container)this.dragonInventory, player.m_150109_(), new EntityPropertyDelegate(this.m_19879_()));
    }

    public int m_8100_() {
        return 90;
    }

    protected void m_6153_() {
        this.f_20919_ = 0;
        this.setModelDead(true);
        this.m_20153_();
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            for (int k = 0; k < 40; ++k) {
                double d2 = this.f_19796_.m_188583_() * 0.02;
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                if (!this.m_9236_().f_46443_) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d2, d0, d1);
            }
            this.spawnDeathParticles();
        }
    }

    protected void spawnDeathParticles() {
    }

    public void spawnBabyParticles() {
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.removeParts();
        super.m_142687_(reason);
    }

    public int m_213860_() {
        return switch (this.getDragonStage()) {
            case 2 -> 20;
            case 3 -> 150;
            case 4 -> 300;
            case 5 -> 650;
            default -> 5;
        };
    }

    public boolean m_21525_() {
        return this.isModelDead() || super.m_21525_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGER, (Object)0);
        this.f_19804_.m_135372_(AGE_TICKS, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)DragonColor.RED.name());
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(FIREBREATHING, (Object)false);
        this.f_19804_.m_135372_(HOVERING, (Object)false);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(DEATH_STAGE, (Object)0);
        this.f_19804_.m_135372_(MODEL_DEAD, (Object)false);
        this.f_19804_.m_135372_(CONTROL_STATE, (Object)0);
        this.f_19804_.m_135372_(TACKLE, (Object)false);
        this.f_19804_.m_135372_(AGINGDISABLED, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(DRAGON_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CRYSTAL_BOUND, (Object)false);
        this.f_19804_.m_135372_(CUSTOM_POSE, (Object)"");
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean m_5912_() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean isStriking() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean isDismounting() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 4 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
        this.setStateField(1, down);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
        if (newState) {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.f_19804_.m_135381_(CONTROL_STATE, (Object)state);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
        this.m_21839_(command == 1);
    }

    public float getDragonPitch() {
        return ((Float)this.f_19804_.m_135370_(DRAGON_PITCH)).floatValue();
    }

    public void setDragonPitch(float pitch) {
        this.f_19804_.m_135381_(DRAGON_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementDragonPitch(float pitch) {
        this.f_19804_.m_135381_(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() + pitch));
    }

    public void decrementDragonPitch(float pitch) {
        this.f_19804_.m_135381_(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() - pitch));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Hunger", this.getHunger());
        compound.m_128405_("AgeTicks", this.getAgeInTicks());
        compound.m_128379_("Gender", this.isMale());
        compound.m_128359_("Variant", this.getVariant());
        compound.m_128379_("Sleeping", this.m_5803_());
        compound.m_128379_("TamedDragon", this.m_21824_());
        compound.m_128379_("FireBreathing", this.isBreathingFire());
        compound.m_128379_("AttackDecision", this.usingGroundAttack);
        compound.m_128379_("Hovering", this.isHovering());
        compound.m_128379_("Flying", this.isFlying());
        compound.m_128405_("DeathStage", this.getDeathStage());
        compound.m_128379_("ModelDead", this.isModelDead());
        compound.m_128350_("DeadProg", this.modelDeadProgress);
        compound.m_128379_("Tackle", this.isTackling());
        compound.m_128379_("HasHomePosition", this.hasHomePosition);
        compound.m_128359_("CustomPose", this.getCustomPose());
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(compound);
        }
        compound.m_128379_("AgingDisabled", this.isAgingDisabled());
        compound.m_128405_("Command", this.getCommand());
        if (this.dragonInventory != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.dragonInventory.m_6643_(); ++i) {
                ItemStack itemstack = this.dragonInventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(CompoundNBT);
                nbttaglist.add((Object)CompoundNBT);
            }
            compound.m_128365_("Items", (Tag)nbttaglist);
        }
        compound.m_128379_("CrystalBound", this.isBoundToCrystal());
        if (this.m_8077_()) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
        this.removeParts();
        this.lastScale = 0.0f;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHunger(compound.m_128451_("Hunger"));
        this.setAgeInTicks(compound.m_128451_("AgeTicks"));
        this.setGender(compound.m_128471_("Gender"));
        if (compound.m_128441_("Variant") && compound.m_128423_("Variant").m_7060_() == 8) {
            this.setVariant(compound.m_128461_("Variant"));
        } else {
            List<DragonColor> colors = DragonColor.getColorsByType(this.dragonType);
            this.setVariant(colors.get(compound.m_128451_("Variant")).name());
        }
        this.m_21837_(compound.m_128471_("Sleeping"));
        this.m_7105_(compound.m_128471_("TamedDragon"));
        this.setBreathingFire(compound.m_128471_("FireBreathing"));
        this.usingGroundAttack = compound.m_128471_("AttackDecision");
        this.setHovering(compound.m_128471_("Hovering"));
        this.setFlying(compound.m_128471_("Flying"));
        this.setDeathStage(compound.m_128451_("DeathStage"));
        this.setModelDead(compound.m_128471_("ModelDead"));
        this.modelDeadProgress = compound.m_128457_("DeadProg");
        this.setCustomPose(compound.m_128461_("CustomPose"));
        this.hasHomePosition = compound.m_128471_("HasHomePosition");
        if (this.hasHomePosition && compound.m_128451_("HomeAreaX") != 0 && compound.m_128451_("HomeAreaY") != 0 && compound.m_128451_("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(compound, this.m_9236_());
        }
        this.setTackling(compound.m_128471_("Tackle"));
        this.setAgingDisabled(compound.m_128471_("AgingDisabled"));
        this.setCommand(compound.m_128451_("Command"));
        if (this.dragonInventory != null) {
            nbttaglist = compound.m_128437_("Items", 10);
            this.createInventory();
            for (Tag inbt : nbttaglist) {
                CompoundTag CompoundNBT = (CompoundTag)inbt;
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                if (j > 4) continue;
                this.dragonInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        } else {
            nbttaglist = compound.m_128437_("Items", 10);
            this.createInventory();
            for (Tag inbt : nbttaglist) {
                CompoundTag CompoundNBT = (CompoundTag)inbt;
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.dragonInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        }
        this.setCrystalBound(compound.m_128471_("CrystalBound"));
        if (compound.m_128425_("CustomName", 8) && !compound.m_128461_("CustomName").startsWith("TextComponent")) {
            this.m_6593_((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
        this.setConfigurableAttributes();
        this.updateAttributes();
    }

    public int getContainerSize() {
        return 5;
    }

    protected void createInventory() {
        SimpleContainer tempInventory = this.dragonInventory;
        this.dragonInventory = new SimpleContainer(this.getContainerSize());
        if (tempInventory != null) {
            tempInventory.m_19181_((ContainerListener)this);
            int i = Math.min(tempInventory.m_6643_(), this.dragonInventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = tempInventory.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.dragonInventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.dragonInventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.m_9236_().f_46443_) {
            this.updateAttributes();
        }
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.dragonInventory != pInventory;
    }

    public LivingEntity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            if (this.m_5448_() == passenger || !this.m_21824_() || this.m_21805_() == null || !this.m_21805_().equals(player.m_20148_())) continue;
            return player;
        }
        return null;
    }

    @Override
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    public void updateAttributes() {
        double age = Math.min(this.getAgeInDays(), 125);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
        double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        this.m_21051_(Attributes.f_22276_).m_22100_((double)Math.round(this.minimumHealth + healthStep * age));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)Math.round(this.minimumDamage + attackStep * age));
        this.m_21051_(Attributes.f_22279_).m_22100_(this.minimumSpeed + speedStep * age);
        double baseValue = this.minimumArmor + armorStep * (double)this.getAgeInDays();
        this.m_21051_(Attributes.f_22284_).m_22100_(baseValue);
        if (!this.m_9236_().f_46443_) {
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            this.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Dragon armor bonus", this.calculateArmorModifier(), AttributeModifier.Operation.ADDITION));
        }
        this.m_21051_(Attributes.f_22277_).m_22100_((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(HUNGER);
    }

    public void setHunger(int hunger) {
        this.f_19804_.m_135381_(HUNGER, (Object)Mth.m_14045_((int)hunger, (int)0, (int)100));
    }

    public String getVariant() {
        return (String)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(String variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(AGE_TICKS) / 24000), (int)0, (int)(this.m_21824_() ? (Integer)IafCommonConfig.INSTANCE.dragon.maxTamedDragonAge.getValue() : 128));
    }

    public void setAgeInDays(int age) {
        this.f_19804_.m_135381_(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.f_19804_.m_135370_(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.f_19804_.m_135381_(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.f_19804_.m_135381_(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(GENDER);
    }

    public boolean isModelDead() {
        if (this.m_9236_().f_46443_) {
            this.isModelDead = (Boolean)this.f_19804_.m_135370_(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public void setModelDead(boolean modeldead) {
        this.f_19804_.m_135381_(MODEL_DEAD, (Object)modeldead);
        if (!this.m_9236_().f_46443_) {
            this.isModelDead = modeldead;
        }
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(HOVERING);
    }

    public void setHovering(boolean hovering) {
        this.f_19804_.m_135381_(HOVERING, (Object)hovering);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean useFlyingPathFinder() {
        return this.isFlying() && this.m_6688_() == null;
    }

    public void setGender(boolean male) {
        this.f_19804_.m_135381_(GENDER, (Object)male);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public boolean isBlinking() {
        return this.f_19797_ % 50 > 43;
    }

    public boolean isBreathingFire() {
        return (Boolean)this.f_19804_.m_135370_(FIREBREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        this.f_19804_.m_135381_(FIREBREATHING, (Object)breathing);
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < 2;
    }

    public boolean m_21827_() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
    }

    public void m_21839_(boolean sitting) {
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        if (sitting) {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 | 1)));
            this.m_21573_().m_26573_();
        } else {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void m_21837_(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.m_21573_().m_26573_();
        }
    }

    public String getCustomPose() {
        return (String)this.f_19804_.m_135370_(CUSTOM_POSE);
    }

    public void setCustomPose(String customPose) {
        this.f_19804_.m_135381_(CUSTOM_POSE, (Object)customPose);
        this.modelDeadProgress = 20.0f;
    }

    public void riderShootFire(Entity controller) {
    }

    private double calculateArmorModifier() {
        EquipmentSlot[] slots;
        double val = 1.0;
        block7: for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            switch (DragonArmor.getArmorOrdinal(this.m_6844_(slot))) {
                case 1: {
                    val += 2.0;
                    continue block7;
                }
                case 2: 
                case 4: {
                    val += 3.0;
                    continue block7;
                }
                case 3: {
                    val += 5.0;
                    continue block7;
                }
                case 5: 
                case 6: 
                case 8: {
                    val += 10.0;
                    continue block7;
                }
                case 7: {
                    val += 1.5;
                }
            }
        }
        return val;
    }

    public boolean canMove() {
        return !this.m_21827_() && !this.m_5803_() && this.m_6688_() == null && !this.m_20159_() && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    public boolean isFuelingForge() {
        return this.burningTarget != null && this.m_9236_().m_7702_(this.burningTarget) instanceof BlockEntityDragonForgeInput;
    }

    public boolean m_6084_() {
        if (this.isModelDead()) {
            return !this.m_213877_();
        }
        return super.m_6084_();
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == IafItems.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        int lastDeathStage = Math.min(this.getAgeInDays() / 5, 25);
        if (stack == ItemStack.f_41583_) {
            stack = player.m_21120_(hand);
        }
        if (stack.m_41720_() == IafItems.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return InteractionResult.SUCCESS;
        }
        if (!this.isModelDead()) {
            if (stack.m_41720_() == IafItems.CREATIVE_DRAGON_MEAL.get()) {
                this.m_7105_(true);
                this.m_21828_(player);
                this.setHunger(this.getHunger() + 20);
                this.m_5634_(Math.min(this.m_21223_(), (float)((int)(this.m_21233_() / 2.0f))));
                this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
                this.spawnItemCrackParticles(stack.m_41720_());
                this.spawnItemCrackParticles(Items.f_42500_);
                this.spawnItemCrackParticles(Items.f_42499_);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(stack) && this.m_6125_()) {
                this.m_146762_(0);
                this.m_142075_(player, InteractionHand.MAIN_HAND, stack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (this.m_21830_((LivingEntity)player)) {
                if (stack.m_41720_() == this.dragonType.getCrystalItem() && !ItemSummoningCrystal.hasDragon(stack)) {
                    this.setCrystalBound(true);
                    CompoundTag compound = stack.m_41784_();
                    CompoundTag dragonTag = new CompoundTag();
                    dragonTag.m_128362_("DragonUUID", this.m_20148_());
                    if (this.m_7770_() != null) {
                        dragonTag.m_128359_("CustomName", this.m_7770_().getString());
                    }
                    compound.m_128365_("Dragon", (Tag)dragonTag);
                    this.m_5496_(SoundEvents.f_11771_, 1.0f, 1.0f);
                    player.m_6674_(hand);
                    return InteractionResult.SUCCESS;
                }
                this.m_21828_(player);
                if (stack.m_41720_() == IafItems.DRAGON_HORN.get()) {
                    return super.m_6071_(player, hand);
                }
                if (stack.m_41619_() && !player.m_6144_()) {
                    if (!this.m_9236_().f_46443_) {
                        int dragonStage = this.getDragonStage();
                        if (dragonStage < 2) {
                            if (player.m_20197_().size() >= 3) {
                                return InteractionResult.FAIL;
                            }
                            this.m_7998_((Entity)player, true);
                            FriendlyByteBuf buf = PacketBufferUtils.create();
                            buf.writeInt(this.m_19879_()).writeBoolean(true).writeBoolean(true);
                            ServerHelper.sendToAll((ResourceLocation)StaticVariables.START_RIDING_MOB_S2C, (FriendlyByteBuf)buf);
                        } else if (dragonStage > 2 && !player.m_20159_()) {
                            player.m_20260_(false);
                            player.m_7998_((Entity)this, true);
                            FriendlyByteBuf buf = PacketBufferUtils.create();
                            buf.writeInt(this.m_19879_()).writeBoolean(true).writeBoolean(false);
                            ServerHelper.sendToAll((ResourceLocation)StaticVariables.START_RIDING_MOB_S2C, (FriendlyByteBuf)buf);
                            this.m_21837_(false);
                        }
                        this.m_21573_().m_26573_();
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stack.m_41619_() && player.m_6144_()) {
                    this.openInventory(player);
                    return InteractionResult.SUCCESS;
                }
                int itemFoodAmount = FoodUtils.getFoodPoints((ItemStack)stack, (boolean)true, (boolean)this.dragonType.isPiscivore());
                if (itemFoodAmount > 0 && (this.getHunger() < 100 || this.m_21223_() < this.m_21233_())) {
                    this.setHunger(this.getHunger() + itemFoodAmount);
                    this.m_21153_(Math.min(this.m_21233_(), (float)((int)(this.m_21223_() + (float)itemFoodAmount / 10.0f))));
                    this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
                    this.spawnItemCrackParticles(stack.m_41720_());
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                Item stackItem = stack.m_41720_();
                if (stackItem == IafItems.DRAGON_MEAL.get() && this.getAgeInDays() < (this.m_21824_() ? (Integer)IafCommonConfig.INSTANCE.dragon.maxTamedDragonAge.getValue() : 128)) {
                    this.growDragon(1);
                    this.setHunger(this.getHunger() + 20);
                    this.m_5634_(Math.min(this.m_21223_(), (float)((int)(this.m_21233_() / 2.0f))));
                    this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.f_42500_);
                    this.spawnItemCrackParticles(Items.f_42499_);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stackItem == IafItems.SICKLY_DRAGON_MEAL.get() && !this.isAgingDisabled()) {
                    this.setHunger(this.getHunger() + 20);
                    this.m_5634_(this.m_21233_());
                    this.m_5496_(SoundEvents.f_12644_, this.m_6121_(), this.m_6100_());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.f_42500_);
                    this.spawnItemCrackParticles(Items.f_42499_);
                    this.spawnItemCrackParticles(Items.f_42675_);
                    this.spawnItemCrackParticles(Items.f_42675_);
                    this.setAgingDisabled(true);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stackItem == IafItems.DRAGON_STAFF.get()) {
                    if (player.m_6144_()) {
                        if (this.hasHomePosition) {
                            this.hasHomePosition = false;
                            player.m_5661_((Component)Component.m_237115_((String)"dragon.command.remove_home"), true);
                        } else {
                            BlockPos pos = this.m_20183_();
                            this.homePos = new HomePosition(pos, this.m_9236_());
                            this.hasHomePosition = true;
                            player.m_5661_((Component)Component.m_237110_((String)"dragon.command.new_home", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.homePos.getDimension()}), true);
                        }
                    } else {
                        this.m_5496_(SoundEvents.f_12609_, this.m_6121_(), this.m_6100_());
                        if (!this.m_9236_().f_46443_) {
                            this.setCommand(this.getCommand() + 1);
                            if (this.getCommand() > 2) {
                                this.setCommand(0);
                            }
                        }
                        String commandText = "stand";
                        if (this.getCommand() == 1) {
                            commandText = "sit";
                        } else if (this.getCommand() == 2) {
                            commandText = "escort";
                        }
                        player.m_5661_((Component)Component.m_237115_((String)("dragon.command." + commandText)), true);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            if (this.getDeathStage() < lastDeathStage && player.m_36326_()) {
                if (!this.m_9236_().f_46443_ && !stack.m_41619_() && stack.m_41720_() != null && stack.m_41720_() == Items.f_42590_ && this.getDeathStage() < lastDeathStage / 2 && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootBlood.getValue()).booleanValue()) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    this.setDeathStage(this.getDeathStage() + 1);
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)this.getBloodItem(), 1));
                    return InteractionResult.SUCCESS;
                }
                if (!this.m_9236_().f_46443_ && stack.m_41619_() && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootSkull.getValue()).booleanValue()) {
                    if (this.getDeathStage() >= lastDeathStage - 1) {
                        ItemStack skull = this.getSkull().m_41777_();
                        skull.m_41751_(new CompoundTag());
                        assert (skull.m_41783_() != null);
                        skull.m_41783_().m_128405_("Stage", this.getDragonStage());
                        skull.m_41783_().m_128405_("DragonType", 0);
                        skull.m_41783_().m_128405_("DragonAge", this.getAgeInDays());
                        this.setDeathStage(this.getDeathStage() + 1);
                        if (!this.m_9236_().f_46443_) {
                            this.m_5552_(skull, 1.0f);
                        }
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                    } else if (this.getDeathStage() == lastDeathStage / 2 - 1 && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootHeart.getValue()).booleanValue()) {
                        ItemStack heart = new ItemStack(this.getHeartItem(), 1);
                        List<DragonColor> colors = DragonColor.getColorsByType(this.dragonType);
                        ItemStack egg = new ItemStack((ItemLike)colors.get(this.f_19796_.m_188503_(colors.size())).getEggItem(), 1);
                        if (!this.m_9236_().f_46443_) {
                            this.m_5552_(heart, 1.0f);
                            if (!this.isMale() && this.getDragonStage() > 3) {
                                this.m_5552_(egg, 1.0f);
                            }
                        }
                        this.setDeathStage(this.getDeathStage() + 1);
                    } else {
                        this.setDeathStage(this.getDeathStage() + 1);
                        ItemStack drop = this.getRandomDrop();
                        if (!drop.m_41619_() && !this.m_9236_().f_46443_) {
                            this.m_5552_(drop, 1.0f);
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(player, hand);
        }
        return InteractionResult.PASS;
    }

    public abstract ItemLike getHeartItem();

    public abstract Item getBloodItem();

    public abstract Item getFleshItem();

    public ItemStack getSkull() {
        return ItemStack.f_41583_;
    }

    private ItemStack getRandomDrop() {
        ItemStack stack = this.getItemFromLootTable();
        if (stack.m_41720_() == IafItems.DRAGON_BONE.get()) {
            this.m_5496_(SoundEvents.f_12423_, 1.0f, 1.0f);
        } else {
            this.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
        }
        return stack;
    }

    public boolean canPositionBeSeen(double x, double y, double z) {
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_()), new Vec3(x, y, z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double dist = result.m_82450_().m_82531_(x, y, z);
        return dist <= 1.0 || result.m_6662_() == HitResult.Type.MISS;
    }

    public abstract ResourceLocation getDeadLootTable();

    public ItemStack getItemFromLootTable() {
        LootParams.Builder lootparams$builder;
        LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.getDeadLootTable());
        ObjectListIterator objectListIterator = loottable.m_287195_((lootparams$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)this.m_9236_().m_269111_().m_269264_())).m_287235_(LootContextParamSets.f_81415_)).iterator();
        if (objectListIterator.hasNext()) {
            ItemStack itemstack = (ItemStack)objectListIterator.next();
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public void growDragon(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.m_20011_(this.m_20191_());
        if (this.m_9236_().f_46443_ && this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                float f = (float)((double)this.m_217043_().m_188501_() * (this.m_20191_().f_82291_ - this.m_20191_().f_82288_) + this.m_20191_().f_82288_);
                float f1 = (float)((double)this.m_217043_().m_188501_() * (this.m_20191_().f_82292_ - this.m_20191_().f_82289_) + this.m_20191_().f_82289_);
                float f2 = (float)((double)this.m_217043_().m_188501_() * (this.m_20191_().f_82293_ - this.m_20191_().f_82290_) + this.m_20191_().f_82290_);
                double motionX = this.m_217043_().m_188583_() * 0.07;
                double motionY = this.m_217043_().m_188583_() * 0.07;
                double motionZ = this.m_217043_().m_188583_() * 0.07;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ);
                ++i;
            }
        }
        if (this.getDragonStage() >= 2) {
            this.m_6038_();
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.m_217043_().m_188583_() * 0.07;
            double motionY = this.m_217043_().m_188583_() * 0.07;
            double motionZ = this.m_217043_().m_188583_() * 0.07;
            Vec3 headVec = this.getHeadPosition();
            if (!this.m_9236_().f_46443_) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)item)), headVec.f_82479_, headVec.f_82480_, headVec.f_82481_, 1, motionX, motionY, motionZ, 0.1);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)item)), headVec.f_82479_, headVec.f_82480_, headVec.f_82481_, motionX, motionY, motionZ);
        }
    }

    public boolean isTimeToWake() {
        return this.m_9236_().m_46461_() || this.getCommand() == 2;
    }

    private boolean isStuck() {
        boolean checkNavigation;
        boolean skip;
        boolean bl = skip = this.isChained() || this.m_21824_();
        if (skip) {
            return false;
        }
        boolean bl2 = checkNavigation = this.ticksStill > 80 && this.canMove() && !this.isHovering();
        if (checkNavigation) {
            PathNavigation navigation = this.m_21573_();
            Path path = navigation.m_26570_();
            return !navigation.m_26571_() && (path == null || path.m_77395_() != null || this.m_20183_().m_123331_((Vec3i)path.m_77395_().m_77288_()) > 15.0);
        }
        return false;
    }

    public boolean isOverAir() {
        return this.isOverAir;
    }

    private boolean isOverAirLogic() {
        return this.m_9236_().m_46859_(BlockPos.m_274561_((double)this.m_146903_(), (double)(this.m_20191_().f_82289_ - 1.0), (double)this.m_146907_()));
    }

    public boolean isDiving() {
        return false;
    }

    public boolean isBeyondHeight() {
        if (this.m_20186_() > (double)this.m_9236_().m_151558_()) {
            return true;
        }
        return this.m_20186_() > (double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue();
    }

    private int calculateDownY() {
        if (this.m_21573_().m_26570_() != null) {
            Path path = this.m_21573_().m_26570_();
            Vec3 p = path.m_77382_((Entity)this, Math.min(path.m_77398_() - 1, path.m_77399_() + 1));
            if (p.f_82480_ < this.m_20186_() - 1.0) {
                return -1;
            }
        }
        return 1;
    }

    public void breakBlock(BlockPos position) {
        float hardness;
        if (((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((LivingEntity)this, position.m_123341_(), position.m_123342_(), position.m_123343_())) {
            return;
        }
        BlockState state = this.m_9236_().m_8055_(position);
        float f = hardness = (Boolean)IafCommonConfig.INSTANCE.dragon.griefing.getValue() != false || this.getDragonStage() <= 3 ? 2.0f : 5.0f;
        if (this.isBreakable(position, state, hardness, this)) {
            this.m_20256_(this.m_20184_().m_82542_((double)0.6f, 1.0, (double)0.6f));
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_46961_(position, !state.m_204336_(IafBlockTags.DRAGON_BLOCK_BREAK_NO_DROPS) && (double)this.f_19796_.m_188501_() <= (Double)IafCommonConfig.INSTANCE.dragon.blockBreakingDropChance.getValue());
            }
        }
    }

    public void breakBlocks(boolean force) {
        boolean doBreak = force;
        if (this.blockBreakCounter > 0 || (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue() == 0) {
            --this.blockBreakCounter;
            if (this.blockBreakCounter == 0 || (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue() == 0) {
                doBreak = true;
            }
        }
        if (doBreak && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && DragonUtils.canGrief(this) && !this.isModelDead() && this.getDragonStage() >= 3 && (this.canMove() || this.m_6688_() != null)) {
            boolean bounds = true;
            int flightModifier = this.isFlying() && this.m_5448_() != null ? -1 : 1;
            int yMinus = this.calculateDownY();
            BlockPos.m_121886_((int)((int)Math.floor(this.m_20191_().f_82288_) - 1), (int)((int)Math.floor(this.m_20191_().f_82289_) + yMinus), (int)((int)Math.floor(this.m_20191_().f_82290_) - 1), (int)((int)Math.floor(this.m_20191_().f_82291_) + 1), (int)((int)Math.floor(this.m_20191_().f_82292_) + 1 + flightModifier), (int)((int)Math.floor(this.m_20191_().f_82293_) + 1)).forEach(this::breakBlock);
        }
    }

    protected boolean isBreakable(BlockPos pos, BlockState state, float hardness, EntityDragonBase entity) {
        return state.m_280555_() && !state.m_60795_() && state.m_60819_().m_76178_() && !state.m_60808_((BlockGetter)this.m_9236_(), pos).m_83281_() && state.m_60800_((BlockGetter)this.m_9236_(), pos) >= 0.0f && state.m_60800_((BlockGetter)this.m_9236_(), pos) <= hardness && DragonUtils.canDragonBreak(state, (Entity)entity) && this.canDestroyBlock(pos, state);
    }

    public void spawnGroundEffects() {
        if (this.m_9236_().f_46443_) {
            int i = 0;
            while ((float)i < this.getRenderSize()) {
                for (int i1 = 0; i1 < 20; ++i1) {
                    float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                    float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1 * 1.0f;
                    double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                    double extraY = 0.8f;
                    double extraZ = radius * Mth.m_14089_((float)angle);
                    BlockPos ground = this.getGround(BlockPos.m_274561_((double)(this.m_20185_() + extraX), (double)(this.m_20186_() + (double)0.8f - 1.0), (double)(this.m_20189_() + extraZ)));
                    BlockState BlockState2 = this.m_9236_().m_8055_(ground);
                    if (!BlockState2.m_60795_()) continue;
                    double motionX = this.m_217043_().m_188583_() * 0.07;
                    double motionY = this.m_217043_().m_188583_() * 0.07;
                    double motionZ = this.m_217043_().m_188583_() * 0.07;
                    this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, BlockState2), true, this.m_20185_() + extraX, (double)ground.m_123342_() + (double)0.8f, this.m_20189_() + extraZ, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }

    private BlockPos getGround(BlockPos blockPos) {
        while (this.m_9236_().m_46859_(blockPos) && blockPos.m_123342_() > 1) {
            blockPos = blockPos.m_7495_();
        }
        return blockPos;
    }

    public boolean isActuallyBreathingFire() {
        return this.fireBreathTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 6000 || this.isGoingDown() || this.flyTicks > 40 && this.flyProgress == 0.0f || this.isChained() && this.flyTicks > 100;
    }

    public abstract String getVariantName(int var1);

    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (this.m_20363_(passenger)) {
            if (this.m_6688_() == null || !this.m_6688_().m_20148_().equals(passenger.m_20148_())) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.m_8127_();
                }
                this.m_146922_(passenger.m_146908_());
                this.m_5616_(passenger.m_6080_());
                this.m_146926_(passenger.m_146909_());
                Vec3 riderPos = this.getRiderPosition();
                passenger.m_6034_(riderPos.f_82479_, riderPos.f_82480_ + (double)passenger.m_20206_(), riderPos.f_82481_);
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        double a = Mth.m_14031_((float)(f * speed)) * f1 * degree;
        float bob = (float)(a - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(a));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    protected void updatePreyInMouth(Entity prey) {
        if (this.getAnimation() != ANIMATION_SHAKEPREY) {
            this.setAnimation(ANIMATION_SHAKEPREY);
        }
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null) {
            float baseDamage = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
            float damage = baseDamage * 2.0f;
            boolean didDamage = prey.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), damage);
            if (didDamage && ((Boolean)IafCommonConfig.INSTANCE.dragon.canHealFromBiting.getValue()).booleanValue()) {
                this.m_5634_(damage * 0.5f);
            }
            if (!(prey instanceof Player)) {
                this.setHunger(this.getHunger() + 1);
            }
            prey.m_8127_();
        } else {
            double extraY;
            this.f_20883_ = this.m_146908_();
            float modTick_0 = this.getAnimationTick() - 25;
            float modTick_1 = this.getAnimationTick() > 25 && this.getAnimationTick() < 55 ? 8.0f * Mth.m_14036_((float)Mth.m_14031_((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
            float modTick_2 = this.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, this.getAnimationTick() - 20);
            float radius = 0.75f * (0.6f * this.getRenderSize() / 3.0f) * -3.0f;
            float angle = (float)Math.PI / 180 * this.f_20883_ + 3.15f + modTick_1 * 2.0f * 0.015f;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double d = extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(this.getRenderSize() / 3.0f));
            assert (prey != null);
            prey.m_6034_(this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ);
        }
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() == 3;
    }

    public boolean m_6125_() {
        return this.getDragonStage() >= 4;
    }

    public boolean m_6162_() {
        return this.getDragonStage() < 2;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setGender(this.m_217043_().m_188499_());
        int age = this.m_217043_().m_188503_(80) + 1;
        this.growDragon(age);
        List<DragonColor> colors = DragonColor.getColorsByType(this.dragonType);
        this.setVariant(colors.get(new Random().nextInt(colors.size())).name());
        this.m_21837_(false);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.m_5634_(Math.round(this.minimumHealth + healthStep * (double)age));
        this.usingGroundAttack = true;
        this.setHunger(50);
        return spawnDataIn;
    }

    public boolean m_6469_(DamageSource dmg, float i) {
        if (this.isModelDead() && dmg != this.m_9236_().m_269111_().m_269341_()) {
            return false;
        }
        if (this.m_20160_() && dmg.m_7639_() != null && this.m_6688_() != null && dmg.m_7639_() == this.m_6688_()) {
            return false;
        }
        if ((dmg.m_269415_().f_268677_().contains("arrow") || this.m_20202_() != null && dmg.m_7639_() != null && dmg.m_7639_().m_7306_(this.m_20202_())) && this.m_20159_()) {
            return false;
        }
        if (dmg.m_276093_(DamageTypes.f_268612_) || dmg.m_276093_(DamageTypes.f_268659_) || dmg.m_276093_(DamageTypes.f_268613_)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && dmg.m_7639_() != null && this.m_217043_().m_188503_(4) == 0) {
            this.roar();
        }
        if (i > 0.0f && this.m_5803_()) {
            this.m_21837_(false);
            if (!this.m_21824_() && dmg.m_7639_() instanceof Player) {
                this.m_6710_((LivingEntity)((Player)dmg.m_7639_()));
            }
        }
        return super.m_6469_(dmg, i);
    }

    public void m_6210_() {
        super.m_6210_();
        float scale = Math.min(this.getRenderSize() * 0.35f, 7.0f);
        if (scale != this.lastScale) {
            this.updateScale(this.getRenderSize() / 3.0f);
        }
        this.lastScale = scale;
    }

    public float m_274421_() {
        return Math.max(1.2f, 1.2f + (float)(Math.min(this.getAgeInDays(), 125) - 25) * 1.8f / 100.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        this.updateParts();
        this.prevDragonPitch = this.getDragonPitch();
        this.m_9236_().m_46473_().m_6180_("dragonLogic");
        this.m_274367_(this.m_274421_());
        this.isOverAir = this.isOverAirLogic();
        this.logic.updateDragonCommon();
        if (this.isModelDead()) {
            if (!this.m_9236_().f_46443_ && this.m_9236_().m_46859_(BlockPos.m_274561_((double)this.m_146903_(), (double)this.m_20191_().f_82289_, (double)this.m_146907_())) && this.m_20186_() > -1.0) {
                this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)-0.2f, 0.0));
            }
            this.setBreathingFire(false);
            float dragonPitch = this.getDragonPitch();
            if (dragonPitch > 0.0f) {
                dragonPitch = Math.min(0.0f, dragonPitch - 5.0f);
                this.setDragonPitch(dragonPitch);
            }
            if (dragonPitch < 0.0f) {
                this.setDragonPitch(Math.max(0.0f, dragonPitch + 5.0f));
            }
        } else if (this.m_9236_().f_46443_) {
            this.logic.updateDragonClient();
        } else {
            this.logic.updateDragonServer();
            this.logic.updateDragonAttack();
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("dragonFlight");
        if (this.useFlyingPathFinder() && !this.m_9236_().f_46443_) {
            this.flightManager.update();
        }
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_7238_();
        if (!this.m_9236_().m_5776_() && ((Boolean)IafCommonConfig.INSTANCE.dragon.digWhenStuck.getValue()).booleanValue() && this.isStuck()) {
            this.breakBlocks(true);
            this.resetStuck();
        }
    }

    private void resetStuck() {
        this.ticksStill = 0;
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevModelDeadProgress = this.modelDeadProgress;
        this.prevDiveProgress = this.diveProgress;
        this.prevAnimationProgresses[0] = this.sitProgress;
        this.prevAnimationProgresses[1] = this.sleepProgress;
        this.prevAnimationProgresses[2] = this.hoverProgress;
        this.prevAnimationProgresses[3] = this.flyProgress;
        this.prevAnimationProgresses[4] = this.fireBreathProgress;
        this.prevAnimationProgresses[5] = this.ridingProgress;
        this.prevAnimationProgresses[6] = this.tackleProgress;
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_6710_(null);
        }
        if (this.isModelDead()) {
            if (this.m_20160_()) {
                this.m_20153_();
            }
            this.setHovering(false);
            this.setFlying(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.animationTick > this.getAnimation().getDuration() && !this.m_9236_().f_46443_) {
            this.animationTick = 0;
        }
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    public float m_6134_() {
        return Math.min(this.getRenderSize() * 0.35f, 7.0f);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public float getRenderSize() {
        int stage = this.getDragonStage() - 1;
        float step = (this.growth_stages[stage][1] - this.growth_stages[stage][0]) / 25.0f;
        if (this.getAgeInDays() > 125) {
            return this.growth_stages[stage][0] + step * 25.0f;
        }
        return this.growth_stages[stage][0] + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean m_7327_(Entity entityIn) {
        this.m_21563_().m_24960_(entityIn, 30.0f, 30.0f);
        if (this.isTackling() || this.isModelDead()) {
            return false;
        }
        boolean flag = entityIn.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void m_6083_() {
        Entity entity = this.m_20202_();
        if (this.m_20159_() && !entity.m_6084_()) {
            this.m_8127_();
        } else {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_8119_();
            if (this.m_20159_()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.m_20363_((Entity)this) && riding instanceof Player) {
            Player player = (Player)riding;
            int i = riding.m_20197_().indexOf(this);
            float radius = (i == 2 ? -0.2f : 0.5f) + (float)(player.m_21255_() ? 2 : 0);
            float angle = (float)Math.PI / 180 * player.f_20883_ + (float)(i == 1 ? 90 : (i == 0 ? -90 : 0));
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double extraY = (riding.m_6144_() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.f_20885_ = player.f_20885_;
            this.m_146922_(this.f_20885_);
            this.m_6034_(riding.m_20185_() + extraX, riding.m_20186_() + extraY, riding.m_20189_() + extraZ);
            if ((this.getControlState() == 16 || player.m_21255_()) && !riding.m_20159_()) {
                this.m_8127_();
                if (this.m_9236_().f_46443_) {
                    FriendlyByteBuf buf = PacketBufferUtils.create();
                    buf.writeInt(this.m_19879_()).writeBoolean(false).writeBoolean(true);
                    NetworkManager.sendToServer((ResourceLocation)StaticVariables.START_RIDING_MOB_C2S, (FriendlyByteBuf)buf);
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void m_8032_() {
        if (!(this.m_5803_() || this.isModelDead() || this.m_9236_().f_46443_)) {
            if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.m_8032_();
        }
    }

    protected void m_6677_(DamageSource source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION && !this.m_9236_().f_46443_) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.m_6677_(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)otherAnimal;
            if (otherAnimal != this && otherAnimal.getClass() == this.getClass()) {
                return this.isMale() && !dragon.isMale() || !this.isMale() && dragon.isMale();
            }
        }
        return false;
    }

    public EntityDragonEgg createEgg(EntityDragonBase ageable) {
        EntityDragonEgg dragon = new EntityDragonEgg((EntityType<EntityDragonEgg>)((EntityType)IafEntities.DRAGON_EGG.get()), this.m_9236_());
        dragon.setEggType(DragonColor.byMetadata(new Random().nextInt(4) + this.getStartMetaForType()));
        dragon.m_6034_((double)Mth.m_14107_((double)this.m_20185_()) + 0.5, Mth.m_14107_((double)this.m_20186_()) + 1, (double)Mth.m_14107_((double)this.m_20189_()) + 0.5);
        return dragon;
    }

    public int getStartMetaForType() {
        return 0;
    }

    public boolean isTargetBlocked(Vec3 target) {
        if (target != null) {
            BlockHitResult rayTrace = this.m_9236_().m_45547_(new ClipContext(this.m_20182_().m_82520_(0.0, (double)this.m_20192_(), 0.0), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            BlockPos sidePos = rayTrace.m_82425_();
            if (!this.m_9236_().m_46859_(sidePos)) {
                return true;
            }
            return rayTrace.m_6662_() == HitResult.Type.BLOCK;
        }
        return false;
    }

    private double getFlySpeed() {
        return (2.0 + (double)this.getAgeInDays() / 125.0 * 2.0) * (double)(this.isTackling() ? 2 : 1);
    }

    public boolean isTackling() {
        return (Boolean)this.f_19804_.m_135370_(TACKLE);
    }

    public void setTackling(boolean tackling) {
        this.f_19804_.m_135381_(TACKLE, (Object)tackling);
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.f_19804_.m_135370_(AGINGDISABLED);
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.f_19804_.m_135381_(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public boolean isBoundToCrystal() {
        return (Boolean)this.f_19804_.m_135370_(CRYSTAL_BOUND);
    }

    public void setCrystalBound(boolean crystalBound) {
        this.f_19804_.m_135381_(CRYSTAL_BOUND, (Object)crystalBound);
    }

    public float getDistanceSquared(Vec3 Vector3d) {
        float f = (float)(this.m_20185_() - Vector3d.f_82479_);
        float f1 = (float)(this.m_20186_() - Vector3d.f_82480_);
        float f2 = (float)(this.m_20189_() - Vector3d.f_82481_);
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean m_6107_() {
        return this.m_21223_() <= 0.0f || this.m_21827_() && !this.m_20160_() || this.isModelDead() || this.m_20159_();
    }

    public boolean m_20069_() {
        return super.m_20069_() && this.m_204036_(FluidTags.f_13131_) > (double)Mth.m_14143_((float)((float)this.getDragonStage() / 2.0f));
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.getAnimation() == ANIMATION_SHAKEPREY || !this.canMove() && !this.m_20160_() || this.m_21827_()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            pTravelVector = new Vec3(0.0, 0.0, 0.0);
        }
        Objects.requireNonNull(this);
        if (this.m_6688_() != null) {
            LivingEntity rider = this.m_6688_();
            if (rider == null) {
                super.m_7023_(pTravelVector);
                return;
            }
            if (this.isHovering() || this.isFlying()) {
                double forward = rider.f_20902_;
                double strafing = rider.f_20900_;
                double vertical = 0.0;
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                float airSpeedModifier = (float)((double)5.2f + 1.0 * Mth.m_144914_((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                speed *= airSpeedModifier;
                if (forward > 0.0) {
                    this.setFlying(true);
                    this.setHovering(false);
                }
                this.setTackling(this.m_5912_() && this.m_146909_() > -5.0f && this.m_20184_().m_82553_() > 1.0);
                Objects.requireNonNull(this);
                boolean bl = this.gliding = rider.m_20142_();
                if (!this.gliding) {
                    speed += this.glidingSpeedBonus;
                    forward *= rider.f_20902_ > 0.0f ? 1.0 : 0.5;
                    strafing *= (double)0.4f;
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = 1.0;
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = -1.0;
                    } else {
                        this.m_6109_();
                    }
                } else {
                    speed *= 1.5f;
                    strafing *= (double)0.1f;
                    this.glidingSpeedBonus = (float)Mth.m_14008_((double)((double)this.glidingSpeedBonus + this.m_20184_().f_82480_ * -0.05), (double)-0.8, (double)1.5);
                    speed += this.glidingSpeedBonus;
                    forward = Mth.m_14154_((float)Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180))));
                    vertical = Mth.m_14154_((float)Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180))));
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = Math.max(vertical, 0.5);
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = Math.min(vertical, -0.5);
                    } else if (this.isGoingUp() && this.isGoingDown()) {
                        vertical = 0.0;
                    } else if (this.m_146909_() < 0.0f) {
                        vertical *= 1.0;
                    } else if (this.m_146909_() > 0.0f) {
                        vertical *= -1.0;
                    } else {
                        this.m_6109_();
                    }
                }
                this.glidingSpeedBonus -= (float)((double)this.glidingSpeedBonus * 0.01);
                if (this.m_6109_()) {
                    float flyingSpeed = speed * 0.1f;
                    this.m_7910_(flyingSpeed);
                    this.m_19920_(flyingSpeed, new Vec3(strafing, vertical, forward));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82559_(new Vec3(0.9, 0.9, 0.9)));
                    Vec3 currentMotion = this.m_20184_();
                    if (this.f_19862_) {
                        currentMotion = new Vec3(currentMotion.f_82479_, 0.1, currentMotion.f_82481_);
                    }
                    this.m_20256_(currentMotion);
                    this.m_267651_(false);
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
                this.updatePitch(this.f_19791_ - this.m_20186_());
            } else if (this.m_20069_() || this.m_20077_()) {
                double forward = rider.f_20902_;
                double strafing = rider.f_20900_;
                double vertical = 0.0;
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                if (this.isGoingUp() && !this.isGoingDown()) {
                    vertical = 0.5;
                } else if (this.isGoingDown() && !this.isGoingUp()) {
                    vertical = -0.5;
                }
                float flyingSpeed = speed;
                this.m_7910_(flyingSpeed);
                this.m_21564_((float)forward);
                super.m_7023_(pTravelVector.m_82520_(strafing, vertical, forward));
            } else {
                double forward = rider.f_20902_;
                double strafing = rider.f_20900_ * 0.5f;
                double vertical = pTravelVector.f_82480_;
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
                forward *= (double)(speed *= groundSpeedModifier);
                forward *= rider.m_20142_() ? (double)1.2f : 1.0;
                forward *= rider.f_20902_ > 0.0f ? 1.0 : (double)0.2f;
                if (this.m_6109_()) {
                    this.m_7910_(speed);
                    super.m_7023_(new Vec3(strafing, vertical, forward));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
                this.updatePitch(this.f_19791_ - this.m_20186_());
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void updatePitch(double verticalDelta) {
        if (this.isOverAir() && !this.m_20159_()) {
            if (!this.isHovering()) {
                this.incrementDragonPitch((float)verticalDelta * 10.0f);
            }
            this.setDragonPitch(Mth.m_14036_((float)this.getDragonPitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            float planeDist = (float)((Math.abs(this.m_20184_().f_82479_) + Math.abs(this.m_20184_().f_82481_)) * 6.0);
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(1.0f);
            } else if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(1.0f);
            }
            if (this.m_6688_() == null && this.getDragonPitch() < -45.0f && planeDist < 3.0f && this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
        } else if (Mth.m_14154_((float)this.getDragonPitch()) < 1.0f) {
            this.setDragonPitch(0.0f);
        } else {
            this.setDragonPitch(this.getDragonPitch() / 1.5f);
        }
    }

    public void updateRider() {
        LivingEntity controllingPassenger = this.m_6688_();
        if (controllingPassenger instanceof Player) {
            Player rider = (Player)controllingPassenger;
            this.ticksStill = 0;
            this.hoverTicks = 0;
            this.flyTicks = 0;
            if (this.isGoingUp()) {
                if (!this.isFlying() && !this.isHovering()) {
                    this.spacebarTicks += 2;
                }
            } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.setCommand(2);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.m_269323_() != null && this.m_20197_().contains(this.m_269323_()) && !this.isFlying() && !this.isHovering() && !this.m_20069_()) {
                this.setHovering(true);
                this.spacebarTicks = 0;
                this.glidingSpeedBonus = 0.0f;
            }
            if (this.isFlying() || this.isHovering()) {
                if (rider.f_20902_ > 0.0f) {
                    this.setFlying(true);
                    this.setHovering(false);
                } else {
                    this.setFlying(false);
                    this.setHovering(true);
                }
                if (!this.isOverAir() && this.isFlying() && rider.m_146909_() > 10.0f && !this.m_20069_()) {
                    this.setHovering(false);
                    this.setFlying(false);
                }
                if (!this.isOverAir() && this.isGoingDown() && !this.m_20069_()) {
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (this.isTackling()) {
                ++this.tacklingTicks;
                if (this.tacklingTicks == 40) {
                    this.tacklingTicks = 0;
                }
                if (!this.isFlying() && this.m_20096_()) {
                    this.tacklingTicks = 0;
                    this.setTackling(false);
                }
                List victims = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82363_(2.0, 2.0, 2.0), potentialVictim -> potentialVictim != rider && potentialVictim instanceof LivingEntity);
                victims.forEach(victim -> this.logic.attackTarget((Entity)victim, rider, this.getDragonStage() * 3));
            }
            if (this.isStriking() && this.m_6688_() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire((Entity)this.m_6688_());
                this.fireStopTicks = 10;
            }
            if (this.m_5912_() && this.m_6688_() != null && this.m_6688_() instanceof Player) {
                int damage;
                boolean didDamage;
                LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, this.m_6688_(), (double)this.getDragonStage() + (this.m_20191_().f_82291_ - this.m_20191_().f_82288_));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (Entity)target) && (didDamage = this.logic.attackTarget((Entity)target, rider, damage = (int)this.m_21051_(Attributes.f_22281_).m_22135_())) && ((Boolean)IafCommonConfig.INSTANCE.dragon.canHealFromBiting.getValue()).booleanValue()) {
                    this.m_5634_((float)damage * 0.1f);
                }
            }
            if (this.m_6688_() != null && this.m_6688_().m_6144_()) {
                IafEntityData data = IafEntityData.get(this.m_6688_());
                data.miscData.setDismounted(true);
                this.m_6688_().m_8127_();
            }
            if (this.m_5448_() != null && !this.m_20197_().isEmpty() && this.m_269323_() != null && this.m_20197_().contains(this.m_269323_())) {
                this.m_6710_(null);
            }
            if (this.m_146900_().m_60819_().m_76170_() && this.m_20069_() && !this.isGoingUp()) {
                this.setFlying(false);
                this.setHovering(false);
            }
        } else if (controllingPassenger instanceof EntityDreadQueen) {
            Player ridingPlayer = this.getRidingPlayer();
            if (ridingPlayer != null) {
                if (this.isGoingUp()) {
                    if (!this.isFlying() && !this.isHovering()) {
                        this.spacebarTicks += 2;
                    }
                } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (!this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
            }
            if (this.isStriking() && this.m_6688_() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire((Entity)this.m_6688_());
                this.fireStopTicks = 10;
            }
            if (this.m_5912_() && this.m_6688_() != null && this.m_6688_() instanceof Player) {
                LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, this.m_6688_(), (double)this.getDragonStage() + (this.m_20191_().f_82291_ - this.m_20191_().f_82288_));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (Entity)target)) {
                    this.logic.attackTarget((Entity)target, ridingPlayer, (int)this.m_21051_(Attributes.f_22281_).m_22135_());
                }
            }
            if (this.m_6688_() != null && this.m_6688_().m_6144_()) {
                IafEntityData data = IafEntityData.get(this.m_6688_());
                data.miscData.setDismounted(true);
                this.m_6688_().m_8127_();
            }
            if (this.isFlying()) {
                if (!this.isHovering() && this.m_6688_() != null && !this.m_20096_() && Math.max(Math.abs(this.m_20184_().m_7096_()), Math.abs(this.m_20184_().m_7094_())) < (double)0.1f) {
                    this.setHovering(true);
                    this.setFlying(false);
                }
            } else if (this.isHovering() && this.m_6688_() != null && !this.m_20096_() && Math.max(Math.abs(this.m_20184_().m_7096_()), Math.abs(this.m_20184_().m_7094_())) > (double)0.1f) {
                this.setFlying(true);
                this.usingGroundAttack = false;
                this.setHovering(false);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.m_269323_() != null && this.m_20197_().contains(this.m_269323_()) && !this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
            if (this.m_20160_() && !this.isOverAir() && this.isFlying() && !this.isHovering() && this.flyTicks > 40) {
                this.setFlying(false);
            }
        }
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        if (this.m_21827_() && !this.m_20160_()) {
            pPos = new Vec3(0.0, pPos.m_7098_(), 0.0);
        }
        if (this.m_20160_()) {
            if (this.m_6109_()) {
                if (this.f_19862_) {
                    this.m_20256_(this.m_20184_().m_82542_((double)0.6f, 1.0, (double)0.6f));
                }
                super.m_6478_(pType, pPos);
            } else {
                super.m_6478_(pType, pPos);
            }
            this.m_20242_(this.isHovering() || this.isFlying());
        } else {
            this.m_20242_(false);
            super.m_6478_(pType, pPos);
        }
    }

    public void updateCheckPlayer() {
        double checkLength = this.m_20191_().m_82309_() * 3.0;
        Player player = this.m_9236_().m_45930_((Entity)this, checkLength);
        if (this.m_5803_() && player != null && !this.m_21830_((LivingEntity)player) && !player.m_7500_()) {
            this.m_21837_(false);
            this.m_21839_(false);
            this.m_6710_((LivingEntity)player);
        }
    }

    public boolean isDirectPathBetweenPoints(Vec3 vec1, Vec3 vec2) {
        BlockHitResult rayTrace = this.m_9236_().m_45547_(new ClipContext(vec1, new Vec3(vec2.f_82479_, vec2.f_82480_ + (double)this.m_20206_() * 0.5, vec2.f_82481_), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return rayTrace.m_6662_() != HitResult.Type.BLOCK;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.setHunger(this.getHunger() + FoodUtils.getFoodPoints((Entity)this));
    }

    @Override
    public void onHearFlute(Player player) {
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    public abstract SoundEvent getRoarSound();

    public void roar() {
        block9: {
            block8: {
                if (EntityGorgon.isStoneMob((LivingEntity)this) || this.isModelDead()) {
                    return;
                }
                if (!this.f_19796_.m_188499_()) break block8;
                if (this.getAnimation() != ANIMATION_EPIC_ROAR) {
                    this.setAnimation(ANIMATION_EPIC_ROAR);
                    this.m_5496_(this.getRoarSound(), this.m_6121_() + 3.0f + (float)Math.max(0, this.getDragonStage() - 2), this.m_6100_() * 0.7f);
                }
                if (this.getDragonStage() <= 3) break block9;
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (isStrongerDragon) continue;
                    if (this.m_21830_(living) || this.isOwnersPet(living)) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 50 * size));
                        continue;
                    }
                    if (living.m_6844_(EquipmentSlot.HEAD).m_41720_() == IafItems.EARPLUGS.get()) continue;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50 * size));
                }
                break block9;
            }
            if (this.getAnimation() != ANIMATION_ROAR) {
                this.setAnimation(ANIMATION_ROAR);
                this.m_5496_(this.getRoarSound(), this.m_6121_() + 2.0f + (float)Math.max(0, this.getDragonStage() - 3), this.m_6100_());
            }
            if (this.getDragonStage() > 3) {
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82363_((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (isStrongerDragon) continue;
                    if (this.m_21830_(living) || this.isOwnersPet(living)) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 30 * size));
                        continue;
                    }
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 30 * size));
                }
            }
        }
    }

    private boolean isOwnersPet(LivingEntity living) {
        return this.m_21824_() && this.m_269323_() != null && living instanceof TamableAnimal && ((TamableAnimal)living).m_269323_() != null && this.m_269323_().m_7306_((Entity)((TamableAnimal)living).m_269323_());
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3 vec1, Vec3 vec2) {
        BlockHitResult movingobjectposition = this.m_9236_().m_45547_(new ClipContext(vec1, vec2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return movingobjectposition.m_6662_() != HitResult.Type.BLOCK;
    }

    public boolean shouldRenderEyes() {
        return !this.m_5803_() && !this.isModelDead() && !this.isBlinking() && !EntityGorgon.isStoneMob((LivingEntity)this);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
    }

    public boolean isChained() {
        AtomicBoolean isChained = new AtomicBoolean(false);
        IafEntityData data = IafEntityData.get((LivingEntity)this);
        isChained.set(data.chainData.getChainedTo().isEmpty());
        return isChained.get();
    }

    protected void m_7625_(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public HitResult rayTraceRider(Entity rider, double blockReachDistance, float partialTicks) {
        Vec3 Vector3d = rider.m_20299_(partialTicks);
        Vec3 Vector3d1 = rider.m_20252_(partialTicks);
        Vec3 Vector3d2 = Vector3d.m_82520_(Vector3d1.f_82479_ * blockReachDistance, Vector3d1.f_82480_ * blockReachDistance, Vector3d1.f_82481_ * blockReachDistance);
        return this.m_9236_().m_45547_(new ClipContext(Vector3d, Vector3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    protected float getRideHeightBase() {
        return 0.00223789f * Mth.m_14207_((float)this.getRenderSize()) + 0.23313718f * this.getRenderSize() - 1.7179043f;
    }

    protected float getRideHorizontalBase() {
        return 0.00336283f * Mth.m_14207_((float)this.getRenderSize()) + 0.19342425f * this.getRenderSize() - 0.026221339f;
    }

    public Vec3 getRiderPosition() {
        float extraXZ = 0.0f;
        float extraY = 0.0f;
        float pitchXZ = 0.0f;
        float pitchY = 0.0f;
        float dragonPitch = this.getDragonPitch();
        if (dragonPitch > 0.0f) {
            pitchXZ = Math.min(dragonPitch / 90.0f, 0.2f);
            pitchY = -(dragonPitch / 90.0f) * 0.6f;
        } else if (dragonPitch < 0.0f) {
            pitchXZ = Math.max(dragonPitch / 90.0f, -0.5f);
            pitchY = dragonPitch / 90.0f * 0.03f;
        }
        extraXZ += pitchXZ * this.getRenderSize();
        extraY += pitchY * this.getRenderSize();
        float linearFactor = Mth.m_184637_((float)Math.max(this.getAgeInDays() - 50, 0), (float)0.0f, (float)75.0f, (float)0.0f, (float)1.0f);
        LivingEntity rider = this.m_6688_();
        if (rider != null && rider.m_146909_() < 0.0f) {
            extraY += (float)Mth.m_144914_((double)rider.m_146909_(), (double)60.0, (double)-40.0, (double)-0.1, (double)0.1);
        }
        if (this.isHovering() || this.isFlying()) {
            extraY += 1.1f * linearFactor;
            extraY += this.getRideHeightBase() * 0.6f;
        } else {
            if (rider != null && rider.f_20902_ > 0.0f) {
                float MAX_RAISE_HEIGHT = 1.1f * linearFactor + this.getRideHeightBase() * 0.1f;
                this.riderWalkingExtraY = Math.min(MAX_RAISE_HEIGHT, this.riderWalkingExtraY + 0.1f);
            } else {
                this.riderWalkingExtraY = Math.max(0.0f, this.riderWalkingExtraY - 0.15f);
            }
            extraY += this.riderWalkingExtraY;
        }
        float xzMod = this.getRideHorizontalBase() + extraXZ;
        float yMod = this.getRideHeightBase() + extraY;
        float headPosX = (float)(this.m_20185_() + (double)(xzMod * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.m_20186_() + (double)yMod);
        float headPosZ = (float)(this.m_20189_() + (double)(xzMod * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        return new Vec3((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        if (passenger.m_5830_()) {
            return this.m_20182_().m_82520_(0.0, 1.0, 0.0);
        }
        return this.getRiderPosition().m_82520_(0.0, (double)passenger.m_20206_(), 0.0);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.setDeathStage(this.getAgeInDays() / 5);
        this.setModelDead(false);
    }

    public boolean m_7307_(Entity entityIn) {
        if (this.isModelDead()) {
            return true;
        }
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_269323_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                TamableAnimal entity = (TamableAnimal)entityIn;
                return entity.m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public Vec3 getHeadPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        int tick = this.getAnimationTick() < 10 ? this.getAnimationTick() : (this.getAnimationTick() > 50 ? 60 - this.getAnimationTick() : 10);
        float epicRoarProg = this.getAnimation() == ANIMATION_EPIC_ROAR ? (float)tick * 0.1f : 0.0f;
        float sleepProg = this.sleepProgress * -0.025f;
        float pitchMulti = 0.0f;
        float pitchAdjustment = 0.0f;
        float pitchMinus = 0.0f;
        float dragonPitch = -this.getDragonPitch();
        if (this.isFlying() || this.isHovering()) {
            pitchMulti = Mth.m_14031_((float)((float)Math.toRadians(dragonPitch)));
            pitchAdjustment = 1.2f;
            if ((pitchMulti *= 2.1f * Math.abs(dragonPitch) / 90.0f) > 0.0f) {
                pitchMulti *= 1.5f - pitchMulti * 0.5f;
            }
            if (pitchMulti < 0.0f) {
                pitchMulti *= 1.3f - pitchMulti * 0.1f;
            }
            pitchMinus = 0.3f * Math.abs(dragonPitch / 90.0f);
            if (dragonPitch >= 0.0f) {
                pitchAdjustment = 0.6f * Math.abs(dragonPitch / 90.0f);
                pitchMinus = 0.95f * Math.abs(dragonPitch / 90.0f);
            }
        }
        float flightXz = 1.0f + flyProg + hoverProg;
        float xzMod = 1.7f * this.getRenderSize() * 0.3f * flightXz + this.getRenderSize() * (0.3f * Mth.m_14031_((float)((float)((double)(dragonPitch + 90.0f) * Math.PI / 180.0))) * pitchAdjustment - pitchMinus - hoverProg * 0.45f);
        float headPosX = (float)(this.m_20185_() + (double)(xzMod * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.m_20186_() + (double)((0.7f + sitProg + hoverProg + deadProg + epicRoarProg + sleepProg + flyProg + pitchMulti) * this.getRenderSize() * 0.3f));
        float headPosZ = (float)(this.m_20189_() + (double)(xzMod * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        return new Vec3((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public abstract void stimulateFire(double var1, double var3, double var5, int var7);

    public void randomizeAttacks() {
        this.airAttack = IafDragonAttacks.Air.values()[this.m_217043_().m_188503_(IafDragonAttacks.Air.values().length)];
        this.groundAttack = IafDragonAttacks.Ground.values()[this.m_217043_().m_188503_(IafDragonAttacks.Ground.values().length)];
    }

    public boolean m_7349_(Explosion explosionIn, BlockGetter worldIn, BlockPos pos, BlockState blockStateIn, float explosionPower) {
        return !(blockStateIn.m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(blockStateIn, (Entity)this);
    }

    public void tryScorchTarget() {
        LivingEntity entity = this.m_5448_();
        if (entity != null) {
            float distX = (float)(entity.m_20185_() - this.m_20185_());
            float distZ = (float)(entity.m_20189_() - this.m_20189_());
            if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.m_146922_(this.f_20883_);
                    if (this.f_19797_ % 5 == 0) {
                        this.m_5496_((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                    }
                    int breathTicks = Mth.m_14045_((int)this.fireBreathTicks, (int)0, (int)40);
                    this.stimulateFire(this.m_20185_() + (double)(distX * (float)breathTicks / 40.0f), entity.m_20186_(), this.m_20189_() + (double)(distZ * (float)breathTicks / 40.0f), 1);
                }
            } else {
                this.setBreathingFire(true);
            }
        }
    }

    public void m_6710_(LivingEntity LivingEntityIn) {
        super.m_6710_(LivingEntityIn);
        this.flightManager.onSetAttackTarget(LivingEntityIn);
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        TamableAnimal tamableTarget;
        UUID targetOwner;
        if (this.m_21824_() && target instanceof TamableAnimal && (targetOwner = (tamableTarget = (TamableAnimal)target).m_21805_()) != null && targetOwner.equals(this.m_21805_())) {
            return false;
        }
        return super.m_7757_(target, owner);
    }

    public boolean m_6779_(LivingEntity target) {
        return super.m_6779_(target) && DragonUtils.isAlive(target);
    }

    public boolean isPart(Entity entityHit) {
        return this.headPart != null && this.headPart.m_7306_(entityHit) || this.neckPart != null && this.neckPart.m_7306_(entityHit) || this.leftWingLowerPart != null && this.leftWingLowerPart.m_7306_(entityHit) || this.rightWingLowerPart != null && this.rightWingLowerPart.m_7306_(entityHit) || this.leftWingUpperPart != null && this.leftWingUpperPart.m_7306_(entityHit) || this.rightWingUpperPart != null && this.rightWingUpperPart.m_7306_(entityHit) || this.tail1Part != null && this.tail1Part.m_7306_(entityHit) || this.tail2Part != null && this.tail2Part.m_7306_(entityHit) || this.tail3Part != null && this.tail3Part.m_7306_(entityHit) || this.tail4Part != null && this.tail4Part.m_7306_(entityHit);
    }

    @Override
    public double getFlightSpeedModifier() {
        return (Double)IafCommonConfig.INSTANCE.dragon.dragonFlightSpeedMod.getValue();
    }

    public boolean isAllowedToTriggerFlight() {
        return (this.hasFlightClearance() && this.m_20096_() || this.m_20069_()) && !this.m_21827_() && this.m_20197_().isEmpty() && !this.m_6162_() && !this.m_5803_() && this.canMove();
    }

    public BlockPos getEscortPosition() {
        return this.m_269323_() != null ? new BlockPos((Vec3i)this.m_269323_().m_20183_()) : this.m_20183_();
    }

    public boolean shouldTPtoOwner() {
        return this.m_269323_() != null && this.m_20270_((Entity)this.m_269323_()) > 10.0f;
    }

    public boolean isSkeletal() {
        return this.getDeathStage() >= this.getAgeInDays() / 5 / 2;
    }

    public boolean m_20223_(CompoundTag compound) {
        return this.m_20086_(compound);
    }

    public void m_5496_(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.f_11912_ || soundIn == this.m_7515_() || soundIn == this.m_7975_(this.m_9236_().m_269111_().m_269264_()) || soundIn == this.m_5592_() || soundIn == this.getRoarSound()) {
            if (!this.m_20067_() && this.headPart != null) {
                this.m_9236_().m_6263_(null, this.headPart.m_20185_(), this.headPart.m_20186_(), this.headPart.m_20189_(), soundIn, this.m_5720_(), volume, pitch);
            }
        } else {
            super.m_5496_(soundIn, volume, pitch);
        }
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean hasFlightClearance() {
        BlockPos topOfBB = BlockPos.m_274561_((double)this.m_146903_(), (double)this.m_20191_().f_82292_, (double)this.m_146907_());
        for (int i = 1; i < 4; ++i) {
            if (this.m_9236_().m_46859_(topOfBB.m_6630_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return switch (slotIn) {
            case EquipmentSlot.OFFHAND -> this.dragonInventory.m_8020_(0);
            case EquipmentSlot.HEAD -> this.dragonInventory.m_8020_(1);
            case EquipmentSlot.CHEST -> this.dragonInventory.m_8020_(2);
            case EquipmentSlot.LEGS -> this.dragonInventory.m_8020_(3);
            case EquipmentSlot.FEET -> this.dragonInventory.m_8020_(4);
            default -> super.m_6844_(slotIn);
        };
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn) {
            case OFFHAND: {
                this.dragonInventory.m_6836_(0, stack);
                break;
            }
            case HEAD: {
                this.dragonInventory.m_6836_(1, stack);
                break;
            }
            case CHEST: {
                this.dragonInventory.m_6836_(2, stack);
                break;
            }
            case LEGS: {
                this.dragonInventory.m_6836_(3, stack);
                break;
            }
            case FEET: {
                this.dragonInventory.m_6836_(4, stack);
                break;
            }
            default: {
                super.m_6844_(slotIn);
                return;
            }
        }
        this.dragonInventory.m_6596_();
    }

    public SoundEvent getBabyFireSound() {
        return SoundEvents.f_11937_;
    }

    public boolean isPlayingAttackAnimation() {
        return this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_SHAKEPREY || this.getAnimation() == ANIMATION_WINGBLAST || this.getAnimation() == ANIMATION_TAILWHACK;
    }

    protected IafDragonLogic createDragonLogic() {
        return new IafDragonLogic(this);
    }

    public int getFlightChancePerTick() {
        return 1500;
    }

    public void m_142036_() {
        DragonPosWorldData data;
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.chunkLoadSummonCrystal.getValue()).booleanValue() && this.isBoundToCrystal() && (data = DragonPosWorldData.get(this.m_9236_())) != null) {
            data.addDragon(this.m_20148_(), this.m_20183_());
        }
        super.m_142036_();
    }

    public int maxSearchNodes() {
        return (int)this.m_21051_(Attributes.f_22277_).m_22135_();
    }

    public boolean isSmallerThanBlock() {
        return false;
    }

    public float getXZNavSize() {
        return Math.max(1.4f, this.m_20205_() / 2.0f);
    }

    public int getYNavSize() {
        return Mth.m_14167_((float)this.m_20206_());
    }

    public void m_5757_(Container invBasic) {
        if (!this.m_9236_().f_46443_) {
            this.updateAttributes();
        }
    }

    public Vec3 m_21074_(Vec3 pDeltaMovement, float pFriction) {
        if (this.f_21342_ instanceof IafDragonFlightManager.PlayerFlightMoveHelper) {
            return pDeltaMovement;
        }
        return super.m_21074_(pDeltaMovement, pFriction);
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public boolean isBlockExplicitlyPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return false;
    }

    public boolean isBlockExplicitlyNotPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return false;
    }
}

