/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafWorld;
import com.iafenvoy.iceandfire.world.processor.DreadPortalProcessor;
import com.iafenvoy.iceandfire.world.util.DimensionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class PortalData {
    private final Player player;
    private boolean teleported = false;
    private int teleportTick = -1;

    public PortalData(Player player) {
        this.player = player;
    }

    public void tick() {
        Level world = this.player.m_9236_();
        if (!this.teleported && this.teleportTick == 0 && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.teleported = true;
            MinecraftServer server = serverWorld.m_7654_();
            if (world.m_46472_().m_135782_().equals((Object)IafWorld.DREAD_LAND.m_135782_())) {
                DimensionUtil.changeDimension(this.player, server.m_129880_(Level.f_46428_), new PortalInfo(this.player.m_20182_(), Vec3.f_82478_, this.player.f_20885_, this.player.m_146909_()));
            } else {
                ServerLevel dreadLand = server.m_129880_(IafWorld.DREAD_LAND);
                if (dreadLand == null) {
                    return;
                }
                DimensionUtil.changeDimension(this.player, dreadLand, new PortalInfo(this.player.m_20182_(), Vec3.f_82478_, this.player.f_20885_, this.player.m_146909_()));
                if (!dreadLand.m_8055_(this.player.m_20183_()).m_60713_((Block)IafBlocks.DREAD_PORTAL.get())) {
                    server.m_236738_().m_230407_(ResourceLocation.m_214293_((String)"iceandfire", (String)"dread_exit_portal")).ifPresent(structureTemplate -> structureTemplate.m_230328_((ServerLevelAccessor)dreadLand, this.player.m_20183_().m_121996_((Vec3i)new BlockPos(2, 1, 2)), BlockPos.f_121853_, new StructurePlaceSettings().m_74383_((StructureProcessor)new DreadPortalProcessor()), dreadLand.f_46441_, 2));
                }
                this.player.m_213846_((Component)Component.m_237115_((String)"warning.iceandfire.dreadland.not_complete"));
            }
        }
        if (world.m_8055_(this.player.m_20183_()).m_60713_((Block)IafBlocks.DREAD_PORTAL.get())) {
            if (this.teleportTick > 0) {
                --this.teleportTick;
            } else if (this.teleportTick == -1) {
                this.teleportTick = 100;
            }
        } else {
            this.teleported = false;
            this.teleportTick = -1;
        }
    }

    public void readFromNbt(CompoundTag tag) {
        this.setTeleported(tag.m_128471_("teleported"));
        this.setTeleportTick(tag.m_128451_("teleport_tick"));
    }

    public void writeToNbt(CompoundTag tag) {
        tag.m_128379_("teleported", this.isTeleported());
        tag.m_128405_("teleport_tick", this.getTeleportTick());
    }

    public boolean isTeleported() {
        return this.teleported;
    }

    public int getTeleportTick() {
        return this.teleportTick;
    }

    public void setTeleported(boolean teleported) {
        this.teleported = teleported;
    }

    public void setTeleportTick(int teleportTick) {
        this.teleportTick = teleportTick;
    }

    public static PortalData get(Player player) {
        return ComponentManager.getPortalData(player);
    }
}

