/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;

public class DragonType {
    private static final List<DragonType> TYPES = new ArrayList<DragonType>();
    private static final Map<String, DragonType> BY_NAME = new HashMap<String, DragonType>();
    public static final DragonType FIRE = new DragonType("fire", () -> IafEntities.FIRE_DRAGON.get(), (Supplier<Item>)IafItems.DRAGON_SKULL_FIRE, (Supplier<Item>)IafItems.SUMMONING_CRYSTAL_FIRE);
    public static final DragonType ICE = new DragonType("ice", () -> IafEntities.ICE_DRAGON.get(), (Supplier<Item>)IafItems.DRAGON_SKULL_ICE, (Supplier<Item>)IafItems.SUMMONING_CRYSTAL_ICE).setPiscivore();
    public static final DragonType LIGHTNING = new DragonType("lightning", () -> IafEntities.LIGHTNING_DRAGON.get(), (Supplier<Item>)IafItems.DRAGON_SKULL_LIGHTNING, (Supplier<Item>)IafItems.SUMMONING_CRYSTAL_LIGHTNING);
    private final String name;
    private final Supplier<EntityType<? extends EntityDragonBase>> entityType;
    private final Supplier<Item> skullItem;
    private final Supplier<Item> crystalItem;
    private boolean piscivore;

    public DragonType(String name, Supplier<EntityType<? extends EntityDragonBase>> entityType, Supplier<Item> skullItem, Supplier<Item> crystalItem) {
        this.name = name;
        this.entityType = entityType;
        this.skullItem = skullItem;
        this.crystalItem = crystalItem;
        TYPES.add(this);
        BY_NAME.put(name, this);
    }

    public static String getNameFromInt(int type) {
        return DragonType.TYPES.get((int)type).name;
    }

    public static DragonType getTypeById(String id) {
        return BY_NAME.getOrDefault(id, FIRE);
    }

    public static DragonType getTypeByEntityType(EntityType<?> type) {
        return TYPES.stream().filter(x -> x.entityType.get() == type).findFirst().orElse(FIRE);
    }

    public int getIntFromType() {
        return TYPES.indexOf(this);
    }

    public EntityType<? extends EntityDragonBase> getEntity() {
        return this.entityType.get();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPiscivore() {
        return this.piscivore;
    }

    public DragonType setPiscivore() {
        this.piscivore = true;
        return this;
    }

    public ResourceLocation getSkeletonTexture(int stage) {
        return ResourceLocation.m_214293_((String)"iceandfire", (String)String.format("textures/models/%sdragon/%s_skeleton_%d.png", this.name, this.name, stage));
    }

    public Item getSkullItem() {
        return this.skullItem.get();
    }

    public Item getCrystalItem() {
        return this.crystalItem.get();
    }
}

