/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.radar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.category.rule.resolver.ObjectCategoryRuleResolver;
import xaero.common.effect.Effects;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.radar.MinimapRadarList;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private EntityRadarCategoryManager entityCategoryManager;
    private Entity lastRenderViewEntity;
    private EntityRadarCategory listsGeneratedForConfig;
    private boolean listsReversedOrder;
    private List<MinimapRadarList> radarLists;
    private Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, EntityRadarCategoryManager entityCategoryManager) throws IOException {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.entityCategoryManager = entityCategoryManager;
        this.radarLists = new ArrayList<MinimapRadarList>();
        this.middleRadarListMap = new HashMap<EntityRadarCategory, MinimapRadarList>();
    }

    private void ensureCategories(EntityRadarCategory rootCategory, List<MinimapRadarList> radarLists, Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap) {
        boolean reversedOrder = ModSettings.keyReverseEntityRadar.m_90857_();
        if (this.listsGeneratedForConfig != rootCategory) {
            middleRadarListMap.clear();
            radarLists.clear();
            this.traceAddCategories(rootCategory, middleRadarListMap, radarLists);
            Collections.sort(radarLists);
            this.listsGeneratedForConfig = rootCategory;
            this.listsReversedOrder = false;
        }
        if (this.listsReversedOrder != reversedOrder) {
            Collections.reverse(radarLists);
            this.listsReversedOrder = reversedOrder;
        }
    }

    private void traceAddCategories(EntityRadarCategory category, Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap, List<MinimapRadarList> radarLists) {
        category.getDirectSubCategoryIterator().forEachRemaining(sb -> this.traceAddCategories((EntityRadarCategory)sb, middleRadarListMap, radarLists));
        MinimapRadarList radarList = MinimapRadarList.Builder.getDefault().build().setCategory(category);
        middleRadarListMap.put(category, radarList);
        radarLists.add(radarList);
    }

    public void updateRadar(ClientLevel world, Player p, Entity renderEntity, MinimapProcessor minimap) {
        if (renderEntity == null) {
            renderEntity = this.lastRenderViewEntity;
        }
        List<MinimapRadarList> radarLists = this.radarLists;
        Map<EntityRadarCategory, MinimapRadarList> middleRadarListMap = this.middleRadarListMap;
        EntityRadarCategoryManager entityCategoryManager = this.entityCategoryManager;
        EntityRadarCategory rootCategory = entityCategoryManager.getRootCategory();
        this.ensureCategories(rootCategory, radarLists, middleRadarListMap);
        radarLists.forEach(l -> l.getEntities().clear());
        if (this.modMain.isFairPlay() || !this.modMain.getSettings().getEntityRadar() && (!this.modMain.getSupportMods().worldmap() || !this.modMain.getSupportMods().worldmapSupport.worldMapIsRenderingRadar()) || world == null || p == null || renderEntity == null || Misc.hasEffect(p, Effects.NO_RADAR) || Misc.hasEffect(p, Effects.NO_RADAR_HARMFUL)) {
            return;
        }
        if (!MinimapClientWorldDataHelper.getWorldData((ClientLevel)world).getSyncedRules().allowRadarOnServer) {
            return;
        }
        ObjectCategoryRuleResolver categoryRuleResolver = entityCategoryManager.getRuleResolver();
        Iterable worldEntities = world.m_104735_();
        boolean hideInvisible = this.modMain.getSettings().radarHideInvisibleEntities;
        for (Entity e : worldEntities) {
            try {
                int heightLimit;
                double offh;
                double offheight2;
                EntityRadarCategory entityCategory;
                if (e == null || hideInvisible && (e.m_20177_(p) || this.shouldHideForSneaking(e, p)) || (entityCategory = categoryRuleResolver.resolve(rootCategory, e, p)) == null || !entityCategory.getSettingValue(EntityRadarCategorySettings.DISPLAYED).booleanValue() || (offheight2 = (offh = renderEntity.m_20186_() - e.m_20186_()) * offh) > (double)((heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue()) * heightLimit)) continue;
                List<Entity> typeList = middleRadarListMap.get(entityCategory).getEntities();
                int entityAmount = entityCategory.getSettingValue(EntityRadarCategorySettings.ENTITY_NUMBER).intValue();
                if (entityAmount != 0 && typeList.size() >= entityAmount) continue;
                typeList.add(e);
            }
            catch (Exception ex) {}
        }
    }

    private boolean shouldHideForSneaking(Entity e, Player p) {
        boolean sneaking = e.m_6144_();
        if (!sneaking) {
            return false;
        }
        Team team = e.m_5647_();
        return team == null || team != p.m_5647_();
    }

    public double getEntityX(Entity e, float partial) {
        double xOld = e.f_19797_ > 0 ? e.f_19790_ : e.m_20185_();
        return xOld + (e.m_20185_() - xOld) * (double)partial;
    }

    public double getEntityY(Entity e, float partial) {
        double yOld = e.f_19797_ > 0 ? e.f_19791_ : e.m_20186_();
        return yOld + (e.m_20186_() - yOld) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        double zOld = e.f_19797_ > 0 ? e.f_19792_ : e.m_20189_();
        return zOld + (e.m_20189_() - zOld) * (double)partial;
    }

    public int getTeamColour(Entity e) {
        Integer teamColour = null;
        Team team = e.m_5647_();
        if (team != null) {
            teamColour = team.m_7414_().m_126665_();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public int getEntityColour(Player p, Entity e, float offh, boolean cave, EntityRadarCategory category, int heightLimit, int startFadingAt, boolean heightBasedFade, int colorIndex) {
        float brightness;
        int color = -1;
        if (colorIndex == -1) {
            int entityTeamColour = this.getTeamColour(e);
            if (entityTeamColour != -1) {
                color = 0xFF000000 | entityTeamColour;
            } else {
                EntityRadarCategory fallbackCategory = category;
                while (colorIndex == -1) {
                    if ((fallbackCategory = (EntityRadarCategory)fallbackCategory.getSuperCategory()) == null) {
                        colorIndex = 15;
                        continue;
                    }
                    colorIndex = fallbackCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue();
                }
            }
        }
        if (colorIndex != -1) {
            color = ModSettings.COLORS[colorIndex];
        }
        if ((brightness = this.getEntityBrightness(offh, heightLimit, startFadingAt, heightBasedFade)) < 1.0f) {
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int a = 255;
            if (cave) {
                a = (int)((float)a * brightness);
            } else {
                r = (int)((float)r * brightness);
                g = (int)((float)g * brightness);
                b = (int)((float)b * brightness);
            }
            color = a << 24 | r << 16 | g << 8 | b;
        }
        return color;
    }

    public float getEntityBrightness(float offh, int heightLimit, int startFadingAt, boolean heightBasedFade) {
        int threshold;
        float level = (float)heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        int n = threshold = startFadingAt == 0 ? heightLimit * 3 / 4 : heightLimit - startFadingAt;
        if (level <= (float)threshold && heightBasedFade) {
            brightness = 0.25f + 0.5f * level / (float)threshold;
        }
        return brightness;
    }

    public void setLastRenderViewEntity(Entity lastRenderViewEntity) {
        this.lastRenderViewEntity = lastRenderViewEntity;
    }

    public EntityRadarCategoryManager getEntityCategoryManager() {
        return this.entityCategoryManager;
    }

    public Iterator<MinimapRadarList> getRadarListsIterator() {
        return this.radarLists.iterator();
    }

    public double getMaxDistance(MinimapProcessor minimap, boolean circle) {
        int cullingSize = minimap.getMinimapSize() / 2 + 48;
        if (!circle) {
            cullingSize = (int)((double)cullingSize * Math.sqrt(2.0));
        }
        return (double)(cullingSize * cullingSize) / (minimap.getMinimapZoom() * minimap.getMinimapZoom());
    }
}

