/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import com.google.common.net.InternetDomainName;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.file.MapSaveLoad;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSettingRegistry;

public class DataFolderResolveUtil {
    public static void resolveDataFolder(ClientPacketListener connection, CallbackInfoReturnable<String> cir) {
        XaeroPlusSettingRegistry.DataFolderResolutionMode dataFolderResolutionMode = Globals.dataFolderResolutionMode;
        if (dataFolderResolutionMode == XaeroPlusSettingRegistry.DataFolderResolutionMode.SERVER_NAME) {
            String serverName;
            if (Objects.nonNull(connection.m_245416_()) && (serverName = connection.m_245416_().f_105362_).length() > 0) {
                cir.setReturnValue((Object)("Multiplayer_" + serverName.replace(":", "_")));
                cir.cancel();
                return;
            }
            if (!Minecraft.m_91087_().m_91091_()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid MC Server Name. Falling back to default Xaero data folder resolution");
            }
        } else if (dataFolderResolutionMode == XaeroPlusSettingRegistry.DataFolderResolutionMode.BASE_DOMAIN && Objects.nonNull(connection.m_245416_())) {
            Object id;
            try {
                id = InternetDomainName.from((String)connection.m_245416_().f_105363_).topPrivateDomain().toString();
            }
            catch (IllegalArgumentException ex) {
                XaeroPlus.LOGGER.error("Error resolving BASE_DOMAIN data folder. Falling back to default Xaero resolution.", (Throwable)ex);
                return;
            }
            id = ((String)id).replace(":", "_");
            while (((String)id).endsWith(".")) {
                id = ((String)id).substring(0, ((String)id).length() - 1);
            }
            if (((String)id).length() > 0) {
                id = "Multiplayer_" + (String)id;
                cir.setReturnValue(id);
                cir.cancel();
                return;
            }
            if (!Minecraft.m_91087_().m_91091_()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid Base domain. Falling back to default Xaero data folder resolution");
            }
        }
    }

    public static Component getCurrentDataDirPath() {
        try {
            WorldMapSession currentSession = XaeroWorldMapCore.currentSession;
            MapProcessor mapProcessor = currentSession.getMapProcessor();
            String mainId = mapProcessor.getMapWorld().getMainId();
            Path rootFolder = MapSaveLoad.getRootFolder((String)mainId);
            return Component.m_237113_((String)rootFolder.toString());
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Failed to get data directory", e);
            return Component.m_237113_((String)"Failed to get data directory");
        }
    }
}

