/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.resources.language.I18n;

public abstract class XaeroPlusSetting {
    public static final String SETTING_PREFIX = "[XP] ";
    private final String settingName;
    private final String settingNameTranslationKey;
    private String tooltipTranslationKey;
    private static boolean ingameOnly = false;
    private static boolean requiresMinimap = false;
    private KeyMapping keyBinding;
    private Supplier<Boolean> visibilitySupplier;

    public XaeroPlusSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, KeyMapping keyBinding, Supplier<Boolean> visibilitySupplier) {
        this.settingName = settingName;
        this.settingNameTranslationKey = settingNameTranslationKey;
        this.tooltipTranslationKey = tooltipTranslationKey;
        this.keyBinding = keyBinding;
        this.visibilitySupplier = visibilitySupplier;
    }

    protected static String defaultValueStr(String settingName, Object defaultVal) {
        return settingName + " \n    Default: " + defaultVal + " \n ";
    }

    public String getSettingName() {
        return this.settingName;
    }

    public String getSettingNameTranslationKey() {
        return this.settingNameTranslationKey;
    }

    public String getTranslatedName() {
        return SETTING_PREFIX + I18n.m_118938_((String)this.getSettingNameTranslationKey(), (Object[])new Object[0]);
    }

    public String getTooltipTranslationKey() {
        return this.tooltipTranslationKey;
    }

    public boolean isIngameOnly() {
        return ingameOnly;
    }

    public boolean isRequiresMinimap() {
        return requiresMinimap;
    }

    public KeyMapping getKeyBinding() {
        return this.keyBinding;
    }

    public void setKeyBinding(KeyMapping keyBinding) {
        this.keyBinding = keyBinding;
    }

    public boolean isVisible() {
        if (this.visibilitySupplier != null) {
            return this.visibilitySupplier.get();
        }
        return true;
    }

    public abstract void init();
}

