/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import org.apache.commons.lang3.ArrayUtils;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.settings.XaeroPlusSettingsReflectionHax;

public class XaeroPlusEnumSetting<T extends Enum<T>>
extends XaeroPlusSetting {
    private final T[] enumValues;
    private T value;
    private Consumer<T> settingChangeConsumer;

    private XaeroPlusEnumSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, KeyMapping keyBinding, Supplier<Boolean> visibilitySupplier, Consumer<T> settingChangeConsumer, T[] enumValues, T defaultValue) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.enumValues = enumValues;
        this.value = defaultValue;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static <E extends Enum<E>> XaeroPlusEnumSetting<E> create(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, E[] values, E defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusEnumSetting setting = new XaeroPlusEnumSetting("[XP] " + settingName, settingNameTranslationKey, tooltipTranslationKey, null, null, null, values, defaultValue);
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public static <E extends Enum<E>> XaeroPlusEnumSetting<E> create(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, Consumer<E> settingChangeConsumer, E[] values, E defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusEnumSetting setting = new XaeroPlusEnumSetting("[XP] " + settingName, settingNameTranslationKey, tooltipTranslationKey, null, null, settingChangeConsumer, values, defaultValue);
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public static <E extends Enum<E>> XaeroPlusEnumSetting<E> create(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, Supplier<Boolean> visibilitySupplier, Consumer<E> settingChangeConsumer, E[] values, E defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusEnumSetting setting = new XaeroPlusEnumSetting("[XP] " + settingName, settingNameTranslationKey, tooltipTranslationKey, null, visibilitySupplier, settingChangeConsumer, values, defaultValue);
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T newVal) {
        this.value = newVal;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(newVal);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Error applying setting change consumer for setting: {}, value: {}", new Object[]{this.getSettingName(), newVal, e});
            }
        }
    }

    public int getValueIndex() {
        return ArrayUtils.indexOf((Object[])this.enumValues, this.getValue());
    }

    public void setValueIndex(int index) {
        try {
            this.setValue(this.enumValues[index]);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Unable to set enum value setting for {}, index {}", new Object[]{this.getSettingName(), index, e});
        }
    }

    public int getIndexMax() {
        return this.enumValues.length - 1;
    }

    public void setSettingChangeConsumer(Consumer<T> settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public Consumer<T> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public T[] getEnumValues() {
        return this.enumValues;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }
}

