/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.api.IWaystone;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;
import xaero.map.mods.SupportMods;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.extensions.IWaypointDimension;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.module.Module;
import xaeroplus.util.BlayWaystonesHelper;
import xaeroplus.util.FabricWaystonesHelper;
import xaeroplus.util.WaypointsHelper;
import xaeroplus.util.WaystonesHelper;

@Module.ModuleInfo
public class WaystoneSync
extends Module {
    private boolean subscribed = false;
    private BlayWaystonesHelper blayWaystonesHelper = new BlayWaystonesHelper();
    int fwaystonesTickC = 0;
    private ColorHelper.WaystoneColor color = ColorHelper.WaystoneColor.RANDOM;
    private boolean separateWaypointSet = false;

    @Override
    public void onEnable() {
        if (WaystonesHelper.isWaystonesPresent() && !this.subscribed) {
            this.subscribed = true;
            this.blayWaystonesHelper.subscribeWaystonesEvent();
        }
    }

    @Override
    public void onDisable() {
        this.blayWaystonesHelper.toSyncWaystones = new ArrayList<IWaystone>();
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (event.worldId() == null) {
            this.blayWaystonesHelper.toSyncWaystones = new ArrayList<IWaystone>();
        }
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        if (WaystonesHelper.isWaystonesPresent()) {
            if (this.blayWaystonesHelper.shouldSync && this.syncMainWaystones()) {
                this.blayWaystonesHelper.shouldSync = false;
                this.blayWaystonesHelper.toSyncWaystones = new ArrayList<IWaystone>();
            }
        } else if (WaystonesHelper.isFabricWaystonesPresent()) {
            this.syncFabricWaystones();
        }
    }

    public void syncFabricWaystones() {
        if (this.fwaystonesTickC++ % 20 != 0) {
            return;
        }
        if (this.fwaystonesTickC > 100) {
            this.fwaystonesTickC = 0;
        }
        this.commonWaystoneSync(FabricWaystonesHelper.getWaystones());
    }

    public boolean syncMainWaystones() {
        return this.commonWaystoneSync(this.blayWaystonesHelper.getToSyncWaystones());
    }

    public boolean commonWaystoneSync(List<Waystone> waystones) {
        try {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession == null) {
                return false;
            }
            WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
            WaypointSet waypointSet = waypointsManager.getWaypoints();
            if (waypointSet == null) {
                return false;
            }
            String currentContainerId = waypointsManager.getCurrentContainerID();
            if (waypointsManager.getCurrentWorld() == null) {
                return false;
            }
            Map<Waystone, List> waypointToWaypointsList = waystones.stream().collect(Collectors.toMap(k1 -> k1, v1 -> this.getWaypointsList((Waystone)v1, waypointsManager, currentContainerId), (v1, v2) -> v1));
            for (List list : new HashSet<List>(waypointToWaypointsList.values())) {
                list.removeIf(waypoint -> waypoint.isTemporary() && waypoint.getName().endsWith(" [Waystone]"));
            }
            for (Map.Entry entry : waypointToWaypointsList.entrySet()) {
                try {
                    this.waypointsListSync((Waystone)entry.getKey(), (List)entry.getValue());
                }
                catch (Exception e) {
                    XaeroPlus.LOGGER.error("Error syncing waystone: " + ((Waystone)entry.getKey()).name(), (Throwable)e);
                }
            }
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error syncing waystones", (Throwable)e);
            return true;
        }
    }

    private void waypointsListSync(Waystone waystone, List<Waypoint> waypointsList) {
        Waypoint waystoneWp = new Waypoint(waystone.x(), waystone.y(), waystone.z(), waystone.name() + " [Waystone]", waystone.name().isEmpty() ? "W" : waystone.name().substring(0, 1).toUpperCase(Locale.ROOT), this.getWaystoneColor(waystone), 0, true);
        ((IWaypointDimension)waystoneWp).setDimension(waystone.dimension());
        waypointsList.add(waystoneWp);
    }

    private List<Waypoint> getWaypointsList(Waystone waystone, WaypointsManager waypointsManager, String currentContainerId) {
        String waypointSetName = this.separateWaypointSet ? "Waystones" : "gui.xaero_default";
        WaypointWorld waypointWorld = this.getWaypointWorldForWaystone(waystone, waypointsManager, currentContainerId);
        WaypointSet waypointSet = (WaypointSet)waypointWorld.getSets().get(waypointSetName);
        if (waypointSet == null) {
            waypointWorld.getSets().put(waypointSetName, new WaypointSet(waypointSetName));
            waypointSet = (WaypointSet)waypointWorld.getSets().get(waypointSetName);
        }
        return waypointSet.getList();
    }

    private WaypointWorld getWaypointWorldForWaystone(Waystone waystone, WaypointsManager waypointsManager, String currentContainerId) {
        ResourceKey<Level> waystoneDimension = waystone.dimension();
        String waystoneDimensionDirectoryName = waypointsManager.getDimensionDirectoryName(waystoneDimension);
        int waystoneDim = WaypointsHelper.getDimensionForWaypointWorldKey(waystoneDimensionDirectoryName);
        WaypointWorld currentWpWorld = waypointsManager.getCurrentWorld();
        if (currentWpWorld == null) {
            throw new RuntimeException("WaystoneSync: current waypoint world is null");
        }
        if (currentWpWorld.getDimId() == waystoneDimension) {
            return currentWpWorld;
        }
        Object worldContainerSuffix = waystoneDim == Integer.MIN_VALUE ? waystoneDimension.m_135782_().m_135827_() + "$" + waystoneDimension.m_135782_().m_135815_().replace("/", "%") : String.valueOf(waystoneDim);
        WaypointWorldContainer waypointWorldContainer = waypointsManager.getWorldContainer(currentContainerId.substring(0, currentContainerId.lastIndexOf(37) + 1) + (String)worldContainerSuffix);
        WaypointWorld crossDimWaypointWorld = (WaypointWorld)waypointWorldContainer.worlds.get("waypoints");
        if (crossDimWaypointWorld == null) {
            waypointWorldContainer.worlds.put("waypoints", new WaypointWorld(waypointWorldContainer, "waypoints", waystoneDimension));
            crossDimWaypointWorld = (WaypointWorld)waypointWorldContainer.worlds.get("waypoints");
        }
        return crossDimWaypointWorld;
    }

    private int getWaystoneColor(Waystone waystone) {
        if (this.color == ColorHelper.WaystoneColor.RANDOM) {
            return Math.abs(Hashing.murmur3_128().hashUnencodedChars((CharSequence)waystone.name()).asInt()) % ModSettings.COLORS.length;
        }
        return this.color.getColorIndex();
    }

    public void setColor(ColorHelper.WaystoneColor color) {
        this.color = color;
        this.reloadStandardWaystones();
    }

    public void setWaypointSet(boolean waypointSet) {
        this.separateWaypointSet = waypointSet;
        this.reloadStandardWaystones();
    }

    public void reloadStandardWaystones() {
        this.blayWaystonesHelper.toSyncWaystones = this.blayWaystonesHelper.currentWaystones;
        this.blayWaystonesHelper.shouldSync = true;
    }

    public record Waystone(String name, ResourceKey<Level> dimension, int x, int y, int z) {
    }
}

