/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.PacketReceivedEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.render.highlights.ChunkHighlightSavingCache;
import xaeroplus.module.Module;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;

@Module.ModuleInfo
public class Portals
extends Module {
    private ChunkHighlightCache portalsCache = new ChunkHighlightLocalCache();
    private final Minecraft mc = Minecraft.m_91087_();
    private int portalsColor = ColorHelper.getColor(0, 255, 0, 100);
    private static final String DATABASE_NAME = "XaeroPlusPortals";
    private final ExecutorService searchExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("XaeroPlus-Portals-Search-%d").build());
    private static final ReferenceSet<Block> PORTAL_BLOCKS = new ReferenceOpenHashSet();

    public void setPortalsCache(Boolean disk) {
        try {
            Long2LongMap map = this.portalsCache.getHighlightsState();
            this.portalsCache.onDisable();
            this.portalsCache = disk != false ? new ChunkHighlightSavingCache(DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.portalsCache.onEnable();
                if (map != null) {
                    this.portalsCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error setting portals cache", (Throwable)e);
        }
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), new ChunkHighlightProvider(this::isPortalChunk, this::getPortalsColor));
        this.portalsCache.onEnable();
        this.searchAllLoadedChunks();
    }

    @Override
    public void onDisable() {
        this.portalsCache.onDisable();
        Globals.drawManager.unregister(this.getClass());
    }

    public boolean inUnknownDimension() {
        ResourceKey<Level> dim = ChunkUtils.getActualDimension();
        return dim != Level.f_46428_ && dim != Level.f_46429_ && dim != Level.f_46430_;
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.findPortalInChunkAsync((ChunkAccess)event.chunk());
    }

    @EventHandler
    public void onPacketReceived(PacketReceivedEvent event) {
        if (event.packet() instanceof ClientboundBlockUpdatePacket) {
            ClientboundBlockUpdatePacket packet = (ClientboundBlockUpdatePacket)event.packet();
            this.handleBlockChange(packet.m_131749_(), packet.m_131746_());
        } else if (event.packet() instanceof ClientboundSectionBlocksUpdatePacket) {
            ClientboundSectionBlocksUpdatePacket packet = (ClientboundSectionBlocksUpdatePacket)event.packet();
            packet.m_132992_(this::handleBlockChange);
        }
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (XaeroPlusSettingRegistry.portalsSaveLoadToDisk.getValue() && this.inUnknownDimension() && this.portalsCache instanceof ChunkHighlightSavingCache) {
            XaeroPlusSettingRegistry.portalsSaveLoadToDisk.setValue(false);
            XaeroPlus.LOGGER.warn("Entered unknown dimension with saving cache on, disabling disk saving");
        }
        this.portalsCache.handleWorldChange();
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.portalsCache.handleTick();
    }

    private void findPortalInChunkAsync(ChunkAccess chunk) {
        this.findPortalInChunkAsync(chunk, 0);
    }

    private void findPortalInChunkAsync(ChunkAccess chunk, int waitMs) {
        if (this.inUnknownDimension()) {
            return;
        }
        if (chunk == null) {
            return;
        }
        this.searchExecutor.execute(() -> {
            try {
                Thread.sleep(waitMs);
                int iterations = 0;
                while (iterations++ < 3 && !this.findPortalInChunk(chunk)) {
                    Thread.sleep(500L);
                }
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Error searching for portal in chunk: {}, {}", new Object[]{chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, e});
            }
        });
    }

    private boolean findPortalInChunk(ChunkAccess chunk) {
        boolean chunkHadPortal = this.portalsCache.isHighlighted(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, ChunkUtils.getActualDimension());
        boolean hasPortal = ChunkScanner.chunkContainsBlocks(chunk, PORTAL_BLOCKS, this.mc.f_91073_.m_141937_());
        if (hasPortal) {
            return this.portalsCache.addHighlight(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        }
        if (chunkHadPortal) {
            this.portalsCache.removeHighlight(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        }
        return true;
    }

    private boolean findPortalAtBlockPos(BlockPos pos) {
        if (this.mc.f_91073_ == null || this.inUnknownDimension()) {
            return false;
        }
        int chunkX = ChunkUtils.posToChunkPos(pos.m_123341_());
        int chunkZ = ChunkUtils.posToChunkPos(pos.m_123343_());
        LevelChunk worldChunk = this.mc.f_91073_.m_7726_().m_62227_(chunkX, chunkZ, false);
        if (worldChunk == null || worldChunk instanceof EmptyLevelChunk) {
            return false;
        }
        BlockState blockState = worldChunk.m_8055_(pos);
        return blockState.m_60734_() instanceof NetherPortalBlock || blockState.m_60734_() instanceof EndPortalBlock;
    }

    private void searchAllLoadedChunks() {
        if (this.mc.f_91073_ == null || this.inUnknownDimension()) {
            return;
        }
        int renderDist = (Integer)this.mc.f_91066_.m_231984_().m_231551_();
        int xMin = ChunkUtils.getPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.getPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.getPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.getPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LevelChunk chunk = this.mc.f_91073_.m_7726_().m_62227_(x, z, false);
                if (chunk instanceof EmptyLevelChunk) continue;
                this.findPortalInChunkAsync((ChunkAccess)chunk);
            }
        }
    }

    private void handleBlockChange(BlockPos pos, BlockState state) {
        int chunkZ;
        if (this.inUnknownDimension()) {
            return;
        }
        int chunkX = ChunkUtils.posToChunkPos(pos.m_123341_());
        if (this.portalsCache.isHighlighted(chunkX, chunkZ = ChunkUtils.posToChunkPos(pos.m_123343_()), ChunkUtils.getActualDimension())) {
            if (this.findPortalAtBlockPos(pos)) {
                if (this.mc.f_91073_ == null || this.mc.f_91073_.m_7726_() == null) {
                    return;
                }
                LevelChunk worldChunk = this.mc.f_91073_.m_7726_().m_62227_(chunkX, chunkZ, false);
                if (worldChunk != null && !(worldChunk instanceof EmptyLevelChunk)) {
                    this.findPortalInChunkAsync((ChunkAccess)worldChunk, 250);
                }
            }
        } else if (state.m_60734_() instanceof NetherPortalBlock || state.m_60734_() instanceof EndPortalBlock) {
            this.portalsCache.addHighlight(chunkX, chunkZ);
        }
    }

    public int getPortalsColor() {
        return this.portalsColor;
    }

    public void setRgbColor(int color) {
        this.portalsColor = ColorHelper.getColorWithAlpha(color, (int)XaeroPlusSettingRegistry.portalsAlphaSetting.getValue());
    }

    public void setAlpha(float a) {
        this.portalsColor = ColorHelper.getColorWithAlpha(this.portalsColor, (int)a);
    }

    public boolean isPortalChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.portalsCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    static {
        PORTAL_BLOCKS.add((Object)Blocks.f_50142_);
        PORTAL_BLOCKS.add((Object)Blocks.f_50257_);
        PORTAL_BLOCKS.add((Object)Blocks.f_50258_);
    }
}

