/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.gui.GuiMap;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.extensions.SeenChunksTrackingMapTileChunk;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.module.Module;
import xaeroplus.module.ModuleManager;
import xaeroplus.module.impl.NewChunks;
import xaeroplus.module.impl.OldChunks;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

@Module.ModuleInfo
public class PortalSkipDetection
extends Module {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("XaeroPlus-PortalSkipDetection-Search").setDaemon(true).build());
    private Future<?> portalSkipDetectionSearchFuture = null;
    private int portalSkipChunksColor = ColorHelper.getColor(255, 255, 255, 100);
    private final ChunkHighlightLocalCache cache = new ChunkHighlightLocalCache();
    private int windowRegionX = 0;
    private int windowRegionZ = 0;
    private int windowRegionSize = 0;
    private static final int defaultRegionWindowSize = 2;
    private boolean worldCacheInitialized = false;
    private int searchDelayTicks = 0;
    private int tickCounter = 10000;
    private int portalRadius = 15;
    private boolean oldChunksInverse = false;
    private boolean newChunks = false;
    private OldChunks oldChunksModule;
    private NewChunks newChunksModule;

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        if (!this.worldCacheInitialized || this.portalSkipDetectionSearchFuture != null && !this.portalSkipDetectionSearchFuture.isDone()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= this.searchDelayTicks) {
            this.tickCounter = 0;
            Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
            if (guiMapOptional.isPresent()) {
                GuiMap guiMap = guiMapOptional.get();
                int mapCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
                int mapCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
                int mapSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
                this.setWindow(mapCenterX, mapCenterZ, mapSize);
            } else {
                this.setWindow(ChunkUtils.getPlayerRegionX(), ChunkUtils.getPlayerRegionZ(), 2);
            }
        }
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        this.reset();
        this.initializeWorld();
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), new ChunkHighlightProvider(this::isPortalSkipChunk, this::getPortalSkipChunksColor));
        this.reset();
        this.initializeWorld();
        this.newChunksModule = ModuleManager.getModule(NewChunks.class);
        this.oldChunksModule = ModuleManager.getModule(OldChunks.class);
    }

    @Override
    public void onDisable() {
        this.reset();
        Globals.drawManager.unregister(this.getClass());
    }

    private void initializeWorld() {
        try {
            String worldId = XaeroWorldMapCore.currentSession.getMapProcessor().getCurrentWorldId();
            if (worldId == null) {
                return;
            }
            this.worldCacheInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reset() {
        this.cache.reset();
        Future<?> future = this.portalSkipDetectionSearchFuture;
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
    }

    public void setWindow(int regionX, int regionZ, int regionSize) {
        this.windowRegionX = regionX;
        this.windowRegionZ = regionZ;
        this.windowRegionSize = regionSize;
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        this.portalSkipDetectionSearchFuture = this.executorService.submit(this::searchForPortalSkipChunks);
    }

    private void searchForPortalSkipChunks() {
        try {
            int windowRegionX = this.windowRegionX;
            int windowRegionZ = this.windowRegionZ;
            int windowRegionSize = this.windowRegionSize;
            ResourceKey<Level> currentlyViewedDimension = Globals.getCurrentDimensionId();
            LongOpenHashSet portalDetectionSearchChunks = new LongOpenHashSet();
            for (int regionX = windowRegionX - windowRegionSize; regionX <= windowRegionX + windowRegionSize; ++regionX) {
                int baseChunkCoordX = ChunkUtils.regionCoordToChunkCoord(regionX);
                for (int regionZ = windowRegionZ - windowRegionSize; regionZ <= windowRegionZ + windowRegionSize; ++regionZ) {
                    int baseChunkCoordZ = ChunkUtils.regionCoordToChunkCoord(regionZ);
                    for (int chunkX = 0; chunkX < 32; ++chunkX) {
                        for (int chunkZ = 0; chunkZ < 32; ++chunkZ) {
                            int chunkPosX = baseChunkCoordX + chunkX;
                            int chunkPosZ = baseChunkCoordZ + chunkZ;
                            if (!this.isChunkSeen(chunkPosX, chunkPosZ, currentlyViewedDimension) || this.isNewishChunk(chunkPosX, chunkPosZ, currentlyViewedDimension)) continue;
                            portalDetectionSearchChunks.add(ChunkUtils.chunkPosToLong(chunkPosX, chunkPosZ));
                        }
                    }
                }
            }
            Long2LongOpenHashMap portalAreaChunks = new Long2LongOpenHashMap();
            LongIterator longIterator = portalDetectionSearchChunks.iterator();
            while (longIterator.hasNext()) {
                long chunkPos = (Long)longIterator.next();
                boolean allSeen = true;
                LongOpenHashSet portalChunkTempSet = new LongOpenHashSet();
                for (int xOffset = 0; xOffset < this.portalRadius; ++xOffset) {
                    for (int zOffset = 0; zOffset < this.portalRadius; ++zOffset) {
                        long currentChunkPos = ChunkUtils.chunkPosToLong(ChunkUtils.longToChunkX(chunkPos) + xOffset, ChunkUtils.longToChunkZ(chunkPos) + zOffset);
                        portalChunkTempSet.add(currentChunkPos);
                        if (portalDetectionSearchChunks.contains(currentChunkPos)) continue;
                        allSeen = false;
                        portalChunkTempSet.clear();
                        break;
                    }
                    if (!allSeen) break;
                }
                if (!allSeen) continue;
                portalChunkTempSet.forEach(c -> portalAreaChunks.put(c, 0L));
            }
            this.cache.replaceState(portalAreaChunks);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error searching for portal skip chunks", (Throwable)e);
        }
    }

    private boolean isNewishChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> currentlyViewedDimension) {
        if (this.newChunks && this.oldChunksInverse) {
            return this.isNewChunk(chunkPosX, chunkPosZ, currentlyViewedDimension) || this.isOldChunksInverse(chunkPosX, chunkPosZ, currentlyViewedDimension);
        }
        if (this.newChunks) {
            return this.isNewChunk(chunkPosX, chunkPosZ, currentlyViewedDimension);
        }
        if (this.oldChunksInverse) {
            return this.isOldChunksInverse(chunkPosX, chunkPosZ, currentlyViewedDimension);
        }
        return false;
    }

    private boolean isNewChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> currentlyViewedDimension) {
        if (XaeroPlusSettingRegistry.newChunksEnabledSetting.getValue() && this.newChunksModule != null) {
            return this.newChunksModule.isNewChunk(chunkPosX, chunkPosZ, currentlyViewedDimension);
        }
        return false;
    }

    private boolean isOldChunksInverse(int chunkPosX, int chunkPosZ, ResourceKey<Level> currentlyViewedDimension) {
        if (XaeroPlusSettingRegistry.oldChunksEnabledSetting.getValue() && this.oldChunksModule != null) {
            return this.oldChunksModule.isOldChunkInverse(chunkPosX, chunkPosZ, currentlyViewedDimension);
        }
        return false;
    }

    private boolean isChunkSeen(int chunkPosX, int chunkPosZ, ResourceKey<Level> currentlyViewedDimension) {
        WorldMapSession currentSession = XaeroWorldMapCore.currentSession;
        if (currentSession == null) {
            return false;
        }
        MapProcessor mapProcessor = currentSession.getMapProcessor();
        if (mapProcessor == null) {
            return false;
        }
        MapRegion mapRegion = mapProcessor.getLeafMapRegion(mapProcessor.getCurrentCaveLayer(), ChunkUtils.chunkCoordToMapRegionCoord(chunkPosX), ChunkUtils.chunkCoordToMapRegionCoord(chunkPosZ), false);
        if (mapRegion == null) {
            return false;
        }
        MapTileChunk mapChunk = mapRegion.getChunk(ChunkUtils.chunkCoordToMapTileChunkCoordLocal(chunkPosX), ChunkUtils.chunkCoordToMapTileChunkCoordLocal(chunkPosZ));
        if (mapChunk == null) {
            return false;
        }
        return ((SeenChunksTrackingMapTileChunk)mapChunk).getSeenTiles()[ChunkUtils.chunkCoordToMapTileCoordLocal(chunkPosX)][ChunkUtils.chunkCoordToMapTileCoordLocal(chunkPosZ)];
    }

    public int getPortalSkipChunksColor() {
        return this.portalSkipChunksColor;
    }

    public void setRgbColor(int color) {
        this.portalSkipChunksColor = ColorHelper.getColorWithAlpha(color, (int)XaeroPlusSettingRegistry.portalSkipDetectionAlphaSetting.getValue());
    }

    public void setAlpha(float a) {
        this.portalSkipChunksColor = ColorHelper.getColorWithAlpha(this.portalSkipChunksColor, (int)a);
    }

    public boolean isPortalSkipChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimension) {
        return this.isPortalSkipChunk(ChunkUtils.chunkPosToLong(chunkPosX, chunkPosZ));
    }

    public boolean isPortalSkipChunk(long chunkPos) {
        return this.cache.isHighlighted(chunkPos);
    }

    public void setSearchDelayTicks(float delay) {
        this.searchDelayTicks = (int)delay;
    }

    public void setOldChunksInverse(Boolean b) {
        this.oldChunksInverse = b;
    }

    public void setNewChunks(Boolean b) {
        this.newChunks = b;
    }

    public void setPortalRadius(Float b) {
        this.portalRadius = b.intValue();
    }
}

