/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.render.highlights.ChunkHighlightSavingCache;
import xaeroplus.module.Module;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;

@Module.ModuleInfo
public class OldChunks
extends Module {
    private ChunkHighlightCache oldChunksCache = new ChunkHighlightLocalCache();
    private ChunkHighlightCache modernChunksCache = new ChunkHighlightLocalCache();
    private static final String OLD_CHUNKS_DATABASE_NAME = "XaeroPlusOldChunks";
    private static final String MODERN_CHUNKS_DATABASE_NAME = "XaeroPlusModernChunks";
    private int oldChunksColor = ColorHelper.getColor(0, 0, 255, 100);
    private final Minecraft mc = Minecraft.m_91087_();
    private final ExecutorService searchExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("XaeroPlus-OldChunks-Search-%d").build());
    private boolean inverse = false;
    private static final ReferenceSet<Block> OVERWORLD_BLOCKS = new ReferenceOpenHashSet();
    private static final ReferenceSet<Block> NETHER_BLOCKS = new ReferenceOpenHashSet();

    public void setOldChunksCache(boolean disk) {
        Long2LongMap map;
        try {
            map = this.oldChunksCache.getHighlightsState();
            this.oldChunksCache.onDisable();
            this.oldChunksCache = disk ? new ChunkHighlightSavingCache(OLD_CHUNKS_DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.oldChunksCache.onEnable();
                if (map != null) {
                    this.oldChunksCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error closing old chunks cache", (Throwable)e);
        }
        try {
            map = this.modernChunksCache.getHighlightsState();
            this.modernChunksCache.onDisable();
            this.modernChunksCache = disk ? new ChunkHighlightSavingCache(MODERN_CHUNKS_DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.modernChunksCache.onEnable();
                if (map != null) {
                    this.modernChunksCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error closing modern chunks cache", (Throwable)e);
        }
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.searchChunkAsync((ChunkAccess)event.chunk());
    }

    private void searchChunkAsync(ChunkAccess chunk) {
        this.searchExecutor.submit(() -> {
            try {
                int iterations = 0;
                while (iterations++ < 3 && !this.searchChunk(chunk)) {
                    Thread.sleep(500L);
                }
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Error searching for OldChunk in chunk: {}, {}", new Object[]{chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_, e});
            }
        });
    }

    private boolean searchChunk(ChunkAccess chunk) {
        ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
        if (actualDimension != Level.f_46428_ && actualDimension != Level.f_46429_) {
            return true;
        }
        if (ChunkScanner.chunkContainsBlocks(chunk, actualDimension == Level.f_46428_ ? OVERWORLD_BLOCKS : NETHER_BLOCKS, 5)) {
            return this.modernChunksCache.addHighlight(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        }
        return this.oldChunksCache.addHighlight(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (XaeroPlusSettingRegistry.oldChunksSaveLoadToDisk.getValue() && this.inUnknownDimension() && this.oldChunksCache instanceof ChunkHighlightSavingCache) {
            XaeroPlusSettingRegistry.oldChunksSaveLoadToDisk.setValue(false);
            XaeroPlus.LOGGER.warn("Entered unknown dimension with saving cache on, disabling disk saving");
        }
        this.oldChunksCache.handleWorldChange();
        this.modernChunksCache.handleWorldChange();
    }

    public boolean inUnknownDimension() {
        ResourceKey<Level> dim = ChunkUtils.getActualDimension();
        return dim != Level.f_46428_ && dim != Level.f_46429_ && dim != Level.f_46430_;
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.oldChunksCache.handleTick();
        this.modernChunksCache.handleTick();
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), new ChunkHighlightProvider(this::isHighlighted, this::getOldChunksColor));
        this.oldChunksCache.onEnable();
        this.modernChunksCache.onEnable();
        this.searchAllLoadedChunks();
    }

    private void searchAllLoadedChunks() {
        if (this.mc.f_91073_ == null || this.inUnknownDimension()) {
            return;
        }
        int renderDist = (Integer)this.mc.f_91066_.m_231984_().m_231551_();
        int xMin = ChunkUtils.getPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.getPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.getPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.getPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                LevelChunk chunk = this.mc.f_91073_.m_7726_().m_62227_(x, z, false);
                if (chunk instanceof EmptyLevelChunk) continue;
                this.searchChunkAsync((ChunkAccess)chunk);
            }
        }
    }

    @Override
    public void onDisable() {
        this.oldChunksCache.onDisable();
        this.modernChunksCache.onDisable();
        Globals.drawManager.unregister(this.getClass());
    }

    public int getOldChunksColor() {
        return this.oldChunksColor;
    }

    public void setRgbColor(int color) {
        this.oldChunksColor = ColorHelper.getColorWithAlpha(color, (int)XaeroPlusSettingRegistry.oldChunksAlphaSetting.getValue());
    }

    public void setAlpha(float a) {
        this.oldChunksColor = ColorHelper.getColorWithAlpha(this.oldChunksColor, (int)a);
    }

    public boolean isHighlighted(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        if (this.inverse) {
            return this.isOldChunkInverse(chunkPosX, chunkPosZ, dimensionId);
        }
        return this.isOldChunk(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isOldChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.oldChunksCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isOldChunkInverse(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.modernChunksCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public void setInverse(Boolean b) {
        this.inverse = b;
    }

    static {
        OVERWORLD_BLOCKS.addAll(Arrays.asList(Blocks.f_152505_, Blocks.f_152506_, Blocks.f_152490_, Blocks.f_152597_, Blocks.f_152496_, Blocks.f_50575_, Blocks.f_50576_, Blocks.f_152588_, Blocks.f_152537_, Blocks.f_152550_, Blocks.f_152541_, Blocks.f_152545_, Blocks.f_152546_, Blocks.f_152547_, Blocks.f_152544_, Blocks.f_152538_, Blocks.f_152539_));
        NETHER_BLOCKS.addAll(Arrays.asList(Blocks.f_50722_, Blocks.f_50730_, Blocks.f_50137_, Blocks.f_50699_, Blocks.f_50690_, Blocks.f_49998_, Blocks.f_50184_));
    }
}

