/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointFilterParams;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.common.settings.ModSettings;
import xaeroplus.feature.extensions.CustomWaypointsIngameRenderer;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.mixin.client.mc.AccessorWorldRenderer;
import xaeroplus.settings.XaeroPlusSettingRegistry;

@Mixin(value={WaypointsIngameRenderer.class}, remap=false)
public class MixinWaypointsIngameRenderer
implements CustomWaypointsIngameRenderer {
    @Shadow
    private List<Waypoint> sortingList;
    @Shadow
    private WaypointFilterParams filterParams;
    List<Waypoint> beaconWaypoints = new ArrayList<Waypoint>();
    final Predicate<Waypoint> beaconViewFilter = new Predicate<Waypoint>(){

        @Override
        public boolean test(Waypoint w) {
            boolean deathpoints = MixinWaypointsIngameRenderer.this.filterParams.deathpoints;
            if (!w.isDisabled() && w.getVisibilityType() != 2 && w.getVisibilityType() != 3 && (w.getWaypointType() != 1 && w.getWaypointType() != 2 || deathpoints)) {
                double offX = (double)w.getX(MixinWaypointsIngameRenderer.this.filterParams.dimDiv) - MixinWaypointsIngameRenderer.this.filterParams.cameraX + 0.5;
                double offZ = (double)w.getZ(MixinWaypointsIngameRenderer.this.filterParams.dimDiv) - MixinWaypointsIngameRenderer.this.filterParams.cameraZ + 0.5;
                double distanceScale = MixinWaypointsIngameRenderer.this.filterParams.dimensionScaleDistance ? Minecraft.m_91087_().f_91073_.m_6042_().f_63859_() : 1.0;
                double unscaledDistance2D = Math.sqrt(offX * offX + offZ * offZ);
                double distance2D = unscaledDistance2D * distanceScale;
                double waypointsDistance = MixinWaypointsIngameRenderer.this.filterParams.waypointsDistance;
                double waypointsDistanceMin = MixinWaypointsIngameRenderer.this.filterParams.waypointsDistanceMin;
                return w.isOneoffDestination() || (w.getWaypointType() == 1 || w.isGlobal() || w.isTemporary() && MixinWaypointsIngameRenderer.this.filterParams.temporaryWaypointsGlobal || waypointsDistance == 0.0 || !(distance2D > waypointsDistance)) && (waypointsDistanceMin == 0.0 || !(unscaledDistance2D < waypointsDistanceMin));
            }
            return false;
        }
    };

    @Inject(method={"renderWaypointsIterator"}, at={@At(value="HEAD")})
    public void injectRenderWaypoints(PoseStack matrixStack, PoseStack matrixStackOverlay, MinimapRendererHelper helper, Iterator<Waypoint> iter, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tesselator tessellator, double dimDiv, double actualEntityX, double actualEntityY, double actualEntityZ, double smoothEntityY, double fov, int screenHeight, float cameraAngleYaw, float cameraAnglePitch, Vector3f lookVector, double clampDepth, MultiBufferSource.BufferSource renderTypeBuffer, VertexConsumer waypointBackgroundConsumer, Font fontrenderer, Matrix4f waypointsProjection, int screenWidth, boolean detailedDisplayAllowed, double minDistance, String subworldName, CallbackInfo ci) {
        this.beaconWaypoints = this.sortingList.stream().filter(this.beaconViewFilter).sorted().collect(Collectors.toList());
    }

    @Override
    public void renderWaypointBeacons(XaeroMinimapSession minimapSession, PoseStack matrixStack, float tickDelta) {
        if (!XaeroPlusSettingRegistry.waypointBeacons.getValue()) {
            return;
        }
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        double dimDiv = waypointsManager.getDimensionDivision(waypointsManager.getCurrentContainerID());
        this.beaconWaypoints.forEach(w -> this.renderWaypointBeacon((Waypoint)w, dimDiv, tickDelta, matrixStack));
        this.beaconWaypoints.clear();
    }

    public void renderWaypointBeacon(Waypoint waypoint, double dimDiv, float tickDelta, PoseStack matrixStack) {
        Vec3 waypointVec;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        Vec3 playerVec = mc.f_91074_.m_20182_();
        double xzDistance = playerVec.m_82554_(waypointVec = new Vec3((double)waypoint.getX(dimDiv), playerVec.f_82480_, (double)waypoint.getZ(dimDiv)));
        if (xzDistance < (double)((int)XaeroPlusSettingRegistry.waypointBeaconDistanceMin.getValue())) {
            return;
        }
        int farScale = (int)XaeroPlusSettingRegistry.waypointBeaconScaleMin.getValue();
        double maxRenderDistance = Math.min((Integer)mc.f_91066_.m_231984_().m_231551_() << 4, farScale == 0 ? Integer.MAX_VALUE : farScale << 4);
        if (xzDistance > maxRenderDistance) {
            Vec3 delta = waypointVec.m_82546_(playerVec).m_82541_();
            waypointVec = playerVec.m_82549_(new Vec3(delta.f_82479_ * maxRenderDistance, delta.f_82480_ * maxRenderDistance, delta.f_82481_ * maxRenderDistance));
        }
        EntityRenderDispatcher entityRenderDispatcher = mc.m_91290_();
        Camera camera = entityRenderDispatcher.f_114358_;
        Frustum frustum = ((AccessorWorldRenderer)mc.f_91060_).getFrustum();
        if (camera == null || frustum == null) {
            return;
        }
        double viewX = camera.m_90583_().m_7096_();
        double viewZ = camera.m_90583_().m_7094_();
        double x = waypointVec.f_82479_ - viewX;
        double z = waypointVec.f_82481_ - viewZ;
        double y = -100.0;
        if (!frustum.m_113029_(new AABB(waypointVec.f_82479_ - 1.0, -100.0, waypointVec.f_82481_ - 1.0, waypointVec.f_82479_ + 1.0, 500.0, waypointVec.f_82481_ + 1.0))) {
            return;
        }
        int color = ModSettings.COLORS[waypoint.getColor()];
        MultiBufferSource.BufferSource entityVertexConsumers = mc.m_91269_().m_110104_();
        long time = mc.f_91073_.m_46467_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(x, -100.0, z);
        BeaconRenderer.m_112184_((PoseStack)matrixStack, (MultiBufferSource)entityVertexConsumers, (ResourceLocation)BeaconRenderer.f_112102_, (float)tickDelta, (float)1.0f, (long)time, (int)0, (int)355, (float[])ColorHelper.getColorRGBA(color), (float)0.2f, (float)0.25f);
        matrixStack.m_85849_();
    }
}

